/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1 MySQL
 Source Server Type    : MySQL
 Source Server Version : 80026
 Source Host           : localhost:3306
 Source Schema         : ruoyi-vue-pro-master

 Target Server Type    : MySQL
 Target Server Version : 80026
 File Encoding         : 65001

 Date: 02/03/2023 00:13:17
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for infra_api_access_log
-- ----------------------------
DROP TABLE IF EXISTS `infra_api_access_log`;
CREATE TABLE `infra_api_access_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `trace_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '链路追踪编号',
  `user_id` bigint NOT NULL DEFAULT '0' COMMENT '用户编号',
  `user_type` tinyint NOT NULL DEFAULT '0' COMMENT '用户类型',
  `application_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用名',
  `request_method` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求方法名',
  `request_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求地址',
  `request_params` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求参数',
  `user_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户 IP',
  `user_agent` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '浏览器 UA',
  `begin_time` datetime NOT NULL COMMENT '开始请求时间',
  `end_time` datetime NOT NULL COMMENT '结束请求时间',
  `duration` int NOT NULL COMMENT '执行时长',
  `result_code` int NOT NULL DEFAULT '0' COMMENT '结果码',
  `result_msg` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '结果提示',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35832 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='API 访问日志表';

-- ----------------------------
-- Records of infra_api_access_log
-- ----------------------------
BEGIN;
INSERT INTO `infra_api_access_log` (`id`, `trace_id`, `user_id`, `user_type`, `application_name`, `request_method`, `request_url`, `request_params`, `user_ip`, `user_agent`, `begin_time`, `end_time`, `duration`, `result_code`, `result_msg`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (35827, '', 1, 2, 'system-server', 'GET', '/admin-api/system/dict-data/list-all-simple', '{\"query\":{},\"body\":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36', '2022-12-30 13:50:12', '2022-12-30 13:50:12', 0, 0, '', NULL, '2022-12-30 13:50:12', NULL, '2022-12-30 13:50:12', b'0', 1);
INSERT INTO `infra_api_access_log` (`id`, `trace_id`, `user_id`, `user_type`, `application_name`, `request_method`, `request_url`, `request_params`, `user_ip`, `user_agent`, `begin_time`, `end_time`, `duration`, `result_code`, `result_msg`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (35828, '', 1, 2, 'system-server', 'GET', '/admin-api/system/auth/get-permission-info', '{\"query\":{},\"body\":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36', '2022-12-30 13:50:12', '2022-12-30 13:50:12', 0, 0, '', NULL, '2022-12-30 13:50:12', NULL, '2022-12-30 13:50:12', b'0', 1);
INSERT INTO `infra_api_access_log` (`id`, `trace_id`, `user_id`, `user_type`, `application_name`, `request_method`, `request_url`, `request_params`, `user_ip`, `user_agent`, `begin_time`, `end_time`, `duration`, `result_code`, `result_msg`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (35829, '', 1, 2, 'system-server', 'GET', '/admin-api/system/auth/list-menus', '{\"query\":{},\"body\":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36', '2022-12-30 13:50:12', '2022-12-30 13:50:12', 0, 0, '', NULL, '2022-12-30 13:50:12', NULL, '2022-12-30 13:50:12', b'0', 1);
INSERT INTO `infra_api_access_log` (`id`, `trace_id`, `user_id`, `user_type`, `application_name`, `request_method`, `request_url`, `request_params`, `user_ip`, `user_agent`, `begin_time`, `end_time`, `duration`, `result_code`, `result_msg`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (35830, '', 1, 2, 'system-server', 'GET', '/admin-api/system/tenant-package/get-simple-list', '{\"query\":{},\"body\":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36', '2022-12-30 13:50:13', '2022-12-30 13:50:13', 0, 0, '', NULL, '2022-12-30 13:50:13', NULL, '2022-12-30 13:50:13', b'0', 1);
INSERT INTO `infra_api_access_log` (`id`, `trace_id`, `user_id`, `user_type`, `application_name`, `request_method`, `request_url`, `request_params`, `user_ip`, `user_agent`, `begin_time`, `end_time`, `duration`, `result_code`, `result_msg`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (35831, '', 1, 2, 'system-server', 'GET', '/admin-api/system/tenant/page', '{\"query\":{\"pageNo\":\"1\",\"pageSize\":\"10\"},\"body\":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36', '2022-12-30 13:50:13', '2022-12-30 13:50:13', 0, 0, '', NULL, '2022-12-30 13:50:13', NULL, '2022-12-30 13:50:13', b'0', 1);
COMMIT;

-- ----------------------------
-- Table structure for infra_api_error_log
-- ----------------------------
DROP TABLE IF EXISTS `infra_api_error_log`;
CREATE TABLE `infra_api_error_log` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '编号',
  `trace_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '链路追踪编号\n     *\n     * 一般来说，通过链路追踪编号，可以将访问日志，错误日志，链路追踪日志，logger 打印日志等，结合在一起，从而进行排错。',
  `user_id` int NOT NULL DEFAULT '0' COMMENT '用户编号',
  `user_type` tinyint NOT NULL DEFAULT '0' COMMENT '用户类型',
  `application_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用名\n     *\n     * 目前读取 spring.application.name',
  `request_method` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '请求方法名',
  `request_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '请求地址',
  `request_params` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '请求参数',
  `user_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户 IP',
  `user_agent` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '浏览器 UA',
  `exception_time` datetime NOT NULL COMMENT '异常发生时间',
  `exception_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '异常名\n     *\n     * {@link Throwable#getClass()} 的类全名',
  `exception_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常导致的消息\n     *\n     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getMessage(Throwable)}',
  `exception_root_cause_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常导致的根消息\n     *\n     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getRootCauseMessage(Throwable)}',
  `exception_stack_trace` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常的栈轨迹\n     *\n     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getServiceException(Exception)}',
  `exception_class_name` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常发生的类全名\n     *\n     * {@link StackTraceElement#getClassName()}',
  `exception_file_name` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常发生的类文件\n     *\n     * {@link StackTraceElement#getFileName()}',
  `exception_method_name` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '异常发生的方法名\n     *\n     * {@link StackTraceElement#getMethodName()}',
  `exception_line_number` int NOT NULL COMMENT '异常发生的方法所在行\n     *\n     * {@link StackTraceElement#getLineNumber()}',
  `process_status` tinyint NOT NULL COMMENT '处理状态',
  `process_time` datetime DEFAULT NULL COMMENT '处理时间',
  `process_user_id` int DEFAULT '0' COMMENT '处理用户编号',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统异常日志';

-- ----------------------------
-- Records of infra_api_error_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for infra_codegen_column
-- ----------------------------
DROP TABLE IF EXISTS `infra_codegen_column`;
CREATE TABLE `infra_codegen_column` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` bigint NOT NULL COMMENT '表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '字段名',
  `data_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '字段类型',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '字段描述',
  `nullable` bit(1) NOT NULL COMMENT '是否允许为空',
  `primary_key` bit(1) NOT NULL COMMENT '是否主键',
  `auto_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否自增',
  `ordinal_position` int NOT NULL COMMENT '排序',
  `java_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Java 属性类型',
  `java_field` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Java 属性名',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典类型',
  `example` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '数据示例',
  `create_operation` bit(1) NOT NULL COMMENT '是否为 Create 创建操作的字段',
  `update_operation` bit(1) NOT NULL COMMENT '是否为 Update 更新操作的字段',
  `list_operation` bit(1) NOT NULL COMMENT '是否为 List 查询操作的字段',
  `list_operation_condition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '=' COMMENT 'List 查询操作的条件类型',
  `list_operation_result` bit(1) NOT NULL COMMENT '是否为 List 查询操作的返回字段',
  `html_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '显示类型',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1640 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代码生成表字段定义';

-- ----------------------------
-- Records of infra_codegen_column
-- ----------------------------
BEGIN;
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1506, 117, 'id', 'bigint', '编号', b'0', b'1', '1', 1, 'Long', 'id', '', NULL, b'0', b'1', b'0', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1507, 117, 'name', 'varchar(64)', '表单名', b'0', b'0', '0', 2, 'String', 'name', '', NULL, b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1508, 117, 'status', 'tinyint', '开启状态', b'0', b'0', '0', 3, 'Integer', 'status', '', NULL, b'1', b'1', b'1', '=', b'1', 'radio', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1509, 117, 'conf', 'varchar(1000)', '表单的配置', b'0', b'0', '0', 4, 'String', 'conf', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1510, 117, 'fields', 'varchar(5000)', '表单项的数组', b'0', b'0', '0', 5, 'String', 'fields', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1511, 117, 'remark', 'varchar(255)', '备注', b'1', b'0', '0', 6, 'String', 'remark', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1512, 117, 'creator', 'varchar(64)', '创建者', b'1', b'0', '0', 7, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1513, 117, 'create_time', 'datetime', '创建时间', b'0', b'0', '0', 8, 'Date', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1514, 117, 'updater', 'varchar(64)', '更新者', b'1', b'0', '0', 9, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1515, 117, 'update_time', 'datetime', '更新时间', b'0', b'0', '0', 10, 'Date', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1516, 117, 'deleted', 'bit(1)', '是否删除', b'0', b'0', '0', 11, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1517, 117, 'tenant_id', 'bigint', '租户编号', b'0', b'0', '0', 12, 'Long', 'tenantId', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1518, 118, 'id', 'bigint', '请假表单主键', b'0', b'1', '1', 1, 'Long', 'id', '', NULL, b'0', b'1', b'0', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1519, 118, 'user_id', 'bigint', '申请人的用户编号', b'0', b'0', '0', 2, 'Long', 'userId', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1520, 118, 'type', 'tinyint', '请假类型', b'0', b'0', '0', 3, 'Integer', 'type', '', NULL, b'1', b'1', b'1', '=', b'1', 'select', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1521, 118, 'reason', 'varchar(200)', '请假原因', b'0', b'0', '0', 4, 'String', 'reason', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1522, 118, 'start_time', 'datetime', '开始时间', b'0', b'0', '0', 5, 'Date', 'startTime', '', NULL, b'1', b'1', b'1', 'BETWEEN', b'1', 'datetime', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1523, 118, 'end_time', 'datetime', '结束时间', b'0', b'0', '0', 6, 'Date', 'endTime', '', NULL, b'1', b'1', b'1', 'BETWEEN', b'1', 'datetime', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1524, 118, 'day', 'tinyint', '请假天数', b'0', b'0', '0', 7, 'Integer', 'day', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1525, 118, 'result', 'tinyint', '请假结果', b'0', b'0', '0', 8, 'Integer', 'result', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1526, 118, 'process_instance_id', 'varchar(64)', '流程实例的编号', b'1', b'0', '0', 9, 'String', 'processInstanceId', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1527, 118, 'creator', 'varchar(64)', '创建者', b'1', b'0', '0', 10, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1528, 118, 'create_time', 'datetime', '创建时间', b'0', b'0', '0', 11, 'Date', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1529, 118, 'updater', 'varchar(64)', '更新者', b'1', b'0', '0', 12, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1530, 118, 'update_time', 'datetime', '更新时间', b'0', b'0', '0', 13, 'Date', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1531, 118, 'deleted', 'bit(1)', '是否删除', b'0', b'0', '0', 14, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1532, 118, 'tenant_id', 'bigint', '租户编号', b'0', b'0', '0', 15, 'Long', 'tenantId', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2022-12-30 19:01:30', '1', '2022-12-30 19:01:30', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1533, 119, 'id', 'BIGINT', '主键', b'0', b'1', '1', 1, 'Long', 'id', '', '32581', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1534, 119, 'mail', 'VARCHAR', '邮箱', b'0', b'0', '0', 2, 'String', 'mail', '', NULL, b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1535, 119, 'username', 'VARCHAR', '用户名', b'0', b'0', '0', 3, 'String', 'username', '', '芋艿', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1536, 119, 'password', 'VARCHAR', '密码', b'0', b'0', '0', 4, 'String', 'password', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1537, 119, 'host', 'VARCHAR', '主机', b'0', b'0', '0', 5, 'String', 'host', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1538, 119, 'port', 'INTEGER', '端口', b'0', b'0', '0', 6, 'Integer', 'port', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1539, 119, 'ssl_enable', 'BIT', '是否开启 SSL', b'0', b'0', '0', 7, 'Boolean', 'sslEnable', '', NULL, b'1', b'1', b'0', '=', b'1', 'radio', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1540, 119, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 8, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1541, 119, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 9, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'1', 'datetime', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1542, 119, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 10, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1543, 119, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 11, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1544, 119, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 12, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1545, 119, 'tenant_id', 'BIGINT', '租户编号', b'0', b'0', '0', 13, 'Long', 'tenantId', '', '16595', b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1546, 120, 'id', 'BIGINT', '编号', b'0', b'1', '1', 1, 'Long', 'id', '', '28179', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1547, 120, 'name', 'VARCHAR', '模板名称', b'0', b'0', '0', 2, 'String', 'name', '', '赵六', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1548, 120, 'code', 'VARCHAR', '模板编码', b'0', b'0', '0', 3, 'String', 'code', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1549, 120, 'account_id', 'BIGINT', '发送的邮箱账号编号', b'0', b'0', '0', 4, 'Long', 'accountId', '', '31981', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1550, 120, 'nickname', 'VARCHAR', '发送人名称', b'1', b'0', '0', 5, 'String', 'nickname', '', '芋艿', b'1', b'1', b'0', 'LIKE', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1551, 120, 'title', 'VARCHAR', '模板标题', b'0', b'0', '0', 6, 'String', 'title', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1552, 120, 'content', 'VARCHAR', '模板内容', b'0', b'0', '0', 7, 'String', 'content', '', NULL, b'1', b'1', b'0', '=', b'1', 'editor', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1553, 120, 'params', 'VARCHAR', '参数数组', b'0', b'0', '0', 8, 'String', 'params', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1554, 120, 'status', 'TINYINT', '开启状态', b'0', b'0', '0', 9, 'Byte', 'status', '', '1', b'1', b'1', b'1', '=', b'1', 'radio', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1555, 120, 'remark', 'VARCHAR', '备注', b'1', b'0', '0', 10, 'String', 'remark', '', '你猜', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1556, 120, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 11, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1557, 120, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 12, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1558, 120, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 13, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1559, 120, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 14, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1560, 120, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 15, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1561, 121, 'id', 'BIGINT', '编号', b'0', b'1', '1', 1, 'Long', 'id', '', '31020', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1562, 121, 'user_id', 'BIGINT', '用户编号', b'1', b'0', '0', 2, 'Long', 'userId', '', '30883', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1563, 121, 'user_type', 'TINYINT', '用户类型', b'1', b'0', '0', 3, 'Byte', 'userType', '', '2', b'1', b'1', b'1', '=', b'1', 'select', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1564, 121, 'to_mail', 'VARCHAR', '接收邮箱地址', b'0', b'0', '0', 4, 'String', 'toMail', '', '76854@qq.com', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1565, 121, 'account_id', 'BIGINT', '邮箱账号编号', b'0', b'0', '0', 5, 'Long', 'accountId', '', '18107', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1566, 121, 'from_mail', 'VARCHAR', '发送邮箱地址', b'0', b'0', '0', 6, 'String', 'fromMail', '', '85757@qq.com', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1567, 121, 'template_id', 'BIGINT', '模板编号', b'0', b'0', '0', 7, 'Long', 'templateId', '', '5678', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1568, 121, 'template_code', 'VARCHAR', '模板编码', b'0', b'0', '0', 8, 'String', 'templateCode', '', 'test_01', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1569, 121, 'template_nickname', 'VARCHAR', '模版发送人名称', b'1', b'0', '0', 9, 'String', 'templateNickname', '', '李四', b'1', b'1', b'0', 'LIKE', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1570, 121, 'template_title', 'VARCHAR', '邮件标题', b'0', b'0', '0', 10, 'String', 'templateTitle', '', '测试标题', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1571, 121, 'template_content', 'VARCHAR', '邮件内容', b'0', b'0', '0', 11, 'String', 'templateContent', '', '测试内容', b'1', b'1', b'0', '=', b'1', 'editor', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1572, 121, 'template_params', 'VARCHAR', '短信参数', b'0', b'0', '0', 12, 'String', 'templateParams', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1573, 121, 'send_status', 'TINYINT', '发送状态', b'0', b'0', '0', 13, 'Byte', 'sendStatus', 'system_mail_send_status', '1', b'1', b'1', b'1', '=', b'1', 'select', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1574, 121, 'send_time', 'TIMESTAMP', '发送时间', b'1', b'0', '0', 14, 'LocalDateTime', 'sendTime', '', NULL, b'1', b'1', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1575, 121, 'send_message_id', 'VARCHAR', '发送返回的消息 ID', b'1', b'0', '0', 15, 'String', 'sendMessageId', '', '28568', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1576, 121, 'send_exception', 'VARCHAR', '发送异常', b'1', b'0', '0', 16, 'String', 'sendException', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1577, 121, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 17, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1578, 121, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 18, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'1', 'datetime', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1579, 121, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 19, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1580, 121, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 20, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1581, 121, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 21, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1582, 122, 'id', 'BIGINT', '主键', b'0', b'1', '1', 1, 'Long', 'id', '', '12079', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1583, 122, 'name', 'VARCHAR', '模板名称', b'0', b'0', '0', 2, 'String', 'name', '', '李四', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1584, 122, 'code', 'VARCHAR', '模版编码', b'0', b'0', '0', 3, 'String', 'code', '', NULL, b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1585, 122, 'content', 'VARCHAR', '模版内容', b'0', b'0', '0', 4, 'String', 'content', '', NULL, b'1', b'1', b'0', '=', b'1', 'editor', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1586, 122, 'type', 'TINYINT', '类型', b'0', b'0', '0', 5, 'Byte', 'type', 'system_notify_template_type', '2', b'1', b'1', b'0', '=', b'1', 'select', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1587, 122, 'params', 'VARCHAR', '参数数组', b'1', b'0', '0', 6, 'String', 'params', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1588, 122, 'status', 'TINYINT', '状态', b'0', b'0', '0', 7, 'Byte', 'status', 'common_status', '2', b'1', b'1', b'1', '=', b'1', 'radio', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1589, 122, 'remark', 'VARCHAR', '备注', b'1', b'0', '0', 8, 'String', 'remark', '', '你说的对', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1590, 122, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 9, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1591, 122, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 10, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1592, 122, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 11, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1593, 122, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 12, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1594, 122, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 13, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1595, 123, 'id', 'BIGINT', '用户ID', b'0', b'1', '1', 1, 'Long', 'id', '', '28696', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1596, 123, 'user_id', 'BIGINT', '用户id', b'0', b'0', '0', 2, 'Long', 'userId', '', '25025', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1597, 123, 'user_type', 'TINYINT', '用户类型', b'0', b'0', '0', 3, 'Byte', 'userType', 'user_type', '1', b'1', b'1', b'1', '=', b'1', 'select', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1598, 123, 'template_id', 'BIGINT', '模版编号', b'0', b'0', '0', 4, 'Long', 'templateId', '', '13013', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1599, 123, 'template_code', 'VARCHAR', '模板编码', b'0', b'0', '0', 5, 'String', 'templateCode', '', 'test_01', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1600, 123, 'template_nickname', 'VARCHAR', '模版发送人名称', b'0', b'0', '0', 6, 'String', 'templateNickname', '', '芋艿', b'1', b'1', b'0', 'LIKE', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1601, 123, 'template_content', 'VARCHAR', '模版内容', b'0', b'0', '0', 7, 'String', 'templateContent', '', '测试内容', b'1', b'1', b'0', '=', b'1', 'editor', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1602, 123, 'template_type', 'INTEGER', '模版类型', b'0', b'0', '0', 8, 'Integer', 'templateType', 'system_notify_template_type', '2', b'1', b'1', b'1', '=', b'1', 'select', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1603, 123, 'template_params', 'VARCHAR', '模版参数', b'0', b'0', '0', 9, 'String', 'templateParams', '', NULL, b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1604, 123, 'read_status', 'BIT', '是否已读', b'0', b'0', '0', 10, 'Boolean', 'readStatus', '', '2', b'1', b'1', b'0', '=', b'1', 'radio', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1605, 123, 'read_time', 'TIMESTAMP', '阅读时间', b'1', b'0', '0', 11, 'LocalDateTime', 'readTime', '', NULL, b'1', b'1', b'0', 'BETWEEN', b'1', 'datetime', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1606, 123, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 12, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1607, 123, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 13, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1608, 123, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 14, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1609, 123, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 15, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1610, 123, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 16, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1611, 123, 'tenant_id', 'BIGINT', '租户编号', b'0', b'0', '0', 17, 'Long', 'tenantId', '', '18860', b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:06', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1612, 124, 'id', 'BIGINT', '编号', b'0', b'1', '1', 1, 'Long', 'id', '', '18993', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1613, 124, 'name', 'VARCHAR', '项目名称', b'0', b'0', '0', 2, 'String', 'name', '', '王五', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1614, 124, 'pic_url', 'VARCHAR', '预览图片 URL', b'1', b'0', '0', 3, 'String', 'picUrl', '', 'https://www.iocoder.cn', b'1', b'1', b'0', '=', b'1', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1615, 124, 'content', 'LONGVARCHAR', '报表内容', b'1', b'0', '0', 4, 'String', 'content', '', NULL, b'1', b'1', b'0', '=', b'1', 'editor', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1616, 124, 'status', 'TINYINT', '发布状态', b'0', b'0', '0', 5, 'Byte', 'status', '', '1', b'0', b'1', b'1', '=', b'1', 'radio', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1617, 124, 'remark', 'VARCHAR', '项目备注', b'1', b'0', '0', 6, 'String', 'remark', '', '你猜', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1618, 124, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 7, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1619, 124, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 8, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1620, 124, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 9, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1621, 124, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 10, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1622, 124, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 11, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1623, 124, 'tenant_id', 'BIGINT', '租户编号', b'0', b'0', '0', 12, 'Long', 'tenantId', '', '2919', b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1624, 125, 'id', 'BIGINT', '用户ID', b'0', b'1', '1', 1, 'Long', 'id', '', '11867', b'0', b'1', b'0', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1625, 125, 'user_id', 'BIGINT', '用户编号', b'0', b'0', '0', 2, 'Long', 'userId', '', '23199', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1626, 125, 'spu_id', 'BIGINT', '商品编号', b'0', b'0', '0', 3, 'Long', 'spuId', '', '17682', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1627, 125, 'spu_name', 'VARCHAR', '商家备注', b'1', b'0', '0', 4, 'String', 'spuName', '', '李四', b'1', b'1', b'1', 'LIKE', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1628, 125, 'price', 'INTEGER', '价格，单位：分', b'0', b'0', '0', 5, 'Integer', 'price', '', '30381', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1629, 125, 'payed', 'BIT', '是否已支付：[0:未支付 1:已经支付过]', b'0', b'0', '0', 6, 'Boolean', 'payed', '', NULL, b'1', b'1', b'1', '=', b'1', 'radio', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1630, 125, 'pay_order_id', 'BIGINT', '支付订单编号', b'1', b'0', '0', 7, 'Long', 'payOrderId', '', '16863', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1631, 125, 'pay_time', 'TIMESTAMP', '订单支付时间', b'1', b'0', '0', 8, 'LocalDateTime', 'payTime', '', NULL, b'1', b'1', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1632, 125, 'refund_price', 'INTEGER', '退款金额，单位：分', b'0', b'0', '0', 9, 'Integer', 'refundPrice', '', '14039', b'1', b'1', b'1', '=', b'1', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1633, 125, 'refund_time', 'TIMESTAMP', '退款时间', b'1', b'0', '0', 10, 'LocalDateTime', 'refundTime', '', NULL, b'1', b'1', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1634, 125, 'creator', 'VARCHAR', '创建者', b'1', b'0', '0', 11, 'String', 'creator', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1635, 125, 'create_time', 'TIMESTAMP', '创建时间', b'0', b'0', '0', 12, 'LocalDateTime', 'createTime', '', NULL, b'0', b'0', b'1', 'BETWEEN', b'1', 'datetime', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1636, 125, 'updater', 'VARCHAR', '更新者', b'1', b'0', '0', 13, 'String', 'updater', '', NULL, b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1637, 125, 'update_time', 'TIMESTAMP', '更新时间', b'0', b'0', '0', 14, 'LocalDateTime', 'updateTime', '', NULL, b'0', b'0', b'0', 'BETWEEN', b'0', 'datetime', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1638, 125, 'deleted', 'BIT', '是否删除', b'0', b'0', '0', 15, 'Boolean', 'deleted', '', NULL, b'0', b'0', b'0', '=', b'0', 'radio', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
INSERT INTO `infra_codegen_column` (`id`, `table_id`, `column_name`, `data_type`, `column_comment`, `nullable`, `primary_key`, `auto_increment`, `ordinal_position`, `java_type`, `java_field`, `dict_type`, `example`, `create_operation`, `update_operation`, `list_operation`, `list_operation_condition`, `list_operation_result`, `html_type`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1639, 125, 'tenant_id', 'BIGINT', '租户编号', b'0', b'0', '0', 16, 'Long', 'tenantId', '', '4388', b'0', b'0', b'0', '=', b'0', 'input', '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:20', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_codegen_table
-- ----------------------------
DROP TABLE IF EXISTS `infra_codegen_table`;
CREATE TABLE `infra_codegen_table` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `data_source_config_id` bigint NOT NULL COMMENT '数据源配置的编号',
  `scene` tinyint NOT NULL DEFAULT '1' COMMENT '生成场景',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '表描述',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '业务名',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '类名称',
  `class_comment` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '类描述',
  `author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '作者',
  `template_type` tinyint NOT NULL DEFAULT '1' COMMENT '模板类型',
  `parent_menu_id` bigint DEFAULT NULL COMMENT '父菜单编号',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代码生成表定义';

-- ----------------------------
-- Records of infra_codegen_table
-- ----------------------------
BEGIN;
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (117, 0, 1, 'bpm_form', '工作流的表单定义', NULL, 'bpm', 'form', 'Form', '工作流的表单定义', '芋道源码', 1, NULL, '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (118, 0, 1, 'bpm_oa_leave', 'OA 请假申请表', NULL, 'bpm', 'oaleave', 'OaLeave', 'OA 请假申请', '芋道源码', 1, NULL, '1', '2022-12-30 19:01:29', '1', '2022-12-30 19:01:29', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (119, 0, 1, 'system_mail_account', '邮箱账号表', NULL, 'system', 'mailaccount', 'MailAccount', '邮箱账号', '芋道源码', 1, 2130, '1', '2023-01-25 17:09:17', '1', '2023-01-26 22:17:43', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (120, 0, 1, 'system_mail_template', '邮件模版', NULL, 'system', 'mailtemplate', 'MailTemplate', '邮件模版', '芋道源码', 1, 2130, '1', '2023-01-25 19:33:53', '1', '2023-01-25 19:35:04', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (121, 0, 1, 'system_mail_log', '邮件日志表', NULL, 'system', 'maillog', 'MailLog', '邮件日志', '芋道源码', 1, 2130, '1', '2023-01-26 09:48:49', '1', '2023-01-26 16:28:47', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (122, 0, 1, 'system_notify_template', '站内信模板表', NULL, 'system', 'notifytemplate', 'NotifyTemplate', '站内信模板', '芋道源码', 1, 2144, '1', '2023-01-28 10:20:13', '1', '2023-01-28 10:36:45', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (123, 0, 1, 'system_notify_message', '站内信消息表', NULL, 'system', 'notifymessage', 'NotifyMessage', '站内信消息', '芋道源码', 1, 2144, '1', '2023-01-28 11:46:26', '1', '2023-01-28 13:55:05', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (124, 0, 1, 'report_go_view_project', 'GoView 项目表', NULL, 'report', 'goview', 'GoViewProject', 'GoView 项目', '芋道源码', 1, 1185, '1', '2023-02-05 21:38:48', '1', '2023-02-05 21:42:36', b'0');
INSERT INTO `infra_codegen_table` (`id`, `data_source_config_id`, `scene`, `table_name`, `table_comment`, `remark`, `module_name`, `business_name`, `class_name`, `class_comment`, `author`, `template_type`, `parent_menu_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (125, 0, 1, 'pay_demo_order', '示例订单', NULL, 'pay', 'demo', 'PayDemoOrder', '示例订单', '芋道源码', 1, 1117, '1', '2023-02-11 20:42:22', '1', '2023-02-11 21:32:19', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_config
-- ----------------------------
DROP TABLE IF EXISTS `infra_config`;
CREATE TABLE `infra_config` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数分组',
  `type` tinyint NOT NULL COMMENT '参数类型',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '参数键名',
  `value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '参数键值',
  `visible` bit(1) NOT NULL COMMENT '是否可见',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='参数配置表';

-- ----------------------------
-- Records of infra_config
-- ----------------------------
BEGIN;
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, 'ui', 1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', b'0', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow', 'admin', '2021-01-05 17:03:48', '1', '2022-03-26 23:10:31', b'0');
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, 'biz', 1, '用户管理-账号初始密码', 'sys.user.init-password', '123456', b'0', '初始化密码 123456', 'admin', '2021-01-05 17:03:48', '1', '2022-03-20 02:25:51', b'0');
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (3, 'ui', 1, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', b'0', '深色主题theme-dark，浅色主题theme-light', 'admin', '2021-01-05 17:03:48', '', '2021-01-19 03:05:21', b'0');
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (4, '1', 2, 'xxx', 'demo.test', '10', b'0', '5', '', '2021-01-19 03:10:26', '', '2021-01-20 09:25:55', b'0');
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5, 'xxx', 2, 'xxx', 'xxx', 'xxx', b'1', 'xxx', '', '2021-02-09 20:06:47', '', '2021-02-09 20:06:47', b'0');
INSERT INTO `infra_config` (`id`, `category`, `type`, `name`, `config_key`, `value`, `visible`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (6, 'biz', 2, '登陆验证码的开关', 'yudao.captcha.enable', 'false', b'1', NULL, '1', '2022-02-17 00:03:11', '1', '2022-09-04 04:23:35', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_data_source_config
-- ----------------------------
DROP TABLE IF EXISTS `infra_data_source_config`;
CREATE TABLE `infra_data_source_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键编号',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '参数名称',
  `url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '数据源连接',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户名',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '密码',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='数据源配置表';

-- ----------------------------
-- Records of infra_data_source_config
-- ----------------------------
BEGIN;
INSERT INTO `infra_data_source_config` (`id`, `name`, `url`, `username`, `password`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, 'tenant-a', 'jdbc:mysql://127.0.0.1:3306/ruoyi-vue-pro-tenant-a?allowMultiQueries=true&useUnicode=true&useSSL=false&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true&nullCatalogMeansCurrent=true', 'root', 'epmpRAaR2T0FWW9J6yYSBQ==', '1', '2022-11-12 08:57:37', '1', '2023-02-27 00:21:09', b'0');
INSERT INTO `infra_data_source_config` (`id`, `name`, `url`, `username`, `password`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (12, 'tenant-b', 'jdbc:mysql://127.0.0.1:3306/ruoyi-vue-pro-tenant-b?allowMultiQueries=true&useUnicode=true&useSSL=false&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true&nullCatalogMeansCurrent=true', 'root', 'epmpRAaR2T0FWW9J6yYSBQ==', '1', '2023-02-27 22:18:54', '1', '2023-02-27 22:18:54', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_file
-- ----------------------------
DROP TABLE IF EXISTS `infra_file`;
CREATE TABLE `infra_file` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '文件编号',
  `config_id` bigint DEFAULT NULL COMMENT '配置编号',
  `name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '文件名',
  `path` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件路径',
  `url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件 URL',
  `type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '文件类型',
  `size` int NOT NULL COMMENT '文件大小',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=910 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='文件表';

-- ----------------------------
-- Records of infra_file
-- ----------------------------
BEGIN;
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (86, 11, '640.jpeg', '7201ea108db2a0d7cb19293740c880e7.jpg', 'http://test.yudao.iocoder.cn/7201ea108db2a0d7cb19293740c880e7.jpg', 'jpg', 91398, '1', '2022-06-15 08:04:38', '1', '2022-06-15 08:04:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (87, 11, '84a09454049191c3598eea6775a16712.jpg', '84a09454049191c3598eea6775a16712.jpg', 'http://test.yudao.iocoder.cn/84a09454049191c3598eea6775a16712.jpg', 'jpg', 2949, '1', '2022-06-15 20:49:21', '1', '2022-06-15 20:49:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (88, 11, '84a09454049191c3598eea6775a16712.jpg', '84a09454049191c3598eea6775a16712.jpg', 'http://test.yudao.iocoder.cn/84a09454049191c3598eea6775a16712.jpg', 'jpg', 2949, '1', '2022-06-15 21:03:27', '1', '2022-06-15 21:03:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (89, 11, 'i-ui171112-1-8.jpeg', '0567c67449c976ecd378bd63b76ef158.jpeg', 'http://test.yudao.iocoder.cn/0567c67449c976ecd378bd63b76ef158.jpeg', 'image/jpeg', 76879, '1', '2022-07-08 21:25:13', '1', '2022-07-08 21:25:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (90, 11, 'xx.png', '62511c1e66ae9988c13011accdf37dd4.webp', 'http://test.yudao.iocoder.cn/62511c1e66ae9988c13011accdf37dd4.webp', 'image/webp', 37306, '1', '2022-07-08 21:25:47', '1', '2022-07-08 21:25:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (91, 11, '0ef126744ac93110e68344b44a2a9bcbcdd651c4d83ffb30e90e59a939d7481f.jpg', '0ef126744ac93110e68344b44a2a9bcbcdd651c4d83ffb30e90e59a939d7481f.jpg', 'http://test.yudao.iocoder.cn/0ef126744ac93110e68344b44a2a9bcbcdd651c4d83ffb30e90e59a939d7481f.jpg', 'image/jpeg', 46715, '1', '2022-07-27 01:18:37', '1', '2022-07-27 01:18:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (92, 11, 'a4224a33cf8d509f97aabc5d1ef67ba81959ec471f021f30e361faf7378962ba.jpg', 'a4224a33cf8d509f97aabc5d1ef67ba81959ec471f021f30e361faf7378962ba.jpg', 'http://test.yudao.iocoder.cn/a4224a33cf8d509f97aabc5d1ef67ba81959ec471f021f30e361faf7378962ba.jpg', 'image/jpeg', 39020, '1', '2022-07-27 01:18:49', '1', '2022-07-27 01:18:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (93, 11, '220119macbooksedream02-w1280.jpeg', '122d548e1b3cd5dec72fe8075c6977a70f9cc13541a684ab3685f1b5df42f6bd.jpeg', 'http://test.yudao.iocoder.cn/122d548e1b3cd5dec72fe8075c6977a70f9cc13541a684ab3685f1b5df42f6bd.jpeg', 'image/jpeg', 317161, '1', '2022-07-30 16:36:24', '1', '2022-07-30 16:36:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (94, 11, '6090f62fcadd27559.jpg_e1080.jpg', '72713ac7b947600a019a18786ed0e6562e8692e253dbd35110a0a85c2469bbec.jpg', 'http://test.yudao.iocoder.cn/72713ac7b947600a019a18786ed0e6562e8692e253dbd35110a0a85c2469bbec.jpg', 'image/jpeg', 138498, '1', '2022-07-30 16:38:00', '1', '2022-07-30 16:38:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (95, 11, '5f57c026d6f1f2185.jpg_e1080.jpg', '287c50dd9f5f575f57329a0c57b2095be6d1aeba83867b905fe549f54a296feb.jpg', 'http://test.yudao.iocoder.cn/287c50dd9f5f575f57329a0c57b2095be6d1aeba83867b905fe549f54a296feb.jpg', 'image/jpeg', 33526, '1', '2022-07-30 16:39:02', '1', '2022-07-30 16:39:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (96, 11, '099f734ef4e5695360a5dc356644f775.jpeg', 'e1b63900c78dbb661b3e383960cee5cfea7e1dd2fb22cff2e317ff025faaf8b2.jpeg', 'http://test.yudao.iocoder.cn/e1b63900c78dbb661b3e383960cee5cfea7e1dd2fb22cff2e317ff025faaf8b2.jpeg', 'image/jpeg', 30496, '1', '2022-07-30 16:39:55', '1', '2022-07-30 16:39:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (97, 11, 'v2-f301d718e53a43abb0d432b176125b79_720w.jpeg', '3af6557ac7def6423f046f5b2e920b644793420b466959aaa996a2e19068bbde.jpeg', 'http://test.yudao.iocoder.cn/3af6557ac7def6423f046f5b2e920b644793420b466959aaa996a2e19068bbde.jpeg', 'image/jpeg', 18224, '1', '2022-07-30 16:42:43', '1', '2022-07-30 16:42:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (98, 11, 'v2-f301d718e53a43abb0d432b176125b79_720w.jpeg', '3af6557ac7def6423f046f5b2e920b644793420b466959aaa996a2e19068bbde.jpeg', 'http://test.yudao.iocoder.cn/3af6557ac7def6423f046f5b2e920b644793420b466959aaa996a2e19068bbde.jpeg', 'image/jpeg', 18224, '1', '2022-07-30 16:42:48', '1', '2022-07-30 16:42:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (99, 11, '557f5f663df54d2c949c63bfc56d9e87.jpeg', '964fe9ccd1710d64ede261dc36d231918a017641986c15293c367f9f66d94d05.jpeg', 'http://test.yudao.iocoder.cn/964fe9ccd1710d64ede261dc36d231918a017641986c15293c367f9f66d94d05.jpeg', 'image/jpeg', 57193, '1', '2022-07-30 16:43:39', '1', '2022-07-30 16:43:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (100, 11, '报表设计器-打印设计.png', 'b287122f277838e8de368769b96217918605743bc45f3a29bda3cc7359dc66e1.png', 'http://test.yudao.iocoder.cn/b287122f277838e8de368769b96217918605743bc45f3a29bda3cc7359dc66e1.png', 'image/png', 41628, '1', '2022-07-30 20:38:07', '1', '2022-07-30 20:38:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (101, 11, '1527574926943.jpeg', 'e3726713fa56db5717c78c011762fcc7a251db12735c3581470638b8e1fa17e2.jpeg', 'http://test.yudao.iocoder.cn/e3726713fa56db5717c78c011762fcc7a251db12735c3581470638b8e1fa17e2.jpeg', 'image/jpeg', 27120, '1', '2022-07-30 22:12:15', '1', '2022-07-30 22:12:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (102, 11, 'effb8f9f9d229551fa655924e203d09514a9bb626f9be73ccda1b6358402949e.png', 'effb8f9f9d229551fa655924e203d09514a9bb626f9be73ccda1b6358402949e.png', 'http://test.yudao.iocoder.cn/effb8f9f9d229551fa655924e203d09514a9bb626f9be73ccda1b6358402949e.png', 'image/png', 25770, '1', '2022-08-03 11:17:06', '1', '2022-08-03 11:17:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (103, 11, 'c18024e2d4683e621f72ada3eced9bf79150307ac217670671f0b416ea2698a1.png', 'c18024e2d4683e621f72ada3eced9bf79150307ac217670671f0b416ea2698a1.png', 'http://test.yudao.iocoder.cn/c18024e2d4683e621f72ada3eced9bf79150307ac217670671f0b416ea2698a1.png', 'image/png', 20289, '1', '2022-08-03 11:17:32', '1', '2022-08-03 11:17:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (104, 11, 'e1fdd7271685ec143a0900681606406621717a666ad0b2798b096df41422b32f.png', 'e1fdd7271685ec143a0900681606406621717a666ad0b2798b096df41422b32f.png', 'http://test.yudao.iocoder.cn/e1fdd7271685ec143a0900681606406621717a666ad0b2798b096df41422b32f.png', 'image/png', 216659, '1', '2022-08-03 12:52:05', '1', '2022-08-03 12:52:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (105, 11, 'yudao-admin-vue3-login.png', 'bb07e43b0da2aded3f597c15477737b02e873cfce28c3d3eac71404ee196c311.png', 'http://test.yudao.iocoder.cn/bb07e43b0da2aded3f597c15477737b02e873cfce28c3d3eac71404ee196c311.png', 'image/png', 46420, '1', '2022-09-04 21:11:37', '1', '2022-09-04 21:11:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (106, 11, 'yudao-admin-vue2-login.png', 'f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'http://test.yudao.iocoder.cn/f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'image/png', 69241, '1', '2022-09-04 23:51:04', '1', '2022-09-04 23:51:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (107, 11, 'yudao-admin-vue2-login.png', 'f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'http://test.yudao.iocoder.cn/f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'image/png', 69241, '1', '2022-09-04 23:55:51', '1', '2022-09-04 23:55:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (108, 11, 'yudao-admin-vue3-login.png', 'bb07e43b0da2aded3f597c15477737b02e873cfce28c3d3eac71404ee196c311.png', 'http://test.yudao.iocoder.cn/bb07e43b0da2aded3f597c15477737b02e873cfce28c3d3eac71404ee196c311.png', 'image/png', 46420, '1', '2022-09-04 23:59:36', '1', '2022-09-04 23:59:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (109, 11, 'yudao-admin-vue2-login.png', 'f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'http://test.yudao.iocoder.cn/f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'image/png', 69241, '1', '2022-09-05 00:00:26', '1', '2022-09-05 00:00:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (110, 11, 'yudao-admin-vue2-login.png', 'f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'http://test.yudao.iocoder.cn/f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'image/png', 69241, '1', '2022-09-05 00:01:50', '1', '2022-09-05 00:01:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (111, 11, 'yudao-admin-vue2-login.png', 'f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'http://test.yudao.iocoder.cn/f20d778cb0ee1ea782004a1b059638f213a254159ebb303989a58dae07407a45.png', 'image/png', 69241, '1', '2022-09-05 00:04:34', '1', '2022-09-05 00:04:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (112, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:12:21', '1', '2022-09-20 11:12:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (113, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:20:03', '1', '2022-09-20 11:20:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (114, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:21:48', '1', '2022-09-20 11:21:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (115, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:22:30', '1', '2022-09-20 11:22:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (116, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:23:20', '1', '2022-09-20 11:23:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (117, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 11:24:39', '1', '2022-09-20 11:24:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (118, 11, 'video.mp4', '2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'http://test.yudao.iocoder.cn/2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'video/mp4', 3339444, '1', '2022-09-20 12:10:09', '1', '2022-09-20 12:10:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (119, 11, 'video.mp4', '2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'http://test.yudao.iocoder.cn/2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'video/mp4', 3339444, '1', '2022-09-20 12:13:33', '1', '2022-09-20 12:13:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (120, 11, 'video.mp4', '2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'http://test.yudao.iocoder.cn/2e9662dca7ef4c250a83580817dc2b67473177d402a4afbc3ebcbbbab90bba5b.mp4', 'video/mp4', 3339444, '1', '2022-09-20 12:15:36', '1', '2022-09-20 12:15:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (121, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 12:24:10', '1', '2022-09-20 12:24:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (122, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:27:18', '1', '2022-09-20 14:27:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (123, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:27:28', '1', '2022-09-20 14:27:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (124, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:28:43', '1', '2022-09-20 14:28:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (125, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:28:46', '1', '2022-09-20 14:28:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (126, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:29:07', '1', '2022-09-20 14:29:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (127, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:32:58', '1', '2022-09-20 14:32:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (128, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:33:44', '1', '2022-09-20 14:33:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (129, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:34:25', '1', '2022-09-20 14:34:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (130, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:35:34', '1', '2022-09-20 14:35:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (131, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:35:46', '1', '2022-09-20 14:35:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (132, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:37:40', '1', '2022-09-20 14:37:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (133, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:37:49', '1', '2022-09-20 14:37:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (134, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 14:44:14', '1', '2022-09-20 14:44:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (135, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 15:07:23', '1', '2022-09-20 15:07:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (136, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 15:07:34', '1', '2022-09-20 15:07:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (137, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 15:09:15', '1', '2022-09-20 15:09:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (138, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 15:09:26', '1', '2022-09-20 15:09:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (139, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 15:11:44', '1', '2022-09-20 15:11:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (140, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:21:41', '1', '2022-09-20 16:21:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (141, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:24:25', '1', '2022-09-20 16:24:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (142, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:36:02', '1', '2022-09-20 16:36:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (143, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:40:39', '1', '2022-09-20 16:40:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (144, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:42:32', '1', '2022-09-20 16:42:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (145, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 16:44:54', '1', '2022-09-20 16:44:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (146, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:46:14', '1', '2022-09-20 16:46:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (147, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:49:39', '1', '2022-09-20 16:49:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (148, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:50:46', '1', '2022-09-20 16:50:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (149, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:51:22', '1', '2022-09-20 16:51:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (150, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:52:35', '1', '2022-09-20 16:52:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (151, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:54:23', '1', '2022-09-20 16:54:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (152, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:54:40', '1', '2022-09-20 16:54:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (153, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:55:31', '1', '2022-09-20 16:55:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (154, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:56:03', '1', '2022-09-20 16:56:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (155, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:56:18', '1', '2022-09-20 16:56:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (156, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:56:36', '1', '2022-09-20 16:56:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (157, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:58:59', '1', '2022-09-20 16:58:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (158, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 16:59:56', '1', '2022-09-20 16:59:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (159, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:01:42', '1', '2022-09-20 17:01:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (160, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:02:24', '1', '2022-09-20 17:02:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (161, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:03:55', '1', '2022-09-20 17:03:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (162, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:04:17', '1', '2022-09-20 17:04:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (163, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:53:57', '1', '2022-09-20 17:53:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (164, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:54:47', '1', '2022-09-20 17:54:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (165, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:55:50', '1', '2022-09-20 17:55:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (166, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:57:16', '1', '2022-09-20 17:57:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (167, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:57:25', '1', '2022-09-20 17:57:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (168, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 17:58:28', '1', '2022-09-20 17:58:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (169, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:01:47', '1', '2022-09-20 18:01:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (170, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:06:17', '1', '2022-09-20 18:06:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (171, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:07:42', '1', '2022-09-20 18:07:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (172, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:08:59', '1', '2022-09-20 18:08:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (173, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:10:24', '1', '2022-09-20 18:10:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (174, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:10:30', '1', '2022-09-20 18:10:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (175, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:14:32', '1', '2022-09-20 18:14:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (176, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:14:54', '1', '2022-09-20 18:14:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (177, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:16:56', '1', '2022-09-20 18:16:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (178, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:17:14', '1', '2022-09-20 18:17:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (179, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:17:23', '1', '2022-09-20 18:17:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (180, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 18:18:37', '1', '2022-09-20 18:18:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (181, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 19:15:59', '1', '2022-09-20 19:15:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (182, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 19:18:26', '1', '2022-09-20 19:18:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (183, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-20 19:21:02', '1', '2022-09-20 19:21:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (184, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 20:01:16', '1', '2022-09-20 20:01:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (185, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 20:01:42', '1', '2022-09-20 20:01:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (186, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 20:02:44', '1', '2022-09-20 20:02:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (187, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-20 20:03:45', '1', '2022-09-20 20:03:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (188, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-21 10:26:09', '1', '2022-09-21 10:26:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (189, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-21 10:31:17', '1', '2022-09-21 10:31:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (190, 11, '咖啡 (1).mp4', '4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'http://test.yudao.iocoder.cn/4d389a97753a609fa5fe5488e2b4360cb48d2e95745660c93043b4213bab6630.mp4', 'video/x-m4v', 1535443, '1', '2022-09-21 10:31:22', '1', '2022-09-21 10:31:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (191, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-21 10:31:32', '1', '2022-09-21 10:31:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (192, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:21:39', '1', '2022-09-22 11:21:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (193, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:21:46', '1', '2022-09-22 11:21:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (194, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:22:40', '1', '2022-09-22 11:22:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (195, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:22:54', '1', '2022-09-22 11:22:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (196, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:33:08', '1', '2022-09-22 11:33:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (197, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:33:10', '1', '2022-09-22 11:33:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (198, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:38:52', '1', '2022-09-22 11:38:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (199, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-22 11:39:01', '1', '2022-09-22 11:39:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (200, 11, '手机.jpg', '663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'http://test.yudao.iocoder.cn/663706891f14f77aca130abaac70099333233ce815edc8c6245538f05576db15.jpg', 'image/jpeg', 45009, '1', '2022-09-23 17:03:07', '1', '2022-09-23 17:03:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (201, 11, 'thumb_60a1d9d5b6495.png', 'fe4ed36596adad5120036ef61a6d0153654544d44af8dd4ad3ffe8f759933d6f.png', 'http://test.yudao.iocoder.cn/fe4ed36596adad5120036ef61a6d0153654544d44af8dd4ad3ffe8f759933d6f.png', 'image/png', 57111, '1', '2022-09-29 13:28:29', '1', '2022-09-29 13:28:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (202, 11, '街霸.jpeg', '604bdc695e13b3b22745be704d1f2aa8ee05c5f26f9fead6d1ca49005afbc857.jpeg', 'http://test.yudao.iocoder.cn/604bdc695e13b3b22745be704d1f2aa8ee05c5f26f9fead6d1ca49005afbc857.jpeg', 'image/jpeg', 57100, '1', '2022-10-04 17:39:35', '1', '2022-10-04 17:39:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (203, 11, 'logo.png', '3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'http://test.yudao.iocoder.cn/3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'image/png', 20638, '1', '2022-11-08 13:53:05', '1', '2022-11-08 13:53:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (204, 11, 'logo.png', '3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'http://test.yudao.iocoder.cn/3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'image/png', 20638, '1', '2022-11-08 13:53:20', '1', '2022-11-08 14:32:16', b'1');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (205, 11, 'logo.png', '3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'http://test.yudao.iocoder.cn/3d98d501a2bcd8560359a79d4332bc098a41b0cc95c207ca0307e3b8275eefb7.png', 'image/png', 20638, '1', '2022-11-08 14:36:14', '1', '2022-11-08 14:32:14', b'1');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (206, 11, '秒杀活动.sql', '20092b22e4683891f0bc0e7f2aac9f2c32562c4c562e2bdf1fbbfcf8f86b489f.sql', 'http://test.yudao.iocoder.cn/20092b22e4683891f0bc0e7f2aac9f2c32562c4c562e2bdf1fbbfcf8f86b489f.sql', 'text/x-sql', 5685, '1', '2022-11-12 01:56:05', '1', '2022-11-12 01:56:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (207, 11, '1622972869767.jpeg', 'a036c3d103ab0cd780750d08d5dc253d7271e806e7031c5306d8357f621ca2fa.jpeg', 'http://test.yudao.iocoder.cn/a036c3d103ab0cd780750d08d5dc253d7271e806e7031c5306d8357f621ca2fa.jpeg', 'image/jpeg', 5584, '1', '2022-11-12 01:58:07', '1', '2022-11-12 01:58:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (208, 11, '54FC37760B2F0B93A153F52A4ECD8187BC308157_size63_w640_h651.jpeg', '8adf4a23e7678fc6ed207688380b9ee307bd58add609db834a3f2ec3fc7034d5.jpeg', 'http://test.yudao.iocoder.cn/8adf4a23e7678fc6ed207688380b9ee307bd58add609db834a3f2ec3fc7034d5.jpeg', 'image/jpeg', 65107, '1', '2022-11-12 01:58:55', '1', '2022-11-12 01:58:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (209, 11, 'a2is2-hf21y.jpeg', '758a7e19991c3f7ca401277d77a4a29a34e76058b303d9b4666ecf2ca57c38ba.jpeg', 'http://test.yudao.iocoder.cn/758a7e19991c3f7ca401277d77a4a29a34e76058b303d9b4666ecf2ca57c38ba.jpeg', 'image/jpeg', 578788, '1', '2022-11-19 12:22:52', '1', '2022-11-19 12:22:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (210, 11, '国产项目对比.png', 'f52eaa01afa52d0e823a57b7ccefb8a5c3dac325e96672b8a6c83c9884df073e.png', 'http://test.yudao.iocoder.cn/f52eaa01afa52d0e823a57b7ccefb8a5c3dac325e96672b8a6c83c9884df073e.png', 'image/png', 240217, '1', '2022-11-19 12:23:24', '1', '2022-11-19 12:23:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (211, 11, 'u=1187048847,234634791&fm=224&app=112&f=JPEG.jpeg', '239b0adfb5061c2e4f7f16ca2e7d768dc5c7e9bcf9bd3337b3b7b7d237b2fef1.jpeg', 'http://test.yudao.iocoder.cn/239b0adfb5061c2e4f7f16ca2e7d768dc5c7e9bcf9bd3337b3b7b7d237b2fef1.jpeg', 'image/jpeg', 2225, '1', '2022-12-14 12:40:51', '1', '2022-12-14 12:40:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (212, 11, '4061d839d073ebf7ff3c33e42420a00e.jpeg', 'd7da7b353545ea513c6335d64f3f56c5f41f812e3a131b1c630f20889ec6f5e7.jpeg', 'http://test.yudao.iocoder.cn/d7da7b353545ea513c6335d64f3f56c5f41f812e3a131b1c630f20889ec6f5e7.jpeg', 'image/jpeg', 2133, '1', '2022-12-14 12:41:36', '1', '2022-12-14 12:41:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (213, 11, 'be8dc6e39638dcf90cebc7cd02fd25a6.jpeg', 'decf7db901f17f5aeb3730d2a8d879833c228ddf977333da5a1e3df6b4a27ce3.jpeg', 'http://test.yudao.iocoder.cn/decf7db901f17f5aeb3730d2a8d879833c228ddf977333da5a1e3df6b4a27ce3.jpeg', 'image/jpeg', 2193, '1', '2022-12-14 12:42:18', '1', '2022-12-14 12:42:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (214, 11, '206e3a7a9b321ae54d751951af8915c2.jpeg', 'c7142b4024c795987b48cfa3d60c18c5cc55c2a9fe84f84e0af571f17053bfc1.jpeg', 'http://test.yudao.iocoder.cn/c7142b4024c795987b48cfa3d60c18c5cc55c2a9fe84f84e0af571f17053bfc1.jpeg', 'image/jpeg', 3181, '1', '2022-12-14 12:43:09', '1', '2022-12-14 12:43:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (215, 11, 'cd7bf5f9794b4d0f38b556136c84241f.jpeg', '66adb6384cdaa9c8e079c6065338385e99ac62ac7514cac541313b8f9252f1d7.jpeg', 'http://test.yudao.iocoder.cn/66adb6384cdaa9c8e079c6065338385e99ac62ac7514cac541313b8f9252f1d7.jpeg', 'image/jpeg', 1590, '1', '2022-12-14 12:43:36', '1', '2022-12-14 12:43:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (216, 11, '75fe5d30bb8642fca867249fb5ab0828.jpeg', '4a7315b68f895e71e621dd8dd0f62d0e68d3d469ea227f8fd132a67f739d439d.jpeg', 'http://test.yudao.iocoder.cn/4a7315b68f895e71e621dd8dd0f62d0e68d3d469ea227f8fd132a67f739d439d.jpeg', 'image/jpeg', 3175, '1', '2022-12-14 12:44:39', '1', '2022-12-14 12:44:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (217, 11, '6c7d7ad48e0469aa6311d20049724591.jpeg', '388f41d2422c6727a65eed1d86a98b952ef9120b4ff53165f5f35aeb9e356a0e.jpeg', 'http://test.yudao.iocoder.cn/388f41d2422c6727a65eed1d86a98b952ef9120b4ff53165f5f35aeb9e356a0e.jpeg', 'image/jpeg', 2154, '1', '2022-12-14 12:45:24', '1', '2022-12-14 12:45:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (218, 11, '09866e900a0eb58e7e7959edb4c8ad20.jpeg', '9efd3b4e15e71d82ba1041026826b2202b3b82ff133bc2cd58a5dbf168ed862b.jpeg', 'http://test.yudao.iocoder.cn/9efd3b4e15e71d82ba1041026826b2202b3b82ff133bc2cd58a5dbf168ed862b.jpeg', 'image/jpeg', 2010, '1', '2022-12-14 12:46:04', '1', '2022-12-14 12:46:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (219, 11, 'c25436791690056761089c21455884b5.jpeg', 'ba2099e6f3b4582c56b5da35b3b917423995f6b91d6bc17a6b19be500bfcba50.jpeg', 'http://test.yudao.iocoder.cn/ba2099e6f3b4582c56b5da35b3b917423995f6b91d6bc17a6b19be500bfcba50.jpeg', 'image/jpeg', 2660, '1', '2022-12-14 12:47:04', '1', '2022-12-14 12:47:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (220, 11, 'desktop-312726.jpg', 'e2af5f13991a072964d653f8125de17b958627de271564252b57f2de5375d65d.jpg', 'http://test.yudao.iocoder.cn/e2af5f13991a072964d653f8125de17b958627de271564252b57f2de5375d65d.jpg', 'image/jpeg', 826988, '1', '2022-12-24 09:30:46', '1', '2022-12-24 09:30:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (221, 11, '17199bf3ed08b55d5bd13ed23137bda3dbe630a56cd6d0f4d2f6ca983550ca4d.null', '17199bf3ed08b55d5bd13ed23137bda3dbe630a56cd6d0f4d2f6ca983550ca4d.null', 'http://test.yudao.iocoder.cn/17199bf3ed08b55d5bd13ed23137bda3dbe630a56cd6d0f4d2f6ca983550ca4d.null', 'audio/amr', 1700, NULL, '2023-01-03 20:36:03', NULL, '2023-01-03 20:36:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (222, 11, 'f28197e6fd634670036420d2668a782dc775c7ed41595758cd4fefff323f2173.jpg', 'f28197e6fd634670036420d2668a782dc775c7ed41595758cd4fefff323f2173.jpg', 'http://test.yudao.iocoder.cn/f28197e6fd634670036420d2668a782dc775c7ed41595758cd4fefff323f2173.jpg', 'image/jpeg', 11133, NULL, '2023-01-03 20:48:13', NULL, '2023-01-03 20:48:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (223, 11, 'c81wwH9HR0Ymh_o_zGqlGu0ca0EDnkZuHnJBTyMiPgJDwdt6vduBA9ZcmveGIpll.amr', 'c81wwH9HR0Ymh_o_zGqlGu0ca0EDnkZuHnJBTyMiPgJDwdt6vduBA9ZcmveGIpll.amr', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGu0ca0EDnkZuHnJBTyMiPgJDwdt6vduBA9ZcmveGIpll.amr', 'audio/amr', 2372, NULL, '2023-01-03 20:52:56', NULL, '2023-01-03 20:52:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (224, 11, 'c81wwH9HR0Ymh_o_zGqlGtLnMKNBRkokMh8n0y3wH6KGbaC_c5WXraR1NlvnGEXm.jpg', 'c81wwH9HR0Ymh_o_zGqlGtLnMKNBRkokMh8n0y3wH6KGbaC_c5WXraR1NlvnGEXm.jpg', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGtLnMKNBRkokMh8n0y3wH6KGbaC_c5WXraR1NlvnGEXm.jpg', 'image/jpeg', 536942, NULL, '2023-01-03 20:58:55', NULL, '2023-01-03 20:58:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (225, 11, 'c81wwH9HR0Ymh_o_zGqlGrVH3IZ_WfEFtBV6bJUy89fzO97GG3OtdFx6DBs0fE7r74I3IIUYeUF8eJn_kJarwQ.mp4', 'c81wwH9HR0Ymh_o_zGqlGrVH3IZ_WfEFtBV6bJUy89fzO97GG3OtdFx6DBs0fE7r74I3IIUYeUF8eJn_kJarwQ.mp4', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGrVH3IZ_WfEFtBV6bJUy89fzO97GG3OtdFx6DBs0fE7r74I3IIUYeUF8eJn_kJarwQ.mp4', 'video/quicktime', 355574, NULL, '2023-01-03 21:01:19', NULL, '2023-01-03 21:01:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (226, 11, 'c81wwH9HR0Ymh_o_zGqlGurP_d1X5E0K7ARsRzU55bi12edlRlMMQ3WEpuQQ5B8pd5FskAMb8MPeMeSFnxGO-w.mp4', 'c81wwH9HR0Ymh_o_zGqlGurP_d1X5E0K7ARsRzU55bi12edlRlMMQ3WEpuQQ5B8pd5FskAMb8MPeMeSFnxGO-w.mp4', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGurP_d1X5E0K7ARsRzU55bi12edlRlMMQ3WEpuQQ5B8pd5FskAMb8MPeMeSFnxGO-w.mp4', 'video/quicktime', 355574, NULL, '2023-01-03 21:01:47', NULL, '2023-01-03 21:01:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (227, 11, 'c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'image/jpeg', 29380, NULL, '2023-01-03 21:07:03', NULL, '2023-01-03 21:07:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (228, 11, 'c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'http://test.yudao.iocoder.cn/c81wwH9HR0Ymh_o_zGqlGkY5kRqg7Lp0hwwTYtTYOuAFI5DKRnj27kH_GNo1BUg5.jpg', 'image/jpeg', 29380, NULL, '2023-01-03 21:09:08', NULL, '2023-01-03 21:09:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (229, 11, 't1E3ss-niBf29tpzShjljxwaiBoXV_61ln2hzZGDlvAcT3hqLbC9dvl39YwiBWg9.amr', 't1E3ss-niBf29tpzShjljxwaiBoXV_61ln2hzZGDlvAcT3hqLbC9dvl39YwiBWg9.amr', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjljxwaiBoXV_61ln2hzZGDlvAcT3hqLbC9dvl39YwiBWg9.amr', 'audio/amr', 1028, NULL, '2023-01-04 21:15:48', NULL, '2023-01-04 21:15:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (230, 11, 't1E3ss-niBf29tpzShjlj_DbXA1P76hEKVaYzXxKKqUx4183HtIPkQwNEUHtmmfcV9cb0GIYgLIbuOTKrq91pw.mp4', 't1E3ss-niBf29tpzShjlj_DbXA1P76hEKVaYzXxKKqUx4183HtIPkQwNEUHtmmfcV9cb0GIYgLIbuOTKrq91pw.mp4', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjlj_DbXA1P76hEKVaYzXxKKqUx4183HtIPkQwNEUHtmmfcV9cb0GIYgLIbuOTKrq91pw.mp4', 'video/quicktime', 355574, NULL, '2023-01-04 21:20:13', NULL, '2023-01-04 21:20:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (231, 11, 't1E3ss-niBf29tpzShjlj1v4qTDhv0wRiSMnflkB1TgT-v0F31hreyRvxh52ckP5.jpg', 't1E3ss-niBf29tpzShjlj1v4qTDhv0wRiSMnflkB1TgT-v0F31hreyRvxh52ckP5.jpg', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjlj1v4qTDhv0wRiSMnflkB1TgT-v0F31hreyRvxh52ckP5.jpg', 'image/jpeg', 3347, NULL, '2023-01-04 21:20:14', NULL, '2023-01-04 21:20:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (232, 11, 't1E3ss-niBf29tpzShjljzyB1g0sTtjWE0G3pXACNV88Cr6rJxGS4k0px4izLFTwgrCi4ZBssYF77OC1mf7J7w.mp4', 't1E3ss-niBf29tpzShjljzyB1g0sTtjWE0G3pXACNV88Cr6rJxGS4k0px4izLFTwgrCi4ZBssYF77OC1mf7J7w.mp4', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjljzyB1g0sTtjWE0G3pXACNV88Cr6rJxGS4k0px4izLFTwgrCi4ZBssYF77OC1mf7J7w.mp4', 'video/quicktime', 355574, NULL, '2023-01-04 21:22:13', NULL, '2023-01-04 21:22:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (233, 11, 't1E3ss-niBf29tpzShjlj7U5nivIzwjOdLX02tPjbemJMmGcBdm0CLjMxPWfjtzV.jpg', 't1E3ss-niBf29tpzShjlj7U5nivIzwjOdLX02tPjbemJMmGcBdm0CLjMxPWfjtzV.jpg', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjlj7U5nivIzwjOdLX02tPjbemJMmGcBdm0CLjMxPWfjtzV.jpg', 'image/jpeg', 3347, NULL, '2023-01-04 21:22:14', NULL, '2023-01-04 21:22:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (234, 11, 't1E3ss-niBf29tpzShjlj2spbSpzdqJqif7k_0rxPradrKsvQl1rPhM3HkDuAfcn.jpg', 't1E3ss-niBf29tpzShjlj2spbSpzdqJqif7k_0rxPradrKsvQl1rPhM3HkDuAfcn.jpg', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjlj2spbSpzdqJqif7k_0rxPradrKsvQl1rPhM3HkDuAfcn.jpg', 'image/jpeg', 220678, NULL, '2023-01-04 21:22:15', NULL, '2023-01-04 21:22:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (235, 11, 't1E3ss-niBf29tpzShjlj4XZFkwYNZbTmwcpv6AqyM5rgy12Z157Rcn1G0RsDgLG.jpg', 't1E3ss-niBf29tpzShjlj4XZFkwYNZbTmwcpv6AqyM5rgy12Z157Rcn1G0RsDgLG.jpg', 'http://test.yudao.iocoder.cn/t1E3ss-niBf29tpzShjlj4XZFkwYNZbTmwcpv6AqyM5rgy12Z157Rcn1G0RsDgLG.jpg', 'image/jpeg', 26264, NULL, '2023-01-04 21:24:49', NULL, '2023-01-04 21:24:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (236, 11, 'lDLfcdLstUO-y-3jvlqHe48jrgVjldPUtOMr74Wyi_XHo2wfmYP_pgSlelmyqH3X.amr', 'lDLfcdLstUO-y-3jvlqHe48jrgVjldPUtOMr74Wyi_XHo2wfmYP_pgSlelmyqH3X.amr', 'http://test.yudao.iocoder.cn/lDLfcdLstUO-y-3jvlqHe48jrgVjldPUtOMr74Wyi_XHo2wfmYP_pgSlelmyqH3X.amr', 'audio/amr', 944, NULL, '2023-01-06 08:38:20', NULL, '2023-01-06 08:38:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (237, 11, 'lDLfcdLstUO-y-3jvlqHexoRlLFUnitqPt6NDr0_q5f_XNSxVbcSik2TfM5tK_-M.amr', 'lDLfcdLstUO-y-3jvlqHexoRlLFUnitqPt6NDr0_q5f_XNSxVbcSik2TfM5tK_-M.amr', 'http://test.yudao.iocoder.cn/lDLfcdLstUO-y-3jvlqHexoRlLFUnitqPt6NDr0_q5f_XNSxVbcSik2TfM5tK_-M.amr', 'audio/amr', 1448, NULL, '2023-01-06 08:38:52', NULL, '2023-01-06 08:38:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (238, 11, 'lDLfcdLstUO-y-3jvlqHe7EeCq-zPV7UJYX5hHN1aJc5Km6u3x5SvSBa4fEcOw1n.amr', 'lDLfcdLstUO-y-3jvlqHe7EeCq-zPV7UJYX5hHN1aJc5Km6u3x5SvSBa4fEcOw1n.amr', 'http://test.yudao.iocoder.cn/lDLfcdLstUO-y-3jvlqHe7EeCq-zPV7UJYX5hHN1aJc5Km6u3x5SvSBa4fEcOw1n.amr', 'audio/amr', 1364, NULL, '2023-01-06 08:39:05', NULL, '2023-01-06 08:39:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (239, 11, 'lDLfcdLstUO-y-3jvlqHe5WfgfHDErGwxO4KcICq_VClkHEgOzf0AtfUOawKU1Uo.amr', 'lDLfcdLstUO-y-3jvlqHe5WfgfHDErGwxO4KcICq_VClkHEgOzf0AtfUOawKU1Uo.amr', 'http://test.yudao.iocoder.cn/lDLfcdLstUO-y-3jvlqHe5WfgfHDErGwxO4KcICq_VClkHEgOzf0AtfUOawKU1Uo.amr', 'audio/amr', 1028, NULL, '2023-01-06 08:39:13', NULL, '2023-01-06 08:39:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (240, 11, 'qqc_2Fot30Jse-HDoZmo5RrUDijz2nGUkPCtYCckIf3e1CpU0kfEPdIYxueJqmnjpDjGlxcliA5Fmef9rPBN8w.mp4', 'qqc_2Fot30Jse-HDoZmo5RrUDijz2nGUkPCtYCckIf3e1CpU0kfEPdIYxueJqmnjpDjGlxcliA5Fmef9rPBN8w.mp4', 'http://test.yudao.iocoder.cn/qqc_2Fot30Jse-HDoZmo5RrUDijz2nGUkPCtYCckIf3e1CpU0kfEPdIYxueJqmnjpDjGlxcliA5Fmef9rPBN8w.mp4', 'video/quicktime', 355574, NULL, '2023-01-08 19:38:54', NULL, '2023-01-08 19:38:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (241, 11, 'qqc_2Fot30Jse-HDoZmo5YlVsGO0F_9VfAEyKo21lboewpi3TtLmT3AR-PqGJF8J.jpg', 'qqc_2Fot30Jse-HDoZmo5YlVsGO0F_9VfAEyKo21lboewpi3TtLmT3AR-PqGJF8J.jpg', 'http://test.yudao.iocoder.cn/qqc_2Fot30Jse-HDoZmo5YlVsGO0F_9VfAEyKo21lboewpi3TtLmT3AR-PqGJF8J.jpg', 'image/jpeg', 3347, NULL, '2023-01-08 19:38:54', NULL, '2023-01-08 19:38:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (242, 11, 'jfYIPHyEJ_EqMvvL4u6S8g7QQwEQ0ScRwVqy-1w_C1tXO0tOKUMby76eVL2T6iCl.jpg', 'jfYIPHyEJ_EqMvvL4u6S8g7QQwEQ0ScRwVqy-1w_C1tXO0tOKUMby76eVL2T6iCl.jpg', 'http://test.yudao.iocoder.cn/jfYIPHyEJ_EqMvvL4u6S8g7QQwEQ0ScRwVqy-1w_C1tXO0tOKUMby76eVL2T6iCl.jpg', 'image/jpeg', 847016, NULL, '2023-01-08 21:09:00', NULL, '2023-01-08 21:09:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (243, 11, 'jfYIPHyEJ_EqMvvL4u6S8qHbv0qm9gp-wn4GYtYVnMJcjQXuaWCOc5hPsWabG3ex.amr', 'jfYIPHyEJ_EqMvvL4u6S8qHbv0qm9gp-wn4GYtYVnMJcjQXuaWCOc5hPsWabG3ex.amr', 'http://test.yudao.iocoder.cn/jfYIPHyEJ_EqMvvL4u6S8qHbv0qm9gp-wn4GYtYVnMJcjQXuaWCOc5hPsWabG3ex.amr', 'audio/amr', 1532, NULL, '2023-01-08 21:14:44', NULL, '2023-01-08 21:14:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (244, 11, 's98Iveeg9vDVFwa9q0u8-3qEOBldt65GPFwVsMKl0egFUdiEOdmgQvB0EfIHLP2i.jpg', 's98Iveeg9vDVFwa9q0u8-3qEOBldt65GPFwVsMKl0egFUdiEOdmgQvB0EfIHLP2i.jpg', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-3qEOBldt65GPFwVsMKl0egFUdiEOdmgQvB0EfIHLP2i.jpg', 'image/jpeg', 234701, NULL, '2023-01-10 19:54:14', NULL, '2023-01-10 19:54:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (245, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, NULL, '2023-01-10 19:58:34', NULL, '2023-01-10 19:58:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (246, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 19:59:49', '1', '2023-01-10 19:59:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (247, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 20:22:45', '1', '2023-01-10 20:22:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (248, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 20:23:16', '1', '2023-01-10 20:23:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (249, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 20:23:48', '1', '2023-01-10 20:23:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (250, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 20:26:11', '1', '2023-01-10 20:26:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (251, 11, 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 's98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'http://test.yudao.iocoder.cn/s98Iveeg9vDVFwa9q0u8-zSfdKe3xIzAm7wCrFE4WKGPIo4d9qAhtC-n6qvnyWyH.png', 'image/png', 22765, '1', '2023-01-10 20:27:50', '1', '2023-01-10 20:27:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (252, 11, 'r9gSU0OzPvI03zr0zk2kqceaGagCt8JIdrOO-yp-BsiqNtTrcfX8vyCbHpZqUBKM.jpg', 'r9gSU0OzPvI03zr0zk2kqceaGagCt8JIdrOO-yp-BsiqNtTrcfX8vyCbHpZqUBKM.jpg', 'http://test.yudao.iocoder.cn/r9gSU0OzPvI03zr0zk2kqceaGagCt8JIdrOO-yp-BsiqNtTrcfX8vyCbHpZqUBKM.jpg', 'image/jpeg', 631961, NULL, '2023-01-11 18:55:31', NULL, '2023-01-11 18:55:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (253, 11, 'r9gSU0OzPvI03zr0zk2kqb5WxGcNj1k0juhmoWLBFtGfQfSwExT0_g0A1bkTVMdN.jpg', 'r9gSU0OzPvI03zr0zk2kqb5WxGcNj1k0juhmoWLBFtGfQfSwExT0_g0A1bkTVMdN.jpg', 'http://test.yudao.iocoder.cn/r9gSU0OzPvI03zr0zk2kqb5WxGcNj1k0juhmoWLBFtGfQfSwExT0_g0A1bkTVMdN.jpg', 'image/jpeg', 631961, NULL, '2023-01-11 18:56:11', NULL, '2023-01-11 18:56:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (254, 11, 'NRZjY41f1aWB8_CRxGNdr1jDE7PzZ1tGL_6yYw9D1Iq0YU8rKHe46qpRIJSQUzHj.png', 'NRZjY41f1aWB8_CRxGNdr1jDE7PzZ1tGL_6yYw9D1Iq0YU8rKHe46qpRIJSQUzHj.png', 'http://test.yudao.iocoder.cn/NRZjY41f1aWB8_CRxGNdr1jDE7PzZ1tGL_6yYw9D1Iq0YU8rKHe46qpRIJSQUzHj.png', 'image/png', 1881, '1', '2023-01-11 19:50:12', '1', '2023-01-11 19:50:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (255, 11, 'NRZjY41f1aWB8_CRxGNdr8k4pG8TTTzPiqFg-8EKEodbfjs4rU_7DMVaz-22NxhX.png', 'NRZjY41f1aWB8_CRxGNdr8k4pG8TTTzPiqFg-8EKEodbfjs4rU_7DMVaz-22NxhX.png', 'http://test.yudao.iocoder.cn/NRZjY41f1aWB8_CRxGNdr8k4pG8TTTzPiqFg-8EKEodbfjs4rU_7DMVaz-22NxhX.png', 'image/png', 1881, '1', '2023-01-11 19:54:24', '1', '2023-01-11 19:54:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (256, 11, 'NRZjY41f1aWB8_CRxGNdrzvMXpZbtPXc6EzJKjqjbJ7dUL_pN-iWGTVn3L_uvNog.png', 'NRZjY41f1aWB8_CRxGNdrzvMXpZbtPXc6EzJKjqjbJ7dUL_pN-iWGTVn3L_uvNog.png', 'http://test.yudao.iocoder.cn/NRZjY41f1aWB8_CRxGNdrzvMXpZbtPXc6EzJKjqjbJ7dUL_pN-iWGTVn3L_uvNog.png', 'image/png', 1881, '1', '2023-01-11 19:54:43', '1', '2023-01-11 19:54:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (257, 11, 'NRZjY41f1aWB8_CRxGNdrxioKhaI0q51bEYb4wQz7c1ODeqL9khxmuJElw7Ynr6i.png', 'NRZjY41f1aWB8_CRxGNdrxioKhaI0q51bEYb4wQz7c1ODeqL9khxmuJElw7Ynr6i.png', 'http://test.yudao.iocoder.cn/NRZjY41f1aWB8_CRxGNdrxioKhaI0q51bEYb4wQz7c1ODeqL9khxmuJElw7Ynr6i.png', 'image/png', 1881, '1', '2023-01-11 19:56:43', '1', '2023-01-11 19:56:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (258, 11, 'NRZjY41f1aWB8_CRxGNdr9O_iLGjAOhmLTHpGxsDNtEH8KAF5lIgRHvlkh5eTdEA.png', 'NRZjY41f1aWB8_CRxGNdr9O_iLGjAOhmLTHpGxsDNtEH8KAF5lIgRHvlkh5eTdEA.png', 'http://test.yudao.iocoder.cn/NRZjY41f1aWB8_CRxGNdr9O_iLGjAOhmLTHpGxsDNtEH8KAF5lIgRHvlkh5eTdEA.png', 'image/png', 1881, '1', '2023-01-11 19:57:20', '1', '2023-01-11 19:57:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (259, 11, 'LctVZCXdJDtxvnAbmfj5lULx-lSY4xIOc7UC1Z9VBtIfnCVOYx7mt-LdrkKbaaBq.png', 'LctVZCXdJDtxvnAbmfj5lULx-lSY4xIOc7UC1Z9VBtIfnCVOYx7mt-LdrkKbaaBq.png', 'http://test.yudao.iocoder.cn/LctVZCXdJDtxvnAbmfj5lULx-lSY4xIOc7UC1Z9VBtIfnCVOYx7mt-LdrkKbaaBq.png', 'image/png', 1881, '1', '2023-01-11 20:05:08', '1', '2023-01-11 20:05:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (260, 11, 'LctVZCXdJDtxvnAbmfj5lRCJ54y7UzNAkGIszh8MoY-ACn0JdH9RrZk8A3mQsuNh.png', 'LctVZCXdJDtxvnAbmfj5lRCJ54y7UzNAkGIszh8MoY-ACn0JdH9RrZk8A3mQsuNh.png', 'http://test.yudao.iocoder.cn/LctVZCXdJDtxvnAbmfj5lRCJ54y7UzNAkGIszh8MoY-ACn0JdH9RrZk8A3mQsuNh.png', 'image/png', 1881, '1', '2023-01-11 20:05:24', '1', '2023-01-11 20:05:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (261, 11, 'LctVZCXdJDtxvnAbmfj5lS0XuPrxCrqZe9OPSi7iWf24IQX-VdDkS7gWrRjt9pKr.png', 'LctVZCXdJDtxvnAbmfj5lS0XuPrxCrqZe9OPSi7iWf24IQX-VdDkS7gWrRjt9pKr.png', 'http://test.yudao.iocoder.cn/LctVZCXdJDtxvnAbmfj5lS0XuPrxCrqZe9OPSi7iWf24IQX-VdDkS7gWrRjt9pKr.png', 'image/png', 1881, '1', '2023-01-11 20:06:12', '1', '2023-01-11 20:06:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (262, 11, 'LctVZCXdJDtxvnAbmfj5ldVeGDhgbgJtwV4rv8GxYDbQysnyOv-SbtmawvZjHSw9.png', 'LctVZCXdJDtxvnAbmfj5ldVeGDhgbgJtwV4rv8GxYDbQysnyOv-SbtmawvZjHSw9.png', 'http://test.yudao.iocoder.cn/LctVZCXdJDtxvnAbmfj5ldVeGDhgbgJtwV4rv8GxYDbQysnyOv-SbtmawvZjHSw9.png', 'image/png', 1881, '1', '2023-01-11 20:09:05', '1', '2023-01-11 20:09:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (263, 11, 'LctVZCXdJDtxvnAbmfj5lYkfO9_k__ItdjXnz9WL_fFniGJuDdwFxev7VVkY-4pm.png', 'LctVZCXdJDtxvnAbmfj5lYkfO9_k__ItdjXnz9WL_fFniGJuDdwFxev7VVkY-4pm.png', 'http://test.yudao.iocoder.cn/LctVZCXdJDtxvnAbmfj5lYkfO9_k__ItdjXnz9WL_fFniGJuDdwFxev7VVkY-4pm.png', 'image/png', 1881, '1', '2023-01-11 20:12:28', '1', '2023-01-11 20:12:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (264, 11, '3605vmNBLVAZJvobJRMJS_ta-s-rWN9YWfWxwNxcxk9U2V1Dsm0KlKVVypzO9Qn3.png', '3605vmNBLVAZJvobJRMJS_ta-s-rWN9YWfWxwNxcxk9U2V1Dsm0KlKVVypzO9Qn3.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS_ta-s-rWN9YWfWxwNxcxk9U2V1Dsm0KlKVVypzO9Qn3.png', 'image/png', 1687, '1', '2023-01-11 22:20:01', '1', '2023-01-11 22:20:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (265, 11, '3605vmNBLVAZJvobJRMJS0kM-g3fcnSAjqMlyhm406xrVFNxorrCdqZt9xz5TTy2.png', '3605vmNBLVAZJvobJRMJS0kM-g3fcnSAjqMlyhm406xrVFNxorrCdqZt9xz5TTy2.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS0kM-g3fcnSAjqMlyhm406xrVFNxorrCdqZt9xz5TTy2.png', 'image/png', 1687, '1', '2023-01-11 22:21:20', '1', '2023-01-11 22:21:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (266, 11, '3605vmNBLVAZJvobJRMJS3Zy_b8Tfm3wzDjjxF3Qup-_gwyyD1cKAiMSJBgflxpO.png', '3605vmNBLVAZJvobJRMJS3Zy_b8Tfm3wzDjjxF3Qup-_gwyyD1cKAiMSJBgflxpO.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS3Zy_b8Tfm3wzDjjxF3Qup-_gwyyD1cKAiMSJBgflxpO.png', 'image/png', 1687, '1', '2023-01-11 22:24:51', '1', '2023-01-11 22:24:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (267, 11, '3605vmNBLVAZJvobJRMJS7lk8VUtgbk6xrBvsFo3ZAEqRXPyGOJdP1kfyuntiVSf.png', '3605vmNBLVAZJvobJRMJS7lk8VUtgbk6xrBvsFo3ZAEqRXPyGOJdP1kfyuntiVSf.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS7lk8VUtgbk6xrBvsFo3ZAEqRXPyGOJdP1kfyuntiVSf.png', 'image/png', 1597, '1', '2023-01-11 22:26:04', '1', '2023-01-11 22:26:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (268, 11, '3605vmNBLVAZJvobJRMJS9IP1svFHTv4UnGWZ8GLYznz7mWM_aYRV-2AsJOiPBlQ.png', '3605vmNBLVAZJvobJRMJS9IP1svFHTv4UnGWZ8GLYznz7mWM_aYRV-2AsJOiPBlQ.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS9IP1svFHTv4UnGWZ8GLYznz7mWM_aYRV-2AsJOiPBlQ.png', 'image/png', 1687, '1', '2023-01-11 22:27:21', '1', '2023-01-11 22:27:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (269, 11, '3605vmNBLVAZJvobJRMJS9lslB6xn1IxJ4xAoRimj_0cdO9o82E64PQdV7KCQOLE.png', '3605vmNBLVAZJvobJRMJS9lslB6xn1IxJ4xAoRimj_0cdO9o82E64PQdV7KCQOLE.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS9lslB6xn1IxJ4xAoRimj_0cdO9o82E64PQdV7KCQOLE.png', 'image/png', 1597, '1', '2023-01-11 22:28:16', '1', '2023-01-11 22:28:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (270, 11, '3605vmNBLVAZJvobJRMJSx-MlPY0yBZOMjCKv7-oCF6IRLHKY7jJXDwWsBGmnnxs.png', '3605vmNBLVAZJvobJRMJSx-MlPY0yBZOMjCKv7-oCF6IRLHKY7jJXDwWsBGmnnxs.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJSx-MlPY0yBZOMjCKv7-oCF6IRLHKY7jJXDwWsBGmnnxs.png', 'image/png', 1597, '1', '2023-01-11 22:29:35', '1', '2023-01-11 22:29:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (271, 11, '3605vmNBLVAZJvobJRMJS5cjLs1uYRPq2M6MwMCQf05pbNJxZth34fJQ1-pjr4c6.png', '3605vmNBLVAZJvobJRMJS5cjLs1uYRPq2M6MwMCQf05pbNJxZth34fJQ1-pjr4c6.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJS5cjLs1uYRPq2M6MwMCQf05pbNJxZth34fJQ1-pjr4c6.png', 'image/png', 1687, '1', '2023-01-11 22:29:44', '1', '2023-01-11 22:29:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (272, 11, '3605vmNBLVAZJvobJRMJSyIPpiKeSt8lu_jmTCmMlcm2Dm2uGaqmx0loq91cgkqm.png', '3605vmNBLVAZJvobJRMJSyIPpiKeSt8lu_jmTCmMlcm2Dm2uGaqmx0loq91cgkqm.png', 'http://test.yudao.iocoder.cn/3605vmNBLVAZJvobJRMJSyIPpiKeSt8lu_jmTCmMlcm2Dm2uGaqmx0loq91cgkqm.png', 'image/png', 1597, '1', '2023-01-11 23:10:01', '1', '2023-01-11 23:10:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (273, 11, '7GZDXSGfzWv-n1iQvl6o9EwYb6Wz48CIs4uVXmgOUsaXE95AmA30LnIqhfgcmF2H.png', '7GZDXSGfzWv-n1iQvl6o9EwYb6Wz48CIs4uVXmgOUsaXE95AmA30LnIqhfgcmF2H.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9EwYb6Wz48CIs4uVXmgOUsaXE95AmA30LnIqhfgcmF2H.png', 'image/png', 1687, '1', '2023-01-11 23:23:23', '1', '2023-01-11 23:23:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (274, 11, '7GZDXSGfzWv-n1iQvl6o9JwbR7PjKOymbW0AaLMN0TRm0uD6fHDMOaMzdfKTkCza.png', '7GZDXSGfzWv-n1iQvl6o9JwbR7PjKOymbW0AaLMN0TRm0uD6fHDMOaMzdfKTkCza.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9JwbR7PjKOymbW0AaLMN0TRm0uD6fHDMOaMzdfKTkCza.png', 'image/png', 1597, '1', '2023-01-11 23:36:27', '1', '2023-01-11 23:36:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (275, 11, '7GZDXSGfzWv-n1iQvl6o9P4XogeT7BRosnP7zTFHcf_ZpJzxKBaelw2o90O0eSku.png', '7GZDXSGfzWv-n1iQvl6o9P4XogeT7BRosnP7zTFHcf_ZpJzxKBaelw2o90O0eSku.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9P4XogeT7BRosnP7zTFHcf_ZpJzxKBaelw2o90O0eSku.png', 'image/png', 1687, '1', '2023-01-11 23:39:45', '1', '2023-01-11 23:39:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (276, 11, '7GZDXSGfzWv-n1iQvl6o9HTevyM3Yfda4yqJJ4xrAsa0s-pGIga4gUQI22O72WPD.png', '7GZDXSGfzWv-n1iQvl6o9HTevyM3Yfda4yqJJ4xrAsa0s-pGIga4gUQI22O72WPD.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9HTevyM3Yfda4yqJJ4xrAsa0s-pGIga4gUQI22O72WPD.png', 'image/png', 1881, '1', '2023-01-12 00:05:26', '1', '2023-01-12 00:05:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (277, 11, '7GZDXSGfzWv-n1iQvl6o9Avm2DPHxwRtJd-ahOtrDwMLV7JMjzEd1WS_3HmJdx9U.png', '7GZDXSGfzWv-n1iQvl6o9Avm2DPHxwRtJd-ahOtrDwMLV7JMjzEd1WS_3HmJdx9U.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9Avm2DPHxwRtJd-ahOtrDwMLV7JMjzEd1WS_3HmJdx9U.png', 'image/png', 1687, '1', '2023-01-12 00:06:23', '1', '2023-01-12 00:06:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (278, 11, '7GZDXSGfzWv-n1iQvl6o9AfKZlKQaF-MCD9j6sZ5p39mt6SloMY503k9xAGsb95J.png', '7GZDXSGfzWv-n1iQvl6o9AfKZlKQaF-MCD9j6sZ5p39mt6SloMY503k9xAGsb95J.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9AfKZlKQaF-MCD9j6sZ5p39mt6SloMY503k9xAGsb95J.png', 'image/png', 1597, '1', '2023-01-12 00:10:08', '1', '2023-01-12 00:10:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (279, 11, '7GZDXSGfzWv-n1iQvl6o9MTTSwUc0844y4_AXb-0jHrYmJaaLMS5pjZxEsLePGR4.png', '7GZDXSGfzWv-n1iQvl6o9MTTSwUc0844y4_AXb-0jHrYmJaaLMS5pjZxEsLePGR4.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9MTTSwUc0844y4_AXb-0jHrYmJaaLMS5pjZxEsLePGR4.png', 'image/png', 1597, '1', '2023-01-12 00:15:55', '1', '2023-01-12 00:15:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (280, 11, '7GZDXSGfzWv-n1iQvl6o9OuoFqQwBsvyqCaLuPmLQm_H_C5-KLxHtPDFw0hvUbhf.png', '7GZDXSGfzWv-n1iQvl6o9OuoFqQwBsvyqCaLuPmLQm_H_C5-KLxHtPDFw0hvUbhf.png', 'http://test.yudao.iocoder.cn/7GZDXSGfzWv-n1iQvl6o9OuoFqQwBsvyqCaLuPmLQm_H_C5-KLxHtPDFw0hvUbhf.png', 'image/png', 1687, '1', '2023-01-12 00:17:04', '1', '2023-01-12 00:17:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (281, 11, 'a6kOoewXIbX57gB0kCb_Gx5mZfPnY7g24v4XmH-2aObhgu79cf155Gb9f8yxfbyt.png', 'a6kOoewXIbX57gB0kCb_Gx5mZfPnY7g24v4XmH-2aObhgu79cf155Gb9f8yxfbyt.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gx5mZfPnY7g24v4XmH-2aObhgu79cf155Gb9f8yxfbyt.png', 'image/png', 1597, '1', '2023-01-12 00:19:18', '1', '2023-01-12 00:19:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (282, 11, 'a6kOoewXIbX57gB0kCb_G9kKMy_YqvLdIRxPdNuufo340hH7k14Zu0MY_NK7kTw9.png', 'a6kOoewXIbX57gB0kCb_G9kKMy_YqvLdIRxPdNuufo340hH7k14Zu0MY_NK7kTw9.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G9kKMy_YqvLdIRxPdNuufo340hH7k14Zu0MY_NK7kTw9.png', 'image/png', 1597, '1', '2023-01-12 00:20:06', '1', '2023-01-12 00:20:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (283, 11, 'a6kOoewXIbX57gB0kCb_G2c5JCWzX2au8CpetPKyp83Jbhu-sYzndvAeCCG-jPie.png', 'a6kOoewXIbX57gB0kCb_G2c5JCWzX2au8CpetPKyp83Jbhu-sYzndvAeCCG-jPie.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G2c5JCWzX2au8CpetPKyp83Jbhu-sYzndvAeCCG-jPie.png', 'image/png', 1881, '1', '2023-01-12 00:21:17', '1', '2023-01-12 00:21:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (284, 11, 'a6kOoewXIbX57gB0kCb_G6A2ZnmSL_AZ4TLgX6p-Hjy62caHgQqzSO_yRkg8-Kaw.png', 'a6kOoewXIbX57gB0kCb_G6A2ZnmSL_AZ4TLgX6p-Hjy62caHgQqzSO_yRkg8-Kaw.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G6A2ZnmSL_AZ4TLgX6p-Hjy62caHgQqzSO_yRkg8-Kaw.png', 'image/png', 1597, '1', '2023-01-12 00:21:29', '1', '2023-01-12 00:21:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (285, 11, 'a6kOoewXIbX57gB0kCb_G0WfiRTUYrlPipDgWHUbhmYDbn3_iPjO-AfJulnP_YMI.png', 'a6kOoewXIbX57gB0kCb_G0WfiRTUYrlPipDgWHUbhmYDbn3_iPjO-AfJulnP_YMI.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0WfiRTUYrlPipDgWHUbhmYDbn3_iPjO-AfJulnP_YMI.png', 'image/png', 1687, '1', '2023-01-12 00:21:35', '1', '2023-01-12 00:21:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (286, 11, 'a6kOoewXIbX57gB0kCb_G0IVxqJM7crEE-mQoGEpjym-Yz-CGpguVUaXRnSxvRu_dJJHgKWNxaYTe8CCsjHRaQ.mp3', 'a6kOoewXIbX57gB0kCb_G0IVxqJM7crEE-mQoGEpjym-Yz-CGpguVUaXRnSxvRu_dJJHgKWNxaYTe8CCsjHRaQ.mp3', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0IVxqJM7crEE-mQoGEpjym-Yz-CGpguVUaXRnSxvRu_dJJHgKWNxaYTe8CCsjHRaQ.mp3', 'audio/mpeg', 174337, '1', '2023-01-12 00:35:31', '1', '2023-01-12 00:35:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (287, 11, 'a6kOoewXIbX57gB0kCb_G0zGoZcwtOkVCoyUvX9x95fZwAT-gzz8cSaGn7HAkgd70MwV0FM_KlkwhDpy4PVyow.mp3', 'a6kOoewXIbX57gB0kCb_G0zGoZcwtOkVCoyUvX9x95fZwAT-gzz8cSaGn7HAkgd70MwV0FM_KlkwhDpy4PVyow.mp3', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0zGoZcwtOkVCoyUvX9x95fZwAT-gzz8cSaGn7HAkgd70MwV0FM_KlkwhDpy4PVyow.mp3', 'audio/mpeg', 174337, '1', '2023-01-12 00:36:25', '1', '2023-01-12 00:36:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (288, 11, 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', 'audio/mpeg', 174337, '1', '2023-01-12 00:37:54', '1', '2023-01-12 00:37:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (289, 11, 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', 'audio/mpeg', 174337, '1', '2023-01-12 00:42:23', '1', '2023-01-12 00:42:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (290, 11, 'a6kOoewXIbX57gB0kCb_G7tIHfuhmE13q3fz5f5iIQ9JJ7nW-nUSy7gb4k1elX0l.png', 'a6kOoewXIbX57gB0kCb_G7tIHfuhmE13q3fz5f5iIQ9JJ7nW-nUSy7gb4k1elX0l.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G7tIHfuhmE13q3fz5f5iIQ9JJ7nW-nUSy7gb4k1elX0l.png', 'image/png', 1687, '1', '2023-01-12 00:43:55', '1', '2023-01-12 00:43:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (291, 11, 'a6kOoewXIbX57gB0kCb_G1ChvKNz-esnmTodHTou4VFHa0hEef6Tn1EpFQxJB0Hc.png', 'a6kOoewXIbX57gB0kCb_G1ChvKNz-esnmTodHTou4VFHa0hEef6Tn1EpFQxJB0Hc.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G1ChvKNz-esnmTodHTou4VFHa0hEef6Tn1EpFQxJB0Hc.png', 'image/png', 1687, '1', '2023-01-12 00:44:10', '1', '2023-01-12 00:44:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (292, 11, 'a6kOoewXIbX57gB0kCb_GxPuheD2PZeRScEONmFr6WpBPCtBOCKVYBakhmlO09hs.png', 'a6kOoewXIbX57gB0kCb_GxPuheD2PZeRScEONmFr6WpBPCtBOCKVYBakhmlO09hs.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_GxPuheD2PZeRScEONmFr6WpBPCtBOCKVYBakhmlO09hs.png', 'image/png', 1597, '1', '2023-01-12 00:44:27', '1', '2023-01-12 00:44:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (293, 11, 'a6kOoewXIbX57gB0kCb_G_qM9GAmjZR2G18cVGNK8QnFyHmz1hm1boOK7whAQAeU.png', 'a6kOoewXIbX57gB0kCb_G_qM9GAmjZR2G18cVGNK8QnFyHmz1hm1boOK7whAQAeU.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G_qM9GAmjZR2G18cVGNK8QnFyHmz1hm1boOK7whAQAeU.png', 'image/png', 1881, '1', '2023-01-12 00:45:19', '1', '2023-01-12 00:45:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (294, 11, 'a6kOoewXIbX57gB0kCb_G7dbZeIk9Y99BFXXvZNv1r2Lskr9hz5C_namgw0Q1PXc.png', 'a6kOoewXIbX57gB0kCb_G7dbZeIk9Y99BFXXvZNv1r2Lskr9hz5C_namgw0Q1PXc.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G7dbZeIk9Y99BFXXvZNv1r2Lskr9hz5C_namgw0Q1PXc.png', 'image/png', 1687, '1', '2023-01-12 00:45:27', '1', '2023-01-12 00:45:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (295, 11, 'a6kOoewXIbX57gB0kCb_G9f1ggwnhgWpsdIcO0Z_hBurisu8_vqpwJqrsxLSoBR5.png', 'a6kOoewXIbX57gB0kCb_G9f1ggwnhgWpsdIcO0Z_hBurisu8_vqpwJqrsxLSoBR5.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G9f1ggwnhgWpsdIcO0Z_hBurisu8_vqpwJqrsxLSoBR5.png', 'image/png', 1881, '1', '2023-01-12 00:47:18', '1', '2023-01-12 00:47:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (296, 11, 'a6kOoewXIbX57gB0kCb_G8NBuXODSVS7PSfZjSX04ajQlkDD6F5Ghy3JPxv4lPZm.png', 'a6kOoewXIbX57gB0kCb_G8NBuXODSVS7PSfZjSX04ajQlkDD6F5Ghy3JPxv4lPZm.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G8NBuXODSVS7PSfZjSX04ajQlkDD6F5Ghy3JPxv4lPZm.png', 'image/png', 1687, '1', '2023-01-12 00:48:10', '1', '2023-01-12 00:48:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (297, 11, 'a6kOoewXIbX57gB0kCb_G2j3uyx6W9YrosijXEG0Vr9aU97jKFRGnnbJB0ZMqw3C.png', 'a6kOoewXIbX57gB0kCb_G2j3uyx6W9YrosijXEG0Vr9aU97jKFRGnnbJB0ZMqw3C.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G2j3uyx6W9YrosijXEG0Vr9aU97jKFRGnnbJB0ZMqw3C.png', 'image/png', 1687, '1', '2023-01-12 00:49:34', '1', '2023-01-12 00:49:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (298, 11, 'a6kOoewXIbX57gB0kCb_G5hGwh0LKWQRK8dIF04VcUaZ5YVp5PWVnhl5bV5Tb0nW.png', 'a6kOoewXIbX57gB0kCb_G5hGwh0LKWQRK8dIF04VcUaZ5YVp5PWVnhl5bV5Tb0nW.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G5hGwh0LKWQRK8dIF04VcUaZ5YVp5PWVnhl5bV5Tb0nW.png', 'image/png', 1597, '1', '2023-01-12 00:50:37', '1', '2023-01-12 00:50:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (299, 11, 'a6kOoewXIbX57gB0kCb_G0g4qGe8e8zUUykyuq5ypwglwlNVP6hYtP1sCI268sdu.png', 'a6kOoewXIbX57gB0kCb_G0g4qGe8e8zUUykyuq5ypwglwlNVP6hYtP1sCI268sdu.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0g4qGe8e8zUUykyuq5ypwglwlNVP6hYtP1sCI268sdu.png', 'image/png', 1687, '1', '2023-01-12 00:51:48', '1', '2023-01-12 00:51:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (300, 11, 'a6kOoewXIbX57gB0kCb_G7a3CZMnDXE-HFFxZjah4lTWrZv00J4KBX_3_0tHSFLC.png', 'a6kOoewXIbX57gB0kCb_G7a3CZMnDXE-HFFxZjah4lTWrZv00J4KBX_3_0tHSFLC.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G7a3CZMnDXE-HFFxZjah4lTWrZv00J4KBX_3_0tHSFLC.png', 'image/png', 1687, '1', '2023-01-12 00:52:31', '1', '2023-01-12 00:52:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (301, 11, 'a6kOoewXIbX57gB0kCb_G1BmRNIQD10tLBG2qDO0AtxWkYEzb8ADSAu0cQEV_f3L.png', 'a6kOoewXIbX57gB0kCb_G1BmRNIQD10tLBG2qDO0AtxWkYEzb8ADSAu0cQEV_f3L.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G1BmRNIQD10tLBG2qDO0AtxWkYEzb8ADSAu0cQEV_f3L.png', 'image/png', 1881, '1', '2023-01-12 00:53:28', '1', '2023-01-12 00:53:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (302, 11, 'a6kOoewXIbX57gB0kCb_G08qELovqQyYbRtKZaKZr69BPgTnibd7LFhAcwSX6Dhx.png', 'a6kOoewXIbX57gB0kCb_G08qELovqQyYbRtKZaKZr69BPgTnibd7LFhAcwSX6Dhx.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G08qELovqQyYbRtKZaKZr69BPgTnibd7LFhAcwSX6Dhx.png', 'image/png', 1881, '1', '2023-01-12 00:54:23', '1', '2023-01-12 00:54:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (303, 11, 'a6kOoewXIbX57gB0kCb_G0eOSKiFUE2YbMnTyh5hg03WnL0XRikC6XXyO3ft8Jym.png', 'a6kOoewXIbX57gB0kCb_G0eOSKiFUE2YbMnTyh5hg03WnL0XRikC6XXyO3ft8Jym.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0eOSKiFUE2YbMnTyh5hg03WnL0XRikC6XXyO3ft8Jym.png', 'image/png', 1687, '1', '2023-01-12 00:55:04', '1', '2023-01-12 00:55:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (304, 11, 'a6kOoewXIbX57gB0kCb_G1OuYneKu_VeBdJuvh0sM_oHQ4atXhoD0YecM2QDbVdt.png', 'a6kOoewXIbX57gB0kCb_G1OuYneKu_VeBdJuvh0sM_oHQ4atXhoD0YecM2QDbVdt.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G1OuYneKu_VeBdJuvh0sM_oHQ4atXhoD0YecM2QDbVdt.png', 'image/png', 1687, '1', '2023-01-12 00:55:26', '1', '2023-01-12 00:55:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (305, 11, 'a6kOoewXIbX57gB0kCb_G0880G4BHG9CEIg4C_I6sVwrBKd8MqQu91hQWleBBJ8A.png', 'a6kOoewXIbX57gB0kCb_G0880G4BHG9CEIg4C_I6sVwrBKd8MqQu91hQWleBBJ8A.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0880G4BHG9CEIg4C_I6sVwrBKd8MqQu91hQWleBBJ8A.png', 'image/png', 1881, '1', '2023-01-12 00:56:32', '1', '2023-01-12 00:56:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (306, 11, 'a6kOoewXIbX57gB0kCb_Gw3gxJhDAacPr9l1isEbAqG8DW7qpd_VfcHAaaB0LHIG.png', 'a6kOoewXIbX57gB0kCb_Gw3gxJhDAacPr9l1isEbAqG8DW7qpd_VfcHAaaB0LHIG.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gw3gxJhDAacPr9l1isEbAqG8DW7qpd_VfcHAaaB0LHIG.png', 'image/png', 1881, '1', '2023-01-12 00:59:45', '1', '2023-01-12 00:59:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (307, 11, 'a6kOoewXIbX57gB0kCb_G4NLt1wW-hRWwegchDH101j9vmSoMbCqv4i4MKG5reHp.png', 'a6kOoewXIbX57gB0kCb_G4NLt1wW-hRWwegchDH101j9vmSoMbCqv4i4MKG5reHp.png', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G4NLt1wW-hRWwegchDH101j9vmSoMbCqv4i4MKG5reHp.png', 'image/png', 1597, '1', '2023-01-12 00:59:58', '1', '2023-01-12 00:59:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (308, 11, 'K6off5qtfbPrP6ep-SO8OA6mJ1ZAU63l5EY93uwrGU--2hffJbLBmqVlk3Hjal6G.png', 'K6off5qtfbPrP6ep-SO8OA6mJ1ZAU63l5EY93uwrGU--2hffJbLBmqVlk3Hjal6G.png', 'http://test.yudao.iocoder.cn/K6off5qtfbPrP6ep-SO8OA6mJ1ZAU63l5EY93uwrGU--2hffJbLBmqVlk3Hjal6G.png', 'image/png', 1687, '1', '2023-01-12 08:59:41', '1', '2023-01-12 08:59:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (309, 11, 'K6off5qtfbPrP6ep-SO8OMa5ugI4_YLk41zIJ7_6zQQe-QNSvRpSe6Zx1CGU9nGE.png', 'K6off5qtfbPrP6ep-SO8OMa5ugI4_YLk41zIJ7_6zQQe-QNSvRpSe6Zx1CGU9nGE.png', 'http://test.yudao.iocoder.cn/K6off5qtfbPrP6ep-SO8OMa5ugI4_YLk41zIJ7_6zQQe-QNSvRpSe6Zx1CGU9nGE.png', 'image/png', 1597, '1', '2023-01-12 09:04:23', '1', '2023-01-12 09:04:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (310, 11, 'r6ryvl6LrxBU0miaST4Y-kT1le6oD-CBSKUGJVnBaITDX9s-vmgTVyDfkRIIHeOa.png', 'r6ryvl6LrxBU0miaST4Y-kT1le6oD-CBSKUGJVnBaITDX9s-vmgTVyDfkRIIHeOa.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-kT1le6oD-CBSKUGJVnBaITDX9s-vmgTVyDfkRIIHeOa.png', 'image/png', 1881, '1', '2023-01-12 09:59:59', '1', '2023-01-12 09:59:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (311, 11, 'r6ryvl6LrxBU0miaST4Y-rYpgKFtUNsibH3jpJotkMIAmdNdJGgbkAeite98fLA0.png', 'r6ryvl6LrxBU0miaST4Y-rYpgKFtUNsibH3jpJotkMIAmdNdJGgbkAeite98fLA0.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-rYpgKFtUNsibH3jpJotkMIAmdNdJGgbkAeite98fLA0.png', 'image/png', 1881, '1', '2023-01-12 10:09:11', '1', '2023-01-12 10:09:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (312, 11, 'r6ryvl6LrxBU0miaST4Y-hNZK4fyTh-dntagmvOX9oZ93e9HdIiyHiO0Fe_gkgls.png', 'r6ryvl6LrxBU0miaST4Y-hNZK4fyTh-dntagmvOX9oZ93e9HdIiyHiO0Fe_gkgls.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-hNZK4fyTh-dntagmvOX9oZ93e9HdIiyHiO0Fe_gkgls.png', 'image/png', 1881, '1', '2023-01-12 11:11:28', '1', '2023-01-12 11:11:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (313, 11, 'r6ryvl6LrxBU0miaST4Y-oknL38miJiz9nUGBwBbCGKmfE0qRfSyaH8jDQRNaOfP.png', 'r6ryvl6LrxBU0miaST4Y-oknL38miJiz9nUGBwBbCGKmfE0qRfSyaH8jDQRNaOfP.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-oknL38miJiz9nUGBwBbCGKmfE0qRfSyaH8jDQRNaOfP.png', 'image/png', 1881, '1', '2023-01-12 11:12:18', '1', '2023-01-12 11:12:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (314, 11, 'r6ryvl6LrxBU0miaST4Y-qknMeCUS75YHYoq9aTUmoRXCPPAKLM9Isy8vX4jU_Ie.png', 'r6ryvl6LrxBU0miaST4Y-qknMeCUS75YHYoq9aTUmoRXCPPAKLM9Isy8vX4jU_Ie.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-qknMeCUS75YHYoq9aTUmoRXCPPAKLM9Isy8vX4jU_Ie.png', 'image/png', 1881, '1', '2023-01-12 11:13:55', '1', '2023-01-12 11:13:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (315, 11, 'r6ryvl6LrxBU0miaST4Y-lGTgVO6uvfW6cVa5C-29e2BTmYuFH-Y-3e9uoHQPuyS.png', 'r6ryvl6LrxBU0miaST4Y-lGTgVO6uvfW6cVa5C-29e2BTmYuFH-Y-3e9uoHQPuyS.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-lGTgVO6uvfW6cVa5C-29e2BTmYuFH-Y-3e9uoHQPuyS.png', 'image/png', 1881, '1', '2023-01-12 11:18:30', '1', '2023-01-12 11:18:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (316, 11, 'Sooq6lT2Kgf6ZmDxG2rsGK4a-x_WVExS2GFEstUXsgUTccdU437yi75p2a2qqPS9.png', 'Sooq6lT2Kgf6ZmDxG2rsGK4a-x_WVExS2GFEstUXsgUTccdU437yi75p2a2qqPS9.png', 'http://test.yudao.iocoder.cn/Sooq6lT2Kgf6ZmDxG2rsGK4a-x_WVExS2GFEstUXsgUTccdU437yi75p2a2qqPS9.png', 'image/png', 1881, '1', '2023-01-12 13:51:06', '1', '2023-01-12 13:51:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (317, 11, '0-2EXqrRK_xgmAJN7imvk9ivKv7mLLFN1O7WkjS1Tv2o_VJ7W5mNW8H1OlGKisfP.png', '0-2EXqrRK_xgmAJN7imvk9ivKv7mLLFN1O7WkjS1Tv2o_VJ7W5mNW8H1OlGKisfP.png', 'http://test.yudao.iocoder.cn/0-2EXqrRK_xgmAJN7imvk9ivKv7mLLFN1O7WkjS1Tv2o_VJ7W5mNW8H1OlGKisfP.png', 'image/png', 1687, '1', '2023-01-12 16:39:28', '1', '2023-01-12 16:39:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (318, 11, 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', 'video/quicktime', 355574, '1', '2023-01-12 17:27:32', '1', '2023-01-12 17:27:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (319, 11, 'YPnKCyLwXVa3qDw05drDzebhVY6Jsv4OjXs3dqezCc9Iwg39FYkx5FhH2pUdzcXM.png', 'YPnKCyLwXVa3qDw05drDzebhVY6Jsv4OjXs3dqezCc9Iwg39FYkx5FhH2pUdzcXM.png', 'http://test.yudao.iocoder.cn/YPnKCyLwXVa3qDw05drDzebhVY6Jsv4OjXs3dqezCc9Iwg39FYkx5FhH2pUdzcXM.png', 'image/png', 1881, '1', '2023-01-12 20:10:18', '1', '2023-01-12 20:10:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (320, 11, 'YPnKCyLwXVa3qDw05drDzQLsXA6jwdh2Thq5d39jwzc9sHXok3I-DAxqPLmwoFmH.jpg', 'YPnKCyLwXVa3qDw05drDzQLsXA6jwdh2Thq5d39jwzc9sHXok3I-DAxqPLmwoFmH.jpg', 'http://test.yudao.iocoder.cn/YPnKCyLwXVa3qDw05drDzQLsXA6jwdh2Thq5d39jwzc9sHXok3I-DAxqPLmwoFmH.jpg', 'image/jpeg', 58591, '1', '2023-01-12 20:12:16', '1', '2023-01-12 20:12:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (321, 11, 'YPnKCyLwXVa3qDw05drDzZjN6Y2Xb1ElQR4EnQcx4HLfGC2v9b2Fw3K36U7ryQCa.png', 'YPnKCyLwXVa3qDw05drDzZjN6Y2Xb1ElQR4EnQcx4HLfGC2v9b2Fw3K36U7ryQCa.png', 'http://test.yudao.iocoder.cn/YPnKCyLwXVa3qDw05drDzZjN6Y2Xb1ElQR4EnQcx4HLfGC2v9b2Fw3K36U7ryQCa.png', 'image/png', 1881, '1', '2023-01-12 20:14:36', '1', '2023-01-12 20:14:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (322, 11, 'YPnKCyLwXVa3qDw05drDzYD7Cfxmn0DD3pm0FzWDlmNv7UakpkOWN0hHbXYrhhF7.png', 'YPnKCyLwXVa3qDw05drDzYD7Cfxmn0DD3pm0FzWDlmNv7UakpkOWN0hHbXYrhhF7.png', 'http://test.yudao.iocoder.cn/YPnKCyLwXVa3qDw05drDzYD7Cfxmn0DD3pm0FzWDlmNv7UakpkOWN0hHbXYrhhF7.png', 'image/png', 1687, '1', '2023-01-12 20:19:25', '1', '2023-01-12 20:19:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (323, 11, 'YPnKCyLwXVa3qDw05drDzWTDV4p0vpYWUWR9BHeMR7Qjs9lgBpSFGB33BO6_MPY9.jpg', 'YPnKCyLwXVa3qDw05drDzWTDV4p0vpYWUWR9BHeMR7Qjs9lgBpSFGB33BO6_MPY9.jpg', 'http://test.yudao.iocoder.cn/YPnKCyLwXVa3qDw05drDzWTDV4p0vpYWUWR9BHeMR7Qjs9lgBpSFGB33BO6_MPY9.jpg', 'image/jpeg', 58591, '1', '2023-01-12 20:23:11', '1', '2023-01-12 20:23:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (324, 11, 'XQockIDz-7p8wHuI0wxzdwXWzg0RxCyF7-iVyeK96euvFMgJ6X_oX_wrl86g6oFK.mp4', 'XQockIDz-7p8wHuI0wxzdwXWzg0RxCyF7-iVyeK96euvFMgJ6X_oX_wrl86g6oFK.mp4', 'http://test.yudao.iocoder.cn/XQockIDz-7p8wHuI0wxzdwXWzg0RxCyF7-iVyeK96euvFMgJ6X_oX_wrl86g6oFK.mp4', 'video/quicktime', 355574, '1', '2023-01-12 20:48:08', '1', '2023-01-12 20:48:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (325, 11, 'XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', 'XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', 'http://test.yudao.iocoder.cn/XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', 'video/quicktime', 355574, '1', '2023-01-12 20:48:44', '1', '2023-01-12 20:48:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (326, 11, 'r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png', 'r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png', 'image/png', 1881, '1', '2023-01-12 22:36:20', '1', '2023-01-12 22:36:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (327, 11, 'r6ryvl6LrxBU0miaST4Y-iSpJARJA90B9qv1ol-rCIjWIfFO_eIOYrcnQcwF5Xsc.jpg', 'r6ryvl6LrxBU0miaST4Y-iSpJARJA90B9qv1ol-rCIjWIfFO_eIOYrcnQcwF5Xsc.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-iSpJARJA90B9qv1ol-rCIjWIfFO_eIOYrcnQcwF5Xsc.jpg', 'image/jpeg', 125161, '1', '2023-01-13 23:37:59', '1', '2023-01-13 23:37:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (328, 11, 'r6ryvl6LrxBU0miaST4Y-vOJi2e31Y09hAqvac4rrKbaRY6apeAMNOa5N50D5QJ1.jpg', 'r6ryvl6LrxBU0miaST4Y-vOJi2e31Y09hAqvac4rrKbaRY6apeAMNOa5N50D5QJ1.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-vOJi2e31Y09hAqvac4rrKbaRY6apeAMNOa5N50D5QJ1.jpg', 'image/jpeg', 125161, '1', '2023-01-13 23:41:31', '1', '2023-01-13 23:41:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (329, 11, 'r6ryvl6LrxBU0miaST4Y-ntZiMJV3x0fsjyDIKjmHwj6bmFjL38nfzb2InGI8_N0.jpg', 'r6ryvl6LrxBU0miaST4Y-ntZiMJV3x0fsjyDIKjmHwj6bmFjL38nfzb2InGI8_N0.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-ntZiMJV3x0fsjyDIKjmHwj6bmFjL38nfzb2InGI8_N0.jpg', 'image/jpeg', 125161, '1', '2023-01-13 23:58:28', '1', '2023-01-13 23:58:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (330, 11, 'r6ryvl6LrxBU0miaST4Y-oOI1DGksYDMpGdj6TOy4MoVABX9uWgyX0epnyCH4PZB.jpg', 'r6ryvl6LrxBU0miaST4Y-oOI1DGksYDMpGdj6TOy4MoVABX9uWgyX0epnyCH4PZB.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-oOI1DGksYDMpGdj6TOy4MoVABX9uWgyX0epnyCH4PZB.jpg', 'image/jpeg', 125161, '1', '2023-01-14 00:00:26', '1', '2023-01-14 00:00:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (331, 11, 'r6ryvl6LrxBU0miaST4Y-iyVU9AknOaLUs-46o6UitQ3hvlBAHU4iJ2Yu9wnjuDD.png', 'r6ryvl6LrxBU0miaST4Y-iyVU9AknOaLUs-46o6UitQ3hvlBAHU4iJ2Yu9wnjuDD.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-iyVU9AknOaLUs-46o6UitQ3hvlBAHU4iJ2Yu9wnjuDD.png', 'image/png', 1881, '1', '2023-01-14 00:08:18', '1', '2023-01-14 00:08:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (332, 11, 'r6ryvl6LrxBU0miaST4Y-qPyp5uAdYLL-EmHGH0-ZyRiVVTDVrkOAQSdi_rJcvqC.jpg', 'r6ryvl6LrxBU0miaST4Y-qPyp5uAdYLL-EmHGH0-ZyRiVVTDVrkOAQSdi_rJcvqC.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-qPyp5uAdYLL-EmHGH0-ZyRiVVTDVrkOAQSdi_rJcvqC.jpg', 'image/jpeg', 125161, '1', '2023-01-14 00:12:35', '1', '2023-01-14 00:12:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (333, 11, 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', 'image/jpeg', 125161, '1', '2023-01-14 00:14:45', '1', '2023-01-14 00:14:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (334, 11, 'r6ryvl6LrxBU0miaST4Y-seifse1Usvhgxh0dJgTKSkJME18OurDsZ-P-nhetU8N.jpg', 'r6ryvl6LrxBU0miaST4Y-seifse1Usvhgxh0dJgTKSkJME18OurDsZ-P-nhetU8N.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-seifse1Usvhgxh0dJgTKSkJME18OurDsZ-P-nhetU8N.jpg', 'image/jpeg', 125161, '1', '2023-01-14 00:28:01', '1', '2023-01-14 00:28:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (335, 11, 'r6ryvl6LrxBU0miaST4Y-iRyRg0Si1RANGOYGNuFy-MzO_mMdUfYz2YCIxICs06G.jpg', 'r6ryvl6LrxBU0miaST4Y-iRyRg0Si1RANGOYGNuFy-MzO_mMdUfYz2YCIxICs06G.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-iRyRg0Si1RANGOYGNuFy-MzO_mMdUfYz2YCIxICs06G.jpg', 'image/jpeg', 125161, '1', '2023-01-14 00:29:43', '1', '2023-01-14 00:29:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (336, 11, 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', 'image/png', 1687, '1', '2023-01-14 00:52:26', '1', '2023-01-14 00:52:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (337, 11, 'r6ryvl6LrxBU0miaST4Y-tlQmcl3RdC-Jcgns6IQtf7zenGy3b86WLT7GzUcrb1T.png', 'r6ryvl6LrxBU0miaST4Y-tlQmcl3RdC-Jcgns6IQtf7zenGy3b86WLT7GzUcrb1T.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-tlQmcl3RdC-Jcgns6IQtf7zenGy3b86WLT7GzUcrb1T.png', 'image/png', 1597, '1', '2023-01-14 00:56:06', '1', '2023-01-14 00:56:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (338, 11, 'r6ryvl6LrxBU0miaST4Y-pWqXoCgpdNp1fvSv7c6zoTnCsW6BGAVFNJ-E9hkAIXO.jpg', 'r6ryvl6LrxBU0miaST4Y-pWqXoCgpdNp1fvSv7c6zoTnCsW6BGAVFNJ-E9hkAIXO.jpg', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pWqXoCgpdNp1fvSv7c6zoTnCsW6BGAVFNJ-E9hkAIXO.jpg', 'image/jpeg', 125161, '1', '2023-01-14 01:30:49', '1', '2023-01-14 01:30:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (339, 11, 'r6ryvl6LrxBU0miaST4Y-vNzhGc_1b37nxAvj0Zt8iuGACe-mC9_a5OhVFIzt0DX.png', 'r6ryvl6LrxBU0miaST4Y-vNzhGc_1b37nxAvj0Zt8iuGACe-mC9_a5OhVFIzt0DX.png', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-vNzhGc_1b37nxAvj0Zt8iuGACe-mC9_a5OhVFIzt0DX.png', 'image/png', 1687, '1', '2023-01-14 08:20:53', '1', '2023-01-14 08:20:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (340, 11, 'rdp2FpJLZJb_Z771EZCE0o22qw7A8nDBiGTmnyS3hp94hV5zfgfcuLJza36ANHMh.png', 'rdp2FpJLZJb_Z771EZCE0o22qw7A8nDBiGTmnyS3hp94hV5zfgfcuLJza36ANHMh.png', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0o22qw7A8nDBiGTmnyS3hp94hV5zfgfcuLJza36ANHMh.png', 'image/png', 1597, '1', '2023-01-14 08:32:07', '1', '2023-01-14 08:32:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (341, 11, 'rdp2FpJLZJb_Z771EZCE0tidYFBxnaavyulH8ugCdl8kP7Rvbr3oDpeUehO2Yw_a.png', 'rdp2FpJLZJb_Z771EZCE0tidYFBxnaavyulH8ugCdl8kP7Rvbr3oDpeUehO2Yw_a.png', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0tidYFBxnaavyulH8ugCdl8kP7Rvbr3oDpeUehO2Yw_a.png', 'image/png', 1881, '1', '2023-01-14 08:32:30', '1', '2023-01-14 08:32:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (342, 11, 'rdp2FpJLZJb_Z771EZCE0szXIJm3VmqB8_QHT6W9_-vzv_tH9nkYpuOnbYufyY2T.jpg', 'rdp2FpJLZJb_Z771EZCE0szXIJm3VmqB8_QHT6W9_-vzv_tH9nkYpuOnbYufyY2T.jpg', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0szXIJm3VmqB8_QHT6W9_-vzv_tH9nkYpuOnbYufyY2T.jpg', 'image/jpeg', 125161, '1', '2023-01-14 08:46:00', '1', '2023-01-14 08:46:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (343, 11, 'rdp2FpJLZJb_Z771EZCE0vE-s0cIZgtCNYp0bpcTkA99rugtpvtXfjiYusiq9xJ6.png', 'rdp2FpJLZJb_Z771EZCE0vE-s0cIZgtCNYp0bpcTkA99rugtpvtXfjiYusiq9xJ6.png', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0vE-s0cIZgtCNYp0bpcTkA99rugtpvtXfjiYusiq9xJ6.png', 'image/png', 1597, '1', '2023-01-14 14:51:45', '1', '2023-01-14 14:51:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (344, 11, 'rdp2FpJLZJb_Z771EZCE0qjnfCASkuTgIVUma1pfvFLX8HYBDI_6wJKKWqbwnj2v.jpg', 'rdp2FpJLZJb_Z771EZCE0qjnfCASkuTgIVUma1pfvFLX8HYBDI_6wJKKWqbwnj2v.jpg', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0qjnfCASkuTgIVUma1pfvFLX8HYBDI_6wJKKWqbwnj2v.jpg', 'image/jpeg', 125161, '1', '2023-01-14 14:52:05', '1', '2023-01-14 14:52:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (345, 11, 'rdp2FpJLZJb_Z771EZCE0sdggkEkJ9BXy1wIiory8puv2L0sRYeBBVztrxmjjT_P.amr', 'rdp2FpJLZJb_Z771EZCE0sdggkEkJ9BXy1wIiory8puv2L0sRYeBBVztrxmjjT_P.amr', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0sdggkEkJ9BXy1wIiory8puv2L0sRYeBBVztrxmjjT_P.amr', 'audio/amr', 1532, '1', '2023-01-14 16:28:53', '1', '2023-01-14 16:28:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (346, 11, 'rdp2FpJLZJb_Z771EZCE0jlwnElym7bDUZUQI6t36O9xlh-wQWZpdDEVNHj_-Zo3.mp4', 'rdp2FpJLZJb_Z771EZCE0jlwnElym7bDUZUQI6t36O9xlh-wQWZpdDEVNHj_-Zo3.mp4', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0jlwnElym7bDUZUQI6t36O9xlh-wQWZpdDEVNHj_-Zo3.mp4', 'video/quicktime', 355574, '1', '2023-01-14 16:53:53', '1', '2023-01-14 16:53:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (347, 11, 'rdp2FpJLZJb_Z771EZCE0nKJFlsOPjLkDApXEgRjaGydiFVTsC0zMq8-x5V6-rG4.mp4', 'rdp2FpJLZJb_Z771EZCE0nKJFlsOPjLkDApXEgRjaGydiFVTsC0zMq8-x5V6-rG4.mp4', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0nKJFlsOPjLkDApXEgRjaGydiFVTsC0zMq8-x5V6-rG4.mp4', 'video/quicktime', 355574, '1', '2023-01-14 16:55:02', '1', '2023-01-14 16:55:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (348, 11, 'wBnOlFbeYaWXb7AVX5Ha_croeyGuW9LIPwJABmTkWn18-RFOqfeVUF-SB-auxwCP.png', 'wBnOlFbeYaWXb7AVX5Ha_croeyGuW9LIPwJABmTkWn18-RFOqfeVUF-SB-auxwCP.png', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_croeyGuW9LIPwJABmTkWn18-RFOqfeVUF-SB-auxwCP.png', 'image/png', 1881, '1', '2023-01-15 17:43:21', '1', '2023-01-15 17:43:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (349, 11, 'wBnOlFbeYaWXb7AVX5Ha_fOZQMPXHx1ku4GcVGTrCXk5KrjABxwlqDOMyeV9lZ9c.png', 'wBnOlFbeYaWXb7AVX5Ha_fOZQMPXHx1ku4GcVGTrCXk5KrjABxwlqDOMyeV9lZ9c.png', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_fOZQMPXHx1ku4GcVGTrCXk5KrjABxwlqDOMyeV9lZ9c.png', 'image/png', 1881, '1', '2023-01-15 18:05:27', '1', '2023-01-15 18:05:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (350, 11, 'wBnOlFbeYaWXb7AVX5Ha_XqhsVacZRkLJHDwQKVjP0Nz_gy0rLwaNUoN4vCg3RlY.png', 'wBnOlFbeYaWXb7AVX5Ha_XqhsVacZRkLJHDwQKVjP0Nz_gy0rLwaNUoN4vCg3RlY.png', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_XqhsVacZRkLJHDwQKVjP0Nz_gy0rLwaNUoN4vCg3RlY.png', 'image/png', 1881, '1', '2023-01-15 18:09:36', '1', '2023-01-15 18:09:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (351, 11, 'wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', 'wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', 'image/png', 1881, '1', '2023-01-15 18:16:08', '1', '2023-01-15 18:16:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (352, 11, 'D6edSI8ezFgfQ5CZQiUWrr_dPO0Zs5h2KQBZCR98O_KTgU4C5qyIlKx4g8aWN5iU.jpg', 'D6edSI8ezFgfQ5CZQiUWrr_dPO0Zs5h2KQBZCR98O_KTgU4C5qyIlKx4g8aWN5iU.jpg', 'http://test.yudao.iocoder.cn/D6edSI8ezFgfQ5CZQiUWrr_dPO0Zs5h2KQBZCR98O_KTgU4C5qyIlKx4g8aWN5iU.jpg', 'image/jpeg', 134169, NULL, '2023-01-15 19:45:18', NULL, '2023-01-15 19:45:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (353, 11, 'D6edSI8ezFgfQ5CZQiUWrl-z2h9XG98uJbsMGnEtHxRXFFvcjWmwNepr8WN8ArEc.jpg', 'D6edSI8ezFgfQ5CZQiUWrl-z2h9XG98uJbsMGnEtHxRXFFvcjWmwNepr8WN8ArEc.jpg', 'http://test.yudao.iocoder.cn/D6edSI8ezFgfQ5CZQiUWrl-z2h9XG98uJbsMGnEtHxRXFFvcjWmwNepr8WN8ArEc.jpg', 'image/jpeg', 610723, NULL, '2023-01-15 19:45:25', NULL, '2023-01-15 19:45:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (354, 11, 'D6edSI8ezFgfQ5CZQiUWrgKcmo3vQuFQF6UOSJyAFlKaPJGHEa9YnRP0EHduzO4p.jpg', 'D6edSI8ezFgfQ5CZQiUWrgKcmo3vQuFQF6UOSJyAFlKaPJGHEa9YnRP0EHduzO4p.jpg', 'http://test.yudao.iocoder.cn/D6edSI8ezFgfQ5CZQiUWrgKcmo3vQuFQF6UOSJyAFlKaPJGHEa9YnRP0EHduzO4p.jpg', 'image/jpeg', 258860, NULL, '2023-01-15 19:45:31', NULL, '2023-01-15 19:45:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (355, 11, 'l8A4cYhdY3NWlSvev5nTtI1oM0Czz0OQOiEU70TmG4jxQHvj_d0HBYsTvJMeQAGo.jpg', 'l8A4cYhdY3NWlSvev5nTtI1oM0Czz0OQOiEU70TmG4jxQHvj_d0HBYsTvJMeQAGo.jpg', 'http://test.yudao.iocoder.cn/l8A4cYhdY3NWlSvev5nTtI1oM0Czz0OQOiEU70TmG4jxQHvj_d0HBYsTvJMeQAGo.jpg', 'image/jpeg', 650754, NULL, '2023-01-17 23:38:04', NULL, '2023-01-17 23:38:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (356, 11, '1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:01:48', '1', '2023-02-05 21:01:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (357, 11, '1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:01:48', '1', '2023-02-05 21:01:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (358, 11, '1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (359, 11, '1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (360, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (361, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (362, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (363, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:40', '1', '2023-02-05 21:03:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (364, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:51', '1', '2023-02-05 21:03:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (365, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:03:51', '1', '2023-02-05 21:03:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (366, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:09', '1', '2023-02-05 21:04:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (367, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:14', '1', '2023-02-05 21:04:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (368, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:14', '1', '2023-02-05 21:04:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (369, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:16', '1', '2023-02-05 21:04:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (370, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:20', '1', '2023-02-05 21:04:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (371, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:20', '1', '2023-02-05 21:04:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (372, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:24', '1', '2023-02-05 21:04:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (373, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:04:26', '1', '2023-02-05 21:04:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (374, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:05:14', '1', '2023-02-05 21:05:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (375, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:05:44', '1', '2023-02-05 21:05:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (376, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:06:14', '1', '2023-02-05 21:06:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (377, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:06:33', '1', '2023-02-05 21:06:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (378, 11, 'go-view/1_index_preview.png', '1be120f71dff0d8ed2d7794e6836e51afec315b3ea39ad40f9e589418445e7b6.png', 'http://test.yudao.iocoder.cn/1be120f71dff0d8ed2d7794e6836e51afec315b3ea39ad40f9e589418445e7b6.png', 'image/png', 48721, '1', '2023-02-05 21:08:43', '1', '2023-02-05 21:08:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (379, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:08:44', '1', '2023-02-05 21:08:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (380, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:08:46', '1', '2023-02-05 21:08:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (381, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:08:54', '1', '2023-02-05 21:08:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (382, 11, 'go-view/1_index_preview.png', '3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'http://test.yudao.iocoder.cn/3c4d992c63f0638e5605022fa56704e9af5aa8961c3dbd23caaccc4272d8e85b.png', 'image/png', 121, '1', '2023-02-05 21:08:56', '1', '2023-02-05 21:08:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (383, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:09:51', '1', '2023-02-05 21:09:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (384, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:11', '1', '2023-02-05 21:10:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (385, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:14', '1', '2023-02-05 21:10:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (386, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:14', '1', '2023-02-05 21:10:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (387, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:17', '1', '2023-02-05 21:10:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (388, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:17', '1', '2023-02-05 21:10:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (389, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:23', '1', '2023-02-05 21:10:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (390, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:10:52', '1', '2023-02-05 21:10:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (391, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:11:21', '1', '2023-02-05 21:11:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (392, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:11:52', '1', '2023-02-05 21:11:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (393, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:11:52', '1', '2023-02-05 21:11:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (394, 11, 'go-view/1_index_preview.png', '0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'http://test.yudao.iocoder.cn/0bc87e54ae238c0ad633aa8b32ee5138e15aeaf5b1a69e465e4bfb03f9228c89.png', 'image/png', 324, '1', '2023-02-05 21:11:53', '1', '2023-02-05 21:11:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (395, 11, 'go-view/1_index_preview.png', '08974ea03cb3ee180ff928d1481fb4599789623c8a94e3e2c987aa404e82e58c.png', 'http://test.yudao.iocoder.cn/08974ea03cb3ee180ff928d1481fb4599789623c8a94e3e2c987aa404e82e58c.png', 'image/png', 43063, '1', '2023-02-05 21:14:01', '1', '2023-02-05 21:14:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (396, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:14:04', '1', '2023-02-05 21:14:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (397, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:14:59', '1', '2023-02-05 21:14:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (398, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:15:29', '1', '2023-02-05 21:15:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (399, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:16:04', '1', '2023-02-05 21:16:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (400, 11, 'go-view/1_index_background.png', '34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'http://test.yudao.iocoder.cn/34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'image/png', 26025, '1', '2023-02-05 21:16:06', '1', '2023-02-05 21:16:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (401, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:16:15', '1', '2023-02-05 21:16:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (402, 11, 'go-view/1_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-05 21:16:29', '1', '2023-02-05 21:16:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (403, 11, 'go-view/1_index_preview.png', '6d3be7ba52245a10f8d3fb480d499f7c3483aa621eb1e06bc11d75f0c3827a21.png', 'http://test.yudao.iocoder.cn/6d3be7ba52245a10f8d3fb480d499f7c3483aa621eb1e06bc11d75f0c3827a21.png', 'image/png', 548869, '1', '2023-02-05 21:16:32', '1', '2023-02-05 21:16:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (404, 11, 'go-view/1_index_preview.png', '22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'http://test.yudao.iocoder.cn/22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'image/png', 551441, '1', '2023-02-05 21:17:07', '1', '2023-02-05 21:17:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (405, 11, 'go-view/1_index_preview.png', '22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'http://test.yudao.iocoder.cn/22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'image/png', 551441, '1', '2023-02-05 21:17:07', '1', '2023-02-05 21:17:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (406, 11, 'go-view/1_index_preview.png', '68a73c374a5a01fa0ee3afcbc65843d6e3f775749b9d97f9eb21141e68902dd9.png', 'http://test.yudao.iocoder.cn/68a73c374a5a01fa0ee3afcbc65843d6e3f775749b9d97f9eb21141e68902dd9.png', 'image/png', 549580, '1', '2023-02-05 21:17:16', '1', '2023-02-05 21:17:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (407, 11, 'go-view/1_index_preview.png', '68a73c374a5a01fa0ee3afcbc65843d6e3f775749b9d97f9eb21141e68902dd9.png', 'http://test.yudao.iocoder.cn/68a73c374a5a01fa0ee3afcbc65843d6e3f775749b9d97f9eb21141e68902dd9.png', 'image/png', 549580, '1', '2023-02-05 21:17:23', '1', '2023-02-05 21:17:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (408, 11, 'go-view/1_index_preview.png', '22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'http://test.yudao.iocoder.cn/22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'image/png', 551441, '1', '2023-02-05 21:17:34', '1', '2023-02-05 21:17:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (409, 11, 'go-view/1_index_preview.png', '22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'http://test.yudao.iocoder.cn/22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'image/png', 551441, '1', '2023-02-05 21:17:35', '1', '2023-02-05 21:17:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (410, 11, 'go-view/1_index_preview.png', '22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'http://test.yudao.iocoder.cn/22801479d523b721219a0577a5d6964036df1e638c379bd2afa39e2796c7d98f.png', 'image/png', 551441, '1', '2023-02-05 21:17:44', '1', '2023-02-05 21:17:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (411, 11, 'go-view/1_index_preview.png', '4fd1d0e6f7282cb3d56347a08f6978f8ba4de7ac50f796abc9d37500ca2dcd6a.png', 'http://test.yudao.iocoder.cn/4fd1d0e6f7282cb3d56347a08f6978f8ba4de7ac50f796abc9d37500ca2dcd6a.png', 'image/png', 551027, '1', '2023-02-05 21:17:59', '1', '2023-02-05 21:17:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (412, 11, 'go-view/1_index_preview.png', '8674cfb5eb895452557f5668fc797cae27d54d15ba69b8ed83c658560d70794f.png', 'http://test.yudao.iocoder.cn/8674cfb5eb895452557f5668fc797cae27d54d15ba69b8ed83c658560d70794f.png', 'image/png', 557326, '1', '2023-02-05 21:18:02', '1', '2023-02-05 21:18:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (413, 11, 'go-view/1_index_preview.png', '8f61752bf3beeb57620ca2e371eb130624fd831720c0206bf5cbf542ee28c791.png', 'http://test.yudao.iocoder.cn/8f61752bf3beeb57620ca2e371eb130624fd831720c0206bf5cbf542ee28c791.png', 'image/png', 570779, '1', '2023-02-05 21:18:31', '1', '2023-02-05 21:18:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (414, 11, 'go-view/1_index_preview.png', '4a9d74e5bf242aefa8b4216fc9ba49fd6c0e91a949c4787009d8bc43e7d85659.png', 'http://test.yudao.iocoder.cn/4a9d74e5bf242aefa8b4216fc9ba49fd6c0e91a949c4787009d8bc43e7d85659.png', 'image/png', 144299, '1', '2023-02-05 21:19:16', '1', '2023-02-05 21:19:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (415, 11, 'go-view/1_index_preview.png', '8f61752bf3beeb57620ca2e371eb130624fd831720c0206bf5cbf542ee28c791.png', 'http://test.yudao.iocoder.cn/8f61752bf3beeb57620ca2e371eb130624fd831720c0206bf5cbf542ee28c791.png', 'image/png', 570779, '1', '2023-02-05 21:19:31', '1', '2023-02-05 21:19:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (416, 11, 'go-view/1_index_preview.png', 'c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'http://test.yudao.iocoder.cn/c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'image/png', 53960, '1', '2023-02-05 21:20:38', '1', '2023-02-05 21:20:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (417, 11, 'go-view/1_index_preview.png', 'c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'http://test.yudao.iocoder.cn/c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'image/png', 53960, '1', '2023-02-05 21:20:43', '1', '2023-02-05 21:20:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (418, 11, 'go-view/1_index_preview.png', 'c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'http://test.yudao.iocoder.cn/c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'image/png', 53960, '1', '2023-02-05 21:21:16', '1', '2023-02-05 21:21:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (419, 11, 'go-view/1_index_preview.png', 'c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'http://test.yudao.iocoder.cn/c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'image/png', 53960, '1', '2023-02-05 21:21:45', '1', '2023-02-05 21:21:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (420, 11, 'go-view/1_index_preview.png', 'c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'http://test.yudao.iocoder.cn/c9d2386a2038286216c46a70e42f0e9e714d5acc28d6540b647cab20a0491bb3.png', 'image/png', 53960, '1', '2023-02-05 21:22:15', '1', '2023-02-05 21:22:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (421, 11, 'go-view/1_index_preview.png', '52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'http://test.yudao.iocoder.cn/52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'image/png', 49273, '1', '2023-02-05 21:23:59', '1', '2023-02-05 21:23:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (422, 11, 'go-view/1_index_preview.png', '52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'http://test.yudao.iocoder.cn/52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'image/png', 49273, '1', '2023-02-05 21:24:32', '1', '2023-02-05 21:24:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (423, 11, 'go-view/1_index_preview.png', '52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'http://test.yudao.iocoder.cn/52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'image/png', 49273, '1', '2023-02-05 21:25:00', '1', '2023-02-05 21:25:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (424, 11, 'go-view/1_index_preview.png', '52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'http://test.yudao.iocoder.cn/52615d5930b9eccf342dfe4f404d88291730fe74b91161c6e6dbce88a08b257e.png', 'image/png', 49273, '1', '2023-02-05 21:25:54', '1', '2023-02-05 21:25:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (425, 11, 'go-view/2_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-05 22:57:50', '1', '2023-02-05 22:57:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (426, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 22:57:55', '1', '2023-02-05 22:57:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (427, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 22:58:21', '1', '2023-02-05 22:58:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (428, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 22:59:09', '1', '2023-02-05 22:59:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (429, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 22:59:39', '1', '2023-02-05 22:59:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (430, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:02:47', '1', '2023-02-05 23:02:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (431, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:03:19', '1', '2023-02-05 23:03:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (432, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:03:58', '1', '2023-02-05 23:03:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (433, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:14:01', '1', '2023-02-05 23:14:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (434, 11, 'go-view/2_index_background.png', '34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'http://test.yudao.iocoder.cn/34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'image/png', 26025, '1', '2023-02-05 23:14:03', '1', '2023-02-05 23:14:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (435, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:14:09', '1', '2023-02-05 23:14:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (436, 11, 'go-view/2_index_preview.png', '0a6441ec23bed2ab9a9f15a2ef27f2a23fa5a3bf71962642bb84ce7cbca1d453.png', 'http://test.yudao.iocoder.cn/0a6441ec23bed2ab9a9f15a2ef27f2a23fa5a3bf71962642bb84ce7cbca1d453.png', 'image/png', 38892, '1', '2023-02-05 23:19:27', '1', '2023-02-05 23:19:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (437, 11, 'go-view/2_index_preview.png', '0a6441ec23bed2ab9a9f15a2ef27f2a23fa5a3bf71962642bb84ce7cbca1d453.png', 'http://test.yudao.iocoder.cn/0a6441ec23bed2ab9a9f15a2ef27f2a23fa5a3bf71962642bb84ce7cbca1d453.png', 'image/png', 38892, '1', '2023-02-05 23:19:32', '1', '2023-02-05 23:19:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (438, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:19:33', '1', '2023-02-05 23:19:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (439, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:19:35', '1', '2023-02-05 23:19:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (440, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:19:50', '1', '2023-02-05 23:19:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (441, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:20:20', '1', '2023-02-05 23:20:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (442, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:20:50', '1', '2023-02-05 23:20:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (443, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:21:20', '1', '2023-02-05 23:21:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (444, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:21:50', '1', '2023-02-05 23:21:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (445, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:22:20', '1', '2023-02-05 23:22:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (446, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:22:51', '1', '2023-02-05 23:22:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (447, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:23:20', '1', '2023-02-05 23:23:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (448, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:23:50', '1', '2023-02-05 23:23:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (449, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:24:20', '1', '2023-02-05 23:24:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (450, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:24:42', '1', '2023-02-05 23:24:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (451, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:24:44', '1', '2023-02-05 23:24:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (452, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:08', '1', '2023-02-05 23:25:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (453, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:20', '1', '2023-02-05 23:25:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (454, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:21', '1', '2023-02-05 23:25:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (455, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:23', '1', '2023-02-05 23:25:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (456, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:49', '1', '2023-02-05 23:25:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (457, 11, 'go-view/2_index_background.png', '34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'http://test.yudao.iocoder.cn/34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'image/png', 26025, '1', '2023-02-05 23:25:51', '1', '2023-02-05 23:25:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (458, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:55', '1', '2023-02-05 23:25:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (459, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:58', '1', '2023-02-05 23:25:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (460, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:25:58', '1', '2023-02-05 23:25:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (461, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:26:57', '1', '2023-02-05 23:26:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (462, 11, 'go-view/2_index_preview.png', 'd5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'http://test.yudao.iocoder.cn/d5a38bfa183d0a89025a5f4d35a3ed1264dd066f840213c79b0b0f1fbc9e9cb3.png', 'image/png', 117, '1', '2023-02-05 23:27:41', '1', '2023-02-05 23:27:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (463, 11, 'go-view/2_index_preview.png', '41df21eab727b8ab043a11878f53187b05fcb061e1c6d4aeaaed8117cb4cb70e.png', 'http://test.yudao.iocoder.cn/41df21eab727b8ab043a11878f53187b05fcb061e1c6d4aeaaed8117cb4cb70e.png', 'image/png', 21802, '1', '2023-02-05 23:27:50', '1', '2023-02-05 23:27:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (464, 11, 'go-view/2_index_preview.png', 'a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'http://test.yudao.iocoder.cn/a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'image/png', 38289, '1', '2023-02-05 23:28:07', '1', '2023-02-05 23:28:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (465, 11, 'go-view/2_index_preview.png', 'a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'http://test.yudao.iocoder.cn/a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'image/png', 38289, '1', '2023-02-05 23:28:07', '1', '2023-02-05 23:28:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (466, 11, 'go-view/2_index_preview.png', 'a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'http://test.yudao.iocoder.cn/a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'image/png', 38289, '1', '2023-02-05 23:28:10', '1', '2023-02-05 23:28:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (467, 11, 'go-view/2_index_preview.png', 'a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'http://test.yudao.iocoder.cn/a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'image/png', 38289, '1', '2023-02-05 23:28:12', '1', '2023-02-05 23:28:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (468, 11, 'go-view/2_index_preview.png', 'a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'http://test.yudao.iocoder.cn/a3059a1f797bdcc9442add564e2dfc8b7b478ed2c98144c9b4a4fac5ffbae936.png', 'image/png', 38289, '1', '2023-02-05 23:28:19', '1', '2023-02-05 23:28:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (469, 11, 'go-view/2_index_preview.png', '59324f55980c8b4e50e4e0a579b159d86140f9c65ec0ade3d516e5e7c15e1ad9.png', 'http://test.yudao.iocoder.cn/59324f55980c8b4e50e4e0a579b159d86140f9c65ec0ade3d516e5e7c15e1ad9.png', 'image/png', 35334, '1', '2023-02-05 23:28:30', '1', '2023-02-05 23:28:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (470, 11, 'go-view/2_index_background.png', '34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'http://test.yudao.iocoder.cn/34c5027ddf81e4b440e125e95084f9024422a373c21e778ec56d6ac0252960fe.png', 'image/png', 26025, '1', '2023-02-05 23:28:32', '1', '2023-02-05 23:28:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (471, 11, 'go-view/2_index_preview.png', '3f85b6a5b992eafb7e7161e4f5e0c88c95645d80816f3b8f58b0b0e30e3c350f.png', 'http://test.yudao.iocoder.cn/3f85b6a5b992eafb7e7161e4f5e0c88c95645d80816f3b8f58b0b0e30e3c350f.png', 'image/png', 540122, '1', '2023-02-05 23:28:41', '1', '2023-02-05 23:28:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (472, 11, 'go-view/2_index_preview.png', '3f85b6a5b992eafb7e7161e4f5e0c88c95645d80816f3b8f58b0b0e30e3c350f.png', 'http://test.yudao.iocoder.cn/3f85b6a5b992eafb7e7161e4f5e0c88c95645d80816f3b8f58b0b0e30e3c350f.png', 'image/png', 540122, '1', '2023-02-05 23:28:46', '1', '2023-02-05 23:28:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (473, 11, 'go-view/2_index_preview.png', 'e3dd612caed73c8b0eaa69cd1e01d12eb3bf113d41ccfd8591e2564580ea3579.png', 'http://test.yudao.iocoder.cn/e3dd612caed73c8b0eaa69cd1e01d12eb3bf113d41ccfd8591e2564580ea3579.png', 'image/png', 537426, '1', '2023-02-05 23:28:54', '1', '2023-02-05 23:28:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (474, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:29:41', '1', '2023-02-05 23:29:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (475, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:30:12', '1', '2023-02-05 23:30:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (476, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:31:24', '1', '2023-02-05 23:31:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (477, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:32:00', '1', '2023-02-05 23:32:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (478, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:33:02', '1', '2023-02-05 23:33:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (479, 11, 'go-view/2_index_preview.png', 'b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'http://test.yudao.iocoder.cn/b34f4cdb0b31698d9b81d807550cf62988f1b99c38a41e13f2df7702e88e6019.png', 'image/png', 534220, '1', '2023-02-05 23:34:00', '1', '2023-02-05 23:34:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (480, 11, 'go-view/3_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 00:05:51', '1', '2023-02-07 00:05:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (481, 11, 'go-view/2_index_preview.png', 'e3dd612caed73c8b0eaa69cd1e01d12eb3bf113d41ccfd8591e2564580ea3579.png', 'http://test.yudao.iocoder.cn/e3dd612caed73c8b0eaa69cd1e01d12eb3bf113d41ccfd8591e2564580ea3579.png', 'image/png', 537426, '1', '2023-02-07 00:11:04', '1', '2023-02-07 00:11:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (482, 11, 'go-view/2_index_preview.png', '41490f5cd75f6e7723c1706fe34a13b9072c3b3462a7c99ac90615125c7819d6.png', 'http://test.yudao.iocoder.cn/41490f5cd75f6e7723c1706fe34a13b9072c3b3462a7c99ac90615125c7819d6.png', 'image/png', 62789, '1', '2023-02-07 00:11:11', '1', '2023-02-07 00:11:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (483, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:11:16', '1', '2023-02-07 00:11:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (484, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:11:18', '1', '2023-02-07 00:11:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (485, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:11:22', '1', '2023-02-07 00:11:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (486, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:11:31', '1', '2023-02-07 00:11:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (487, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:12:01', '1', '2023-02-07 00:12:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (488, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:12:31', '1', '2023-02-07 00:12:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (489, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:13:01', '1', '2023-02-07 00:13:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (490, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:13:31', '1', '2023-02-07 00:13:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (491, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:14:20', '1', '2023-02-07 00:14:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (492, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:15:12', '1', '2023-02-07 00:15:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (493, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:16:02', '1', '2023-02-07 00:16:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (494, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:16:52', '1', '2023-02-07 00:16:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (495, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:17:43', '1', '2023-02-07 00:17:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (496, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:18:44', '1', '2023-02-07 00:18:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (497, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:19:44', '1', '2023-02-07 00:19:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (498, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:20:44', '1', '2023-02-07 00:20:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (499, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:21:44', '1', '2023-02-07 00:21:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (500, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:22:44', '1', '2023-02-07 00:22:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (501, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:23:44', '1', '2023-02-07 00:23:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (502, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:24:44', '1', '2023-02-07 00:24:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (503, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:25:44', '1', '2023-02-07 00:25:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (504, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:26:44', '1', '2023-02-07 00:26:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (505, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:27:44', '1', '2023-02-07 00:27:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (506, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:28:44', '1', '2023-02-07 00:28:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (507, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:29:44', '1', '2023-02-07 00:29:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (508, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:30:44', '1', '2023-02-07 00:30:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (509, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:31:44', '1', '2023-02-07 00:31:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (510, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:32:44', '1', '2023-02-07 00:32:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (511, 11, 'go-view/2_index_preview.png', 'db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'http://test.yudao.iocoder.cn/db02929081b96a818829e167e4380824166bb8bb8660ba1eef31067083f1cb58.png', 'image/png', 58731, '1', '2023-02-07 00:33:44', '1', '2023-02-07 00:33:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (512, 11, 'go-view/4_index_preview.png', 'e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'http://test.yudao.iocoder.cn/e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'image/png', 40706, '1', '2023-02-07 00:53:27', '1', '2023-02-07 00:53:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (513, 11, 'go-view/4_index_preview.png', 'e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'http://test.yudao.iocoder.cn/e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'image/png', 40706, '1', '2023-02-07 00:53:57', '1', '2023-02-07 00:53:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (514, 11, 'go-view/4_index_preview.png', 'e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'http://test.yudao.iocoder.cn/e1461c5be0959eb17bd51d104bf0bb39aaa546704ac4661124fae45a4b194121.png', 'image/png', 40706, '1', '2023-02-07 00:54:01', '1', '2023-02-07 00:54:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (515, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:27:01', '1', '2023-02-07 08:27:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (516, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:27:29', '1', '2023-02-07 08:27:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (517, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:27:32', '1', '2023-02-07 08:27:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (518, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:27:59', '1', '2023-02-07 08:27:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (519, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:28:15', '1', '2023-02-07 08:28:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (520, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:28:29', '1', '2023-02-07 08:28:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (521, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:28:32', '1', '2023-02-07 08:28:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (522, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:28:59', '1', '2023-02-07 08:28:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (523, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:29:09', '1', '2023-02-07 08:29:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (524, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:29:14', '1', '2023-02-07 08:29:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (525, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:29:30', '1', '2023-02-07 08:29:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (526, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:27', '1', '2023-02-07 08:30:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (527, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:30', '1', '2023-02-07 08:30:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (528, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:35', '1', '2023-02-07 08:30:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (529, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:39', '1', '2023-02-07 08:30:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (530, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:47', '1', '2023-02-07 08:30:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (531, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:30:59', '1', '2023-02-07 08:30:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (532, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:31:07', '1', '2023-02-07 08:31:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (533, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:31:11', '1', '2023-02-07 08:31:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (534, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:35:16', '1', '2023-02-07 08:35:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (535, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:35:16', '1', '2023-02-07 08:35:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (536, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:35:24', '1', '2023-02-07 08:35:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (537, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:22', '1', '2023-02-07 08:36:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (538, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:24', '1', '2023-02-07 08:36:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (539, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:30', '1', '2023-02-07 08:36:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (540, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:41', '1', '2023-02-07 08:36:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (541, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:47', '1', '2023-02-07 08:36:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (542, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:53', '1', '2023-02-07 08:36:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (543, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:36:59', '1', '2023-02-07 08:36:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (544, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:37:16', '1', '2023-02-07 08:37:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (545, 11, 'go-view/4_index_preview.png', 'b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'http://test.yudao.iocoder.cn/b98ebd03cce7c671ac95ff0dcbb6a022bcd4ae871affdcc630747c5bd527c698.png', 'image/png', 58365, '1', '2023-02-07 08:37:19', '1', '2023-02-07 08:37:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (546, 11, 'go-view/4_index_preview.png', 'c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'http://test.yudao.iocoder.cn/c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'image/png', 37234, '1', '2023-02-07 08:37:40', '1', '2023-02-07 08:37:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (547, 11, 'go-view/4_index_preview.png', 'c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'http://test.yudao.iocoder.cn/c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'image/png', 37234, '1', '2023-02-07 08:38:39', '1', '2023-02-07 08:38:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (548, 11, 'go-view/4_index_preview.png', 'c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'http://test.yudao.iocoder.cn/c1a76711da3e1639946c4d36d0b6be5803dabddcfc31438a13026780b01f9ce6.png', 'image/png', 37234, '1', '2023-02-07 08:38:40', '1', '2023-02-07 08:38:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (549, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:39:09', '1', '2023-02-07 08:39:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (550, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:39:22', '1', '2023-02-07 08:39:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (551, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:39:38', '1', '2023-02-07 08:39:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (552, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:39:47', '1', '2023-02-07 08:39:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (553, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:40:00', '1', '2023-02-07 08:40:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (554, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:40:08', '1', '2023-02-07 08:40:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (555, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:40:38', '1', '2023-02-07 08:40:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (556, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:41:09', '1', '2023-02-07 08:41:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (557, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:41:38', '1', '2023-02-07 08:41:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (558, 11, 'go-view/4_index_preview.png', '53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'http://test.yudao.iocoder.cn/53a9632f63ba963d88cc003661576f589c45f17d8ff53ce379ff050797cc83d2.png', 'image/png', 133347, '1', '2023-02-07 08:41:57', '1', '2023-02-07 08:41:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (559, 11, 'go-view/4_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-07 08:42:08', '1', '2023-02-07 08:42:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (560, 11, 'go-view/403_index_preview.png', 'd69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'http://test.yudao.iocoder.cn/d69df2e322a45c8fc8200578d09d72450b6c1ef761999ff64104b044f02ec2e8.png', 'image/png', 323, '1', '2023-02-07 08:42:13', '1', '2023-02-07 08:42:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (561, 11, 'go-view/2_index_preview.png', '15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'http://test.yudao.iocoder.cn/15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'image/png', 62766, '1', '2023-02-07 08:45:44', '1', '2023-02-07 08:45:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (562, 11, 'go-view/2_index_preview.png', '15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'http://test.yudao.iocoder.cn/15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'image/png', 62766, '1', '2023-02-07 08:45:57', '1', '2023-02-07 08:45:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (563, 11, 'go-view/2_index_preview.png', '15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'http://test.yudao.iocoder.cn/15acab04425da869a8e087e3d7cf92d9e039c619cc7bf235a6276b6af92e37f8.png', 'image/png', 62766, '1', '2023-02-07 08:46:02', '1', '2023-02-07 08:46:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (564, 11, 'go-view/2_index_preview.png', 'fbcf6de1a4a09a279f1e4b7809f9b4897b44b13c74cdaf5db613ca32dd17eb67.png', 'http://test.yudao.iocoder.cn/fbcf6de1a4a09a279f1e4b7809f9b4897b44b13c74cdaf5db613ca32dd17eb67.png', 'image/png', 52188, '1', '2023-02-07 08:46:27', '1', '2023-02-07 08:46:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (565, 11, 'go-view/403_index_preview.png', '43392ea67807cccd275aa8dda1eed58bee7bc553af5e090b92527aa9920a5a7c.png', 'http://test.yudao.iocoder.cn/43392ea67807cccd275aa8dda1eed58bee7bc553af5e090b92527aa9920a5a7c.png', 'image/png', 9778, '1', '2023-02-07 08:46:45', '1', '2023-02-07 08:46:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (566, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:50:07', '1', '2023-02-07 08:50:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (567, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:50:26', '1', '2023-02-07 08:50:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (568, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:51:27', '1', '2023-02-07 08:51:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (569, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:51:56', '1', '2023-02-07 08:51:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (570, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:52:26', '1', '2023-02-07 08:52:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (571, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:52:56', '1', '2023-02-07 08:52:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (572, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:53:27', '1', '2023-02-07 08:53:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (573, 11, 'go-view/2_index_preview.png', '269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'http://test.yudao.iocoder.cn/269a9a58928114b2dfda81f38218622248d291e9e9fea49d617c4717acae5bf5.png', 'image/png', 40384, '1', '2023-02-07 08:54:57', '1', '2023-02-07 08:54:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (574, 11, 'go-view/2_index_preview.png', '12da8a91b69786da19aa5e92f543ca5541b88f3743c1fc82c5b11bdf02372edb.png', 'http://test.yudao.iocoder.cn/12da8a91b69786da19aa5e92f543ca5541b88f3743c1fc82c5b11bdf02372edb.png', 'image/png', 40375, '1', '2023-02-07 08:57:01', '1', '2023-02-07 08:57:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (575, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:22', '1', '2023-02-07 08:57:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (576, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:27', '1', '2023-02-07 08:57:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (577, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:27', '1', '2023-02-07 08:57:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (578, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:35', '1', '2023-02-07 08:57:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (579, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:42', '1', '2023-02-07 08:57:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (580, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:50', '1', '2023-02-07 08:57:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (581, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:55', '1', '2023-02-07 08:57:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (582, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:57', '1', '2023-02-07 08:57:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (583, 11, 'go-view/2_index_preview.png', '232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'http://test.yudao.iocoder.cn/232e6cf3d4cef6779f3322685d104b949af98088594bfa7250be58d9fff51008.png', 'image/png', 10071, '1', '2023-02-07 08:57:59', '1', '2023-02-07 08:57:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (584, 11, 'go-view/2_index_preview.png', '011302f10162cf1f392fcf9dea4e6d19431a6a3b92b5c51d011c88fd182cfa31.png', 'http://test.yudao.iocoder.cn/011302f10162cf1f392fcf9dea4e6d19431a6a3b92b5c51d011c88fd182cfa31.png', 'image/png', 10038, '1', '2023-02-07 08:58:02', '1', '2023-02-07 08:58:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (585, 11, 'go-view/2_index_preview.png', '41ad23175b708eabba7767c1580cdb3c63340129c647aa34076af95032e49996.png', 'http://test.yudao.iocoder.cn/41ad23175b708eabba7767c1580cdb3c63340129c647aa34076af95032e49996.png', 'image/png', 27623, '1', '2023-02-07 08:58:40', '1', '2023-02-07 08:58:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (586, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 08:58:51', '1', '2023-02-07 08:58:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (587, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 08:59:11', '1', '2023-02-07 08:59:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (588, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 08:59:19', '1', '2023-02-07 08:59:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (589, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 08:59:25', '1', '2023-02-07 08:59:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (590, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 08:59:35', '1', '2023-02-07 08:59:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (591, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 08:59:42', '1', '2023-02-07 08:59:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (592, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 08:59:54', '1', '2023-02-07 08:59:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (593, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 08:59:57', '1', '2023-02-07 08:59:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (594, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:00:14', '1', '2023-02-07 09:00:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (595, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:00:20', '1', '2023-02-07 09:00:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (596, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:00:25', '1', '2023-02-07 09:00:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (597, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:02:06', '1', '2023-02-07 09:02:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (598, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:02:06', '1', '2023-02-07 09:02:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (599, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:02:14', '1', '2023-02-07 09:02:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (600, 11, 'go-view/4_index_preview.png', 'f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'http://test.yudao.iocoder.cn/f0c49d0b6ac9be5033c8b83bf6ef063e765200cbc33e7103b9303bdb723f51af.png', 'image/png', 73617, '1', '2023-02-07 09:02:24', '1', '2023-02-07 09:02:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (601, 11, 'go-view/2_index_preview.png', '61c7408f182748955ec670fb180ae05cbb701abe5b6cebba7c0512e194ed3b28.png', 'http://test.yudao.iocoder.cn/61c7408f182748955ec670fb180ae05cbb701abe5b6cebba7c0512e194ed3b28.png', 'image/png', 28715, '1', '2023-02-07 09:02:47', '1', '2023-02-07 09:02:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (602, 11, 'go-view/2_index_preview.png', '61c7408f182748955ec670fb180ae05cbb701abe5b6cebba7c0512e194ed3b28.png', 'http://test.yudao.iocoder.cn/61c7408f182748955ec670fb180ae05cbb701abe5b6cebba7c0512e194ed3b28.png', 'image/png', 28715, '1', '2023-02-07 09:02:49', '1', '2023-02-07 09:02:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (603, 11, 'go-view/2_index_preview.png', '50b04064b3926c7462543d7cc61a4e94a73f13ec0b39f690993d2b5ae4d6ba00.png', 'http://test.yudao.iocoder.cn/50b04064b3926c7462543d7cc61a4e94a73f13ec0b39f690993d2b5ae4d6ba00.png', 'image/png', 23726, '1', '2023-02-07 09:03:03', '1', '2023-02-07 09:03:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (604, 11, 'go-view/2_index_preview.png', '50b04064b3926c7462543d7cc61a4e94a73f13ec0b39f690993d2b5ae4d6ba00.png', 'http://test.yudao.iocoder.cn/50b04064b3926c7462543d7cc61a4e94a73f13ec0b39f690993d2b5ae4d6ba00.png', 'image/png', 23726, '1', '2023-02-07 09:03:13', '1', '2023-02-07 09:03:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (605, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:03:17', '1', '2023-02-07 09:03:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (606, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:24', '1', '2023-02-07 09:03:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (607, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:26', '1', '2023-02-07 09:03:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (608, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:31', '1', '2023-02-07 09:03:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (609, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:36', '1', '2023-02-07 09:03:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (610, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:43', '1', '2023-02-07 09:03:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (611, 11, 'go-view/2_index_preview.png', '1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'http://test.yudao.iocoder.cn/1cfebe3fa5856f64d8089d9665fb232b81662a26cccd7ee468b62234a478d2ef.png', 'image/png', 41075, '1', '2023-02-07 09:03:52', '1', '2023-02-07 09:03:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (612, 11, 'go-view/2_index_preview.png', 'f556db239d91621d89fc51373db9a40530b1a37f727cf0b4a6536835dac73241.png', 'http://test.yudao.iocoder.cn/f556db239d91621d89fc51373db9a40530b1a37f727cf0b4a6536835dac73241.png', 'image/png', 55203, '1', '2023-02-07 09:04:13', '1', '2023-02-07 09:04:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (613, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:04:32', '1', '2023-02-07 09:04:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (614, 11, 'go-view/2_index_preview.png', '2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'http://test.yudao.iocoder.cn/2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'image/png', 292136, '1', '2023-02-07 09:04:43', '1', '2023-02-07 09:04:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (615, 11, 'go-view/2_index_preview.png', '2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'http://test.yudao.iocoder.cn/2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'image/png', 292136, '1', '2023-02-07 09:04:45', '1', '2023-02-07 09:04:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (616, 11, 'go-view/2_index_preview.png', '2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'http://test.yudao.iocoder.cn/2570463345d20b55a93ce8605e9e98efd3d8bf8e3b429d665d588b2ef9ec636a.png', 'image/png', 292136, '1', '2023-02-07 09:05:00', '1', '2023-02-07 09:05:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (617, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:05:13', '1', '2023-02-07 09:05:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (618, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:05:14', '1', '2023-02-07 09:05:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (619, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:05:43', '1', '2023-02-07 09:05:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (620, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:05:46', '1', '2023-02-07 09:05:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (621, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:06:13', '1', '2023-02-07 09:06:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (622, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:06:43', '1', '2023-02-07 09:06:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (623, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:06:45', '1', '2023-02-07 09:06:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (624, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:07:05', '1', '2023-02-07 09:07:05', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (625, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:07:13', '1', '2023-02-07 09:07:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (626, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:07:43', '1', '2023-02-07 09:07:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (627, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:07:49', '1', '2023-02-07 09:07:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (628, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:07:55', '1', '2023-02-07 09:07:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (629, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:08:13', '1', '2023-02-07 09:08:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (630, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:08:43', '1', '2023-02-07 09:08:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (631, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:08:56', '1', '2023-02-07 09:08:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (632, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:09:13', '1', '2023-02-07 09:09:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (633, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:09:43', '1', '2023-02-07 09:09:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (634, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:09:56', '1', '2023-02-07 09:09:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (635, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:10:13', '1', '2023-02-07 09:10:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (636, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:10:43', '1', '2023-02-07 09:10:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (637, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:11:06', '1', '2023-02-07 09:11:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (638, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:11:13', '1', '2023-02-07 09:11:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (639, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:11:43', '1', '2023-02-07 09:11:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (640, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:12:03', '1', '2023-02-07 09:12:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (641, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:12:13', '1', '2023-02-07 09:12:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (642, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:12:43', '1', '2023-02-07 09:12:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (643, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:12:58', '1', '2023-02-07 09:12:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (644, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:13:13', '1', '2023-02-07 09:13:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (645, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:13:43', '1', '2023-02-07 09:13:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (646, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:13:56', '1', '2023-02-07 09:13:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (647, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:14:13', '1', '2023-02-07 09:14:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (648, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:14:43', '1', '2023-02-07 09:14:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (649, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:14:52', '1', '2023-02-07 09:14:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (650, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:15:13', '1', '2023-02-07 09:15:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (651, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:15:43', '1', '2023-02-07 09:15:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (652, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:15:48', '1', '2023-02-07 09:15:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (653, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:16:13', '1', '2023-02-07 09:16:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (654, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:16:43', '1', '2023-02-07 09:16:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (655, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:17:06', '1', '2023-02-07 09:17:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (656, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:17:13', '1', '2023-02-07 09:17:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (657, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:17:43', '1', '2023-02-07 09:17:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (658, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:18:10', '1', '2023-02-07 09:18:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (659, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:18:13', '1', '2023-02-07 09:18:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (660, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:18:43', '1', '2023-02-07 09:18:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (661, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:19:14', '1', '2023-02-07 09:19:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (662, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:19:22', '1', '2023-02-07 09:19:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (663, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:19:44', '1', '2023-02-07 09:19:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (664, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:20:13', '1', '2023-02-07 09:20:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (665, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:20:34', '1', '2023-02-07 09:20:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (666, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:20:41', '1', '2023-02-07 09:20:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (667, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:20:44', '1', '2023-02-07 09:20:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (668, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:21:14', '1', '2023-02-07 09:21:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (669, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:21:32', '1', '2023-02-07 09:21:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (670, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:21:44', '1', '2023-02-07 09:21:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (671, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:22:02', '1', '2023-02-07 09:22:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (672, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:22:14', '1', '2023-02-07 09:22:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (673, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:22:43', '1', '2023-02-07 09:22:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (674, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:23:14', '1', '2023-02-07 09:23:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (675, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:23:15', '1', '2023-02-07 09:23:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (676, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:23:44', '1', '2023-02-07 09:23:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (677, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:24:13', '1', '2023-02-07 09:24:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (678, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:24:25', '1', '2023-02-07 09:24:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (679, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:24:43', '1', '2023-02-07 09:24:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (680, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:25:13', '1', '2023-02-07 09:25:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (681, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:25:24', '1', '2023-02-07 09:25:24', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (682, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:25:43', '1', '2023-02-07 09:25:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (683, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:26:13', '1', '2023-02-07 09:26:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (684, 11, 'go-view/2_index_preview.png', '98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'http://test.yudao.iocoder.cn/98c27cad5f092bda05f4e0a6e8f738dc9ae3f22665aa40b2b34bf2d040ca2f10.png', 'image/png', 28715, '1', '2023-02-07 09:26:25', '1', '2023-02-07 09:26:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (685, 11, 'go-view/2_index_preview.png', '048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'http://test.yudao.iocoder.cn/048e37b54e1986f0fbf70cdcd53434b3bce94c3e2a5b482d9831564c6610f10a.png', 'image/png', 247601, '1', '2023-02-07 09:26:43', '1', '2023-02-07 09:26:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (686, 11, 'go-view/2_index_preview.png', '7c2f7e741bd2d44441571681488699239ab9e297a84b27df00b85a7b8dc636d9.png', 'http://test.yudao.iocoder.cn/7c2f7e741bd2d44441571681488699239ab9e297a84b27df00b85a7b8dc636d9.png', 'image/png', 40139, '1', '2023-02-07 09:58:00', '1', '2023-02-07 09:58:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (687, 11, 'go-view/2_index_preview.png', '5825302b2efb65b14fcb98afdc2819de65c10100d9ec950d9691616f6050a382.png', 'http://test.yudao.iocoder.cn/5825302b2efb65b14fcb98afdc2819de65c10100d9ec950d9691616f6050a382.png', 'image/png', 19342, '1', '2023-02-07 09:58:56', '1', '2023-02-07 09:58:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (688, 11, 'go-view/2_index_preview.png', '237e51944a579bf68d1006f2faa3e136555c2cd4181fdb53bd81c6115b3e3a04.png', 'http://test.yudao.iocoder.cn/237e51944a579bf68d1006f2faa3e136555c2cd4181fdb53bd81c6115b3e3a04.png', 'image/png', 18738, '1', '2023-02-07 09:58:56', '1', '2023-02-07 09:58:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (689, 11, 'go-view/2_index_preview.png', '237e51944a579bf68d1006f2faa3e136555c2cd4181fdb53bd81c6115b3e3a04.png', 'http://test.yudao.iocoder.cn/237e51944a579bf68d1006f2faa3e136555c2cd4181fdb53bd81c6115b3e3a04.png', 'image/png', 18738, '1', '2023-02-07 09:58:56', '1', '2023-02-07 09:58:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (690, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 09:58:59', '1', '2023-02-07 09:58:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (691, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 09:59:29', '1', '2023-02-07 09:59:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (692, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:05:11', '1', '2023-02-07 10:05:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (693, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:05:19', '1', '2023-02-07 10:05:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (694, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:06:22', '1', '2023-02-07 10:06:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (695, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:06:52', '1', '2023-02-07 10:06:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (696, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:07:22', '1', '2023-02-07 10:07:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (697, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:07:52', '1', '2023-02-07 10:07:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (698, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:08:22', '1', '2023-02-07 10:08:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (699, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:08:52', '1', '2023-02-07 10:08:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (700, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:09:22', '1', '2023-02-07 10:09:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (701, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:10:14', '1', '2023-02-07 10:10:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (702, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:10:44', '1', '2023-02-07 10:10:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (703, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:11:14', '1', '2023-02-07 10:11:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (704, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:11:44', '1', '2023-02-07 10:11:44', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (705, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:12:27', '1', '2023-02-07 10:12:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (706, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:13:21', '1', '2023-02-07 10:13:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (707, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:13:51', '1', '2023-02-07 10:13:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (708, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:14:21', '1', '2023-02-07 10:14:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (709, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:14:59', '1', '2023-02-07 10:14:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (710, 11, 'go-view/2_index_preview.png', '5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'http://test.yudao.iocoder.cn/5cc043b06acb35742be27686a76c155048fc671ce53e31071b1725ff4d083811.png', 'image/png', 2632, '1', '2023-02-07 10:15:54', '1', '2023-02-07 10:15:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (711, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:16:51', '1', '2023-02-07 10:16:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (712, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:17:46', '1', '2023-02-07 10:17:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (713, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:08', '1', '2023-02-07 10:18:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (714, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:15', '1', '2023-02-07 10:18:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (715, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:23', '1', '2023-02-07 10:18:23', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (716, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:42', '1', '2023-02-07 10:18:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (717, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:46', '1', '2023-02-07 10:18:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (718, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:46', '1', '2023-02-07 10:18:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (719, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:18:50', '1', '2023-02-07 10:18:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (720, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:19:00', '1', '2023-02-07 10:19:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (721, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:19:12', '1', '2023-02-07 10:19:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (722, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:19:15', '1', '2023-02-07 10:19:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (723, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:19:45', '1', '2023-02-07 10:19:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (724, 11, 'go-view/2_index_preview.png', 'a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'http://test.yudao.iocoder.cn/a88bb7914d64524da023ac1497e9edfe3f3995d814476b9a86d08f20ffedc110.png', 'image/png', 3182, '1', '2023-02-07 10:20:15', '1', '2023-02-07 10:20:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (725, 11, 'go-view/2_index_preview.png', '39024e45f9d42581ba6a54bc3fceaf3fada0f4adcb844356f3b16a17298451d6.png', 'http://test.yudao.iocoder.cn/39024e45f9d42581ba6a54bc3fceaf3fada0f4adcb844356f3b16a17298451d6.png', 'image/png', 52451, '1', '2023-02-07 10:46:37', '1', '2023-02-07 10:46:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (726, 11, 'go-view/2_index_preview.png', '7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'http://test.yudao.iocoder.cn/7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'image/png', 11015, '1', '2023-02-07 10:46:49', '1', '2023-02-07 10:46:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (727, 11, 'go-view/2_index_preview.png', '7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'http://test.yudao.iocoder.cn/7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'image/png', 11015, '1', '2023-02-07 10:47:00', '1', '2023-02-07 10:47:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (728, 11, 'go-view/2_index_preview.png', '7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'http://test.yudao.iocoder.cn/7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'image/png', 11015, '1', '2023-02-07 10:47:02', '1', '2023-02-07 10:47:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (729, 11, 'go-view/2_index_preview.png', '7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'http://test.yudao.iocoder.cn/7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'image/png', 11015, '1', '2023-02-07 10:47:13', '1', '2023-02-07 10:47:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (730, 11, 'go-view/2_index_preview.png', '7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'http://test.yudao.iocoder.cn/7562798c0a798fc36c2889cc05467661fd06d5af872c08829debe603da834250.png', 'image/png', 11015, '1', '2023-02-07 10:47:16', '1', '2023-02-07 10:47:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (731, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:47:33', '1', '2023-02-07 10:47:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (732, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:47:33', '1', '2023-02-07 10:47:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (733, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:47:53', '1', '2023-02-07 10:47:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (734, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:48:03', '1', '2023-02-07 10:48:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (735, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:48:33', '1', '2023-02-07 10:48:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (736, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:49:03', '1', '2023-02-07 10:49:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (737, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:49:32', '1', '2023-02-07 10:49:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (738, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:50:08', '1', '2023-02-07 10:50:08', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (739, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:50:32', '1', '2023-02-07 10:50:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (740, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:51:02', '1', '2023-02-07 10:51:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (741, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:51:32', '1', '2023-02-07 10:51:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (742, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:52:02', '1', '2023-02-07 10:52:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (743, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:54:22', '1', '2023-02-07 10:54:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (744, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:54:55', '1', '2023-02-07 10:54:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (745, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:54:57', '1', '2023-02-07 10:54:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (746, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:55:02', '1', '2023-02-07 10:55:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (747, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:55:32', '1', '2023-02-07 10:55:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (748, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:56:02', '1', '2023-02-07 10:56:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (749, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:56:32', '1', '2023-02-07 10:56:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (750, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:59:25', '1', '2023-02-07 10:59:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (751, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 10:59:39', '1', '2023-02-07 10:59:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (752, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 11:00:02', '1', '2023-02-07 11:00:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (753, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 11:05:33', '1', '2023-02-07 11:05:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (754, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 11:06:02', '1', '2023-02-07 11:06:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (755, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 11:06:32', '1', '2023-02-07 11:06:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (756, 11, 'go-view/2_index_preview.png', 'd0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'http://test.yudao.iocoder.cn/d0ab792b80fafba516ba4bbdce85dba1bc13abf701f6070aaed3e44d7b2d272a.png', 'image/png', 11014, '1', '2023-02-07 11:07:02', '1', '2023-02-07 11:07:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (757, 11, 'go-view/2_index_preview.png', '22398d0841c71b29065edbeeb5104ec0c736556bd49bee26882dace1471ba639.png', 'http://test.yudao.iocoder.cn/22398d0841c71b29065edbeeb5104ec0c736556bd49bee26882dace1471ba639.png', 'image/png', 13250, '1', '2023-02-07 11:07:32', '1', '2023-02-07 11:07:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (758, 11, 'go-view/5_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:07:50', '1', '2023-02-07 11:07:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (759, 11, 'go-view/5_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:07:53', '1', '2023-02-07 11:07:53', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (760, 11, 'go-view/5_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:07:58', '1', '2023-02-07 11:07:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (761, 11, 'go-view/5_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:08:02', '1', '2023-02-07 11:08:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (762, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:08:12', '1', '2023-02-07 11:08:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (763, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:08:42', '1', '2023-02-07 11:08:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (764, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:08:56', '1', '2023-02-07 11:08:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (765, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:09:09', '1', '2023-02-07 11:09:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (766, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:09:12', '1', '2023-02-07 11:09:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (767, 11, 'go-view/5_index_preview.png', 'a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'http://test.yudao.iocoder.cn/a8ce92fe281bcf1818711eef2927693664badb7a93c575cdf09e14d9f47534eb.png', 'image/png', 41858, '1', '2023-02-07 11:09:25', '1', '2023-02-07 11:09:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (768, 11, 'go-view/5_index_preview.png', '5e7409220a99f6c1fea1f2cca834f0f233a45cb91e6725216f6a818d73b4b056.png', 'http://test.yudao.iocoder.cn/5e7409220a99f6c1fea1f2cca834f0f233a45cb91e6725216f6a818d73b4b056.png', 'image/png', 556692, '1', '2023-02-07 11:09:43', '1', '2023-02-07 11:09:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (769, 11, 'go-view/5_index_preview.png', '57f5af4a7a1310589f668e6f555e30f6a3d864e44ddefe8a48f0ba6e2d065488.png', 'http://test.yudao.iocoder.cn/57f5af4a7a1310589f668e6f555e30f6a3d864e44ddefe8a48f0ba6e2d065488.png', 'image/png', 623555, '1', '2023-02-07 11:10:12', '1', '2023-02-07 11:10:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (770, 11, 'go-view/5_index_preview.png', 'ac9df7da0120c05f5bf9d5db31033f1066831fdcadbea357a786316c13a2aa0a.png', 'http://test.yudao.iocoder.cn/ac9df7da0120c05f5bf9d5db31033f1066831fdcadbea357a786316c13a2aa0a.png', 'image/png', 626923, '1', '2023-02-07 11:10:42', '1', '2023-02-07 11:10:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (771, 11, 'go-view/5_index_preview.png', 'e5cdc1b2a4ac780bdbf9c663c8a16b788ea2311071c07691f3c37d8d1f03a13d.png', 'http://test.yudao.iocoder.cn/e5cdc1b2a4ac780bdbf9c663c8a16b788ea2311071c07691f3c37d8d1f03a13d.png', 'image/png', 636997, '1', '2023-02-07 11:11:12', '1', '2023-02-07 11:11:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (772, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:11:35', '1', '2023-02-07 11:11:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (773, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:11:43', '1', '2023-02-07 11:11:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (774, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:12:13', '1', '2023-02-07 11:12:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (775, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:13:15', '1', '2023-02-07 11:13:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (776, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:13:43', '1', '2023-02-07 11:13:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (777, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:14:13', '1', '2023-02-07 11:14:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (778, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:14:43', '1', '2023-02-07 11:14:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (779, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:15:13', '1', '2023-02-07 11:15:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (780, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:15:43', '1', '2023-02-07 11:15:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (781, 11, 'go-view/5_index_preview.png', '9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'http://test.yudao.iocoder.cn/9226720820ad61f742d25961c70f81e7663fd84bdca6eb4fefe8df5caed3b6a7.png', 'image/png', 640200, '1', '2023-02-07 11:16:13', '1', '2023-02-07 11:16:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (782, 11, 'go-view/5_index_preview.png', 'a3510cc74847af0f83cd2e88415379e4bacedc0d8ab933d63c1017964e2a516d.png', 'http://test.yudao.iocoder.cn/a3510cc74847af0f83cd2e88415379e4bacedc0d8ab933d63c1017964e2a516d.png', 'image/png', 654896, '1', '2023-02-07 11:16:55', '1', '2023-02-07 11:16:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (783, 11, 'go-view/5_index_preview.png', 'a3510cc74847af0f83cd2e88415379e4bacedc0d8ab933d63c1017964e2a516d.png', 'http://test.yudao.iocoder.cn/a3510cc74847af0f83cd2e88415379e4bacedc0d8ab933d63c1017964e2a516d.png', 'image/png', 654896, '1', '2023-02-07 11:17:09', '1', '2023-02-07 11:17:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (784, 11, 'go-view/5_index_preview.png', 'da53c2c16f829c6ed7ecb23ce46e673eaa2aeab9c12e785b5c81c8d617f37002.png', 'http://test.yudao.iocoder.cn/da53c2c16f829c6ed7ecb23ce46e673eaa2aeab9c12e785b5c81c8d617f37002.png', 'image/png', 654899, '1', '2023-02-07 11:17:12', '1', '2023-02-07 11:17:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (785, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:17:42', '1', '2023-02-07 11:17:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (786, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:17:57', '1', '2023-02-07 11:17:57', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (787, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:18:00', '1', '2023-02-07 11:18:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (788, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:18:21', '1', '2023-02-07 11:18:21', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (789, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:33:14', '1', '2023-02-07 11:33:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (790, 11, 'go-view/5_index_preview.png', '6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'http://test.yudao.iocoder.cn/6382b80a9839eb1547ab8c23f049ab2cfa19626e858f18b7e01f0d97b3f0055f.png', 'image/png', 654572, '1', '2023-02-07 11:33:27', '1', '2023-02-07 11:33:27', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (791, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:33:32', '1', '2023-02-07 11:33:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (792, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:33:42', '1', '2023-02-07 11:33:42', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (793, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:33:43', '1', '2023-02-07 11:33:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (794, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:33:47', '1', '2023-02-07 11:33:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (795, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:33:48', '1', '2023-02-07 11:33:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (796, 11, 'go-view/5_index_preview.png', '6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'http://test.yudao.iocoder.cn/6aed3aa76464ac6321dd70e8a7093d6a51f5e877ad9a903aa0c9047d21720c37.png', 'image/png', 654591, '1', '2023-02-07 11:34:00', '1', '2023-02-07 11:34:00', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (797, 11, 'go-view/5_index_preview.png', 'c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'http://test.yudao.iocoder.cn/c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'image/png', 24184, '1', '2023-02-07 11:34:04', '1', '2023-02-07 11:34:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (798, 11, 'go-view/5_index_preview.png', 'c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'http://test.yudao.iocoder.cn/c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'image/png', 24184, '1', '2023-02-07 11:34:11', '1', '2023-02-07 11:34:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (799, 11, 'go-view/5_index_preview.png', 'c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'http://test.yudao.iocoder.cn/c927e547eb73a2734810c03c790f444bd9b399f9fb001b2efd59ddd7a77b7439.png', 'image/png', 24184, '1', '2023-02-07 11:34:14', '1', '2023-02-07 11:34:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (800, 11, 'go-view/5_index_preview.png', '3644c92918ce47ebdb79572fe3c90b109b6d6b3e5a6655bfd4e0470b4f10ee89.png', 'http://test.yudao.iocoder.cn/3644c92918ce47ebdb79572fe3c90b109b6d6b3e5a6655bfd4e0470b4f10ee89.png', 'image/png', 18946, '1', '2023-02-07 11:34:18', '1', '2023-02-07 11:34:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (801, 11, 'go-view/5_index_preview.png', '72fad47af8640c23945c9e2b1622734d519b586f8276dc6d7c505ffad925fc0e.png', 'http://test.yudao.iocoder.cn/72fad47af8640c23945c9e2b1622734d519b586f8276dc6d7c505ffad925fc0e.png', 'image/png', 376256, '1', '2023-02-07 11:34:25', '1', '2023-02-07 11:34:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (802, 11, 'go-view/6_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:38:33', '1', '2023-02-07 11:38:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (803, 11, 'go-view/6_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:38:35', '1', '2023-02-07 11:38:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (804, 11, 'go-view/6_index_preview.png', '67a03abfc517fcfcd5b5bf5c786689b4cf0539182ff4f25a14d64306ba991244.png', 'http://test.yudao.iocoder.cn/67a03abfc517fcfcd5b5bf5c786689b4cf0539182ff4f25a14d64306ba991244.png', 'image/png', 71976, '1', '2023-02-07 11:38:49', '1', '2023-02-07 11:38:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (805, 11, 'go-view/6_index_preview.png', '67a03abfc517fcfcd5b5bf5c786689b4cf0539182ff4f25a14d64306ba991244.png', 'http://test.yudao.iocoder.cn/67a03abfc517fcfcd5b5bf5c786689b4cf0539182ff4f25a14d64306ba991244.png', 'image/png', 71976, '1', '2023-02-07 11:38:55', '1', '2023-02-07 11:38:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (806, 11, 'go-view/6_index_preview.png', 'd68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'http://test.yudao.iocoder.cn/d68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'image/png', 70076, '1', '2023-02-07 11:39:25', '1', '2023-02-07 11:39:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (807, 11, 'go-view/6_index_preview.png', 'd68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'http://test.yudao.iocoder.cn/d68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'image/png', 70076, '1', '2023-02-07 11:39:35', '1', '2023-02-07 11:39:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (808, 11, 'go-view/6_index_preview.png', 'd68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'http://test.yudao.iocoder.cn/d68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'image/png', 70076, '1', '2023-02-07 11:39:47', '1', '2023-02-07 11:39:47', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (809, 11, 'go-view/6_index_preview.png', 'd68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'http://test.yudao.iocoder.cn/d68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'image/png', 70076, '1', '2023-02-07 11:39:55', '1', '2023-02-07 11:39:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (810, 11, 'go-view/6_index_preview.png', 'd68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'http://test.yudao.iocoder.cn/d68bf2daaa9cece47119c87565fbf05d69fcf9ba21537d68e215d80f51b81b10.png', 'image/png', 70076, '1', '2023-02-07 11:40:02', '1', '2023-02-07 11:40:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (811, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:40:04', '1', '2023-02-07 11:40:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (812, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:40:06', '1', '2023-02-07 11:40:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (813, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:40:25', '1', '2023-02-07 11:40:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (814, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:40:56', '1', '2023-02-07 11:40:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (815, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:42:26', '1', '2023-02-07 11:42:26', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (816, 11, 'go-view/6_index_preview.png', '5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'http://test.yudao.iocoder.cn/5b3f0b8f70f386bdb06e33608dcc4ff99e5eaaab6eece2f6974ecfd8ad33cac3.png', 'image/png', 14540, '1', '2023-02-07 11:42:55', '1', '2023-02-07 11:42:55', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (817, 11, 'go-view/6_index_preview.png', '4f5bed62bec4b8af67d775a1e2d0ae37198d096b3a8eaa9f549e5b6efd47dc9e.png', 'http://test.yudao.iocoder.cn/4f5bed62bec4b8af67d775a1e2d0ae37198d096b3a8eaa9f549e5b6efd47dc9e.png', 'image/png', 21231, '1', '2023-02-07 11:43:04', '1', '2023-02-07 11:43:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (818, 11, 'go-view/6_index_preview.png', '81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'http://test.yudao.iocoder.cn/81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'image/png', 104541, '1', '2023-02-07 11:43:15', '1', '2023-02-07 11:43:15', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (819, 11, 'go-view/6_index_preview.png', '81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'http://test.yudao.iocoder.cn/81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'image/png', 104541, '1', '2023-02-07 11:43:40', '1', '2023-02-07 11:43:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (820, 11, 'go-view/6_index_preview.png', '81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'http://test.yudao.iocoder.cn/81b709118dd3070de03389708059e4d4c99fddea3bda0e24f2a5ab4fee30a05c.png', 'image/png', 104541, '1', '2023-02-07 11:43:46', '1', '2023-02-07 11:43:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (821, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:44:06', '1', '2023-02-07 11:44:06', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (822, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:44:09', '1', '2023-02-07 11:44:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (823, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:44:29', '1', '2023-02-07 11:44:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (824, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:44:31', '1', '2023-02-07 11:44:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (825, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:44:59', '1', '2023-02-07 11:44:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (826, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:45:30', '1', '2023-02-07 11:45:30', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (827, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:45:59', '1', '2023-02-07 11:45:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (828, 11, 'go-view/7_index_preview.png', '686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'http://test.yudao.iocoder.cn/686fefc35da50c6b0c2e5a57bf748e62e692a12c4d98f2c6231224c70dd8cf9a.png', 'image/png', 21802, '1', '2023-02-07 11:46:29', '1', '2023-02-07 11:46:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (829, 11, 'go-view/7_index_preview.png', '0921b34a7b151db53a7adc0b203af083fcbcc380aae13a7e21365bface1bc8b8.png', 'http://test.yudao.iocoder.cn/0921b34a7b151db53a7adc0b203af083fcbcc380aae13a7e21365bface1bc8b8.png', 'image/png', 70111, '1', '2023-02-07 12:18:49', '1', '2023-02-07 12:18:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (830, 11, 'go-view/7_index_preview.png', '976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'http://test.yudao.iocoder.cn/976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'image/png', 70112, '1', '2023-02-07 12:18:54', '1', '2023-02-07 12:18:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (831, 11, 'go-view/7_index_preview.png', '976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'http://test.yudao.iocoder.cn/976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'image/png', 70112, '1', '2023-02-07 12:19:07', '1', '2023-02-07 12:19:07', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (832, 11, 'go-view/7_index_preview.png', '976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'http://test.yudao.iocoder.cn/976ac16481605f92fa548103ca8b648f0672f3bf055ad8d2f460d862c57cf5fb.png', 'image/png', 70112, '1', '2023-02-07 12:19:14', '1', '2023-02-07 12:19:14', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (833, 11, 'go-view/7_index_preview.png', '02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'http://test.yudao.iocoder.cn/02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'image/png', 158053, '1', '2023-02-07 12:19:19', '1', '2023-02-07 12:19:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (834, 11, 'go-view/7_index_preview.png', '02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'http://test.yudao.iocoder.cn/02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'image/png', 158053, '1', '2023-02-07 12:19:20', '1', '2023-02-07 12:19:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (835, 11, 'go-view/7_index_preview.png', '02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'http://test.yudao.iocoder.cn/02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'image/png', 158053, '1', '2023-02-07 12:19:50', '1', '2023-02-07 12:19:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (836, 11, 'go-view/7_index_preview.png', '02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'http://test.yudao.iocoder.cn/02b4c30f352282a20becfb833c8afe19b1eb621d99448144a95f5afc7f4d698a.png', 'image/png', 158053, '1', '2023-02-07 12:20:04', '1', '2023-02-07 12:20:04', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (837, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:09', '1', '2023-02-07 12:20:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (838, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:18', '1', '2023-02-07 12:20:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (839, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:22', '1', '2023-02-07 12:20:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (840, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:31', '1', '2023-02-07 12:20:31', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (841, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:35', '1', '2023-02-07 12:20:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (842, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:43', '1', '2023-02-07 12:20:43', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (843, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:46', '1', '2023-02-07 12:20:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (844, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:20:48', '1', '2023-02-07 12:20:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (845, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:01', '1', '2023-02-07 12:21:01', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (846, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:09', '1', '2023-02-07 12:21:09', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (847, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:16', '1', '2023-02-07 12:21:16', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (848, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:18', '1', '2023-02-07 12:21:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (849, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:29', '1', '2023-02-07 12:21:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (850, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:38', '1', '2023-02-07 12:21:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (851, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:21:48', '1', '2023-02-07 12:21:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (852, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:10', '1', '2023-02-07 12:22:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (853, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:18', '1', '2023-02-07 12:22:18', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (854, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:29', '1', '2023-02-07 12:22:29', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (855, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:32', '1', '2023-02-07 12:22:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (856, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:46', '1', '2023-02-07 12:22:46', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (857, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:48', '1', '2023-02-07 12:22:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (858, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:51', '1', '2023-02-07 12:22:51', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (859, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:22:59', '1', '2023-02-07 12:22:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (860, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:03', '1', '2023-02-07 12:23:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (861, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:19', '1', '2023-02-07 12:23:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (862, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:20', '1', '2023-02-07 12:23:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (863, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:39', '1', '2023-02-07 12:23:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (864, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:45', '1', '2023-02-07 12:23:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (865, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:48', '1', '2023-02-07 12:23:48', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (866, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:23:54', '1', '2023-02-07 12:23:54', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (867, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:24:02', '1', '2023-02-07 12:24:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (868, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:24:25', '1', '2023-02-07 12:24:25', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (869, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:24:38', '1', '2023-02-07 12:24:38', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (870, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:24:45', '1', '2023-02-07 12:24:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (871, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:24:52', '1', '2023-02-07 12:24:52', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (872, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:25:12', '1', '2023-02-07 12:25:12', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (873, 11, 'go-view/7_index_preview.png', '296cb7f6dadd1bee6acf6d6c738eeaa33b679073c2d0a8f032b0170a6153298c.png', 'http://test.yudao.iocoder.cn/296cb7f6dadd1bee6acf6d6c738eeaa33b679073c2d0a8f032b0170a6153298c.png', 'image/png', 76293, '1', '2023-02-07 12:25:34', '1', '2023-02-07 12:25:34', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (874, 11, 'go-view/7_index_preview.png', '68ee33af633533a736a91fa8c5832d744bd6840cd645bb19283902a6864a5160.png', 'http://test.yudao.iocoder.cn/68ee33af633533a736a91fa8c5832d744bd6840cd645bb19283902a6864a5160.png', 'image/png', 75865, '1', '2023-02-07 12:25:40', '1', '2023-02-07 12:25:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (875, 11, 'go-view/7_index_preview.png', '82753e3113441b06ec5a5cadfaf427fd1a4e9de090b09e1dd99870f2a64f414a.png', 'http://test.yudao.iocoder.cn/82753e3113441b06ec5a5cadfaf427fd1a4e9de090b09e1dd99870f2a64f414a.png', 'image/png', 76605, '1', '2023-02-07 12:25:49', '1', '2023-02-07 12:25:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (876, 11, 'go-view/7_index_preview.png', '114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'http://test.yudao.iocoder.cn/114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'image/png', 75663, '1', '2023-02-07 12:26:10', '1', '2023-02-07 12:26:10', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (877, 11, 'go-view/7_index_preview.png', '458352150fb81555ed2a6e800cae34f122b242f0c117b4e5987aa562265e94b1.png', 'http://test.yudao.iocoder.cn/458352150fb81555ed2a6e800cae34f122b242f0c117b4e5987aa562265e94b1.png', 'image/png', 76075, '1', '2023-02-07 12:26:19', '1', '2023-02-07 12:26:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (878, 11, 'go-view/7_index_preview.png', 'a7e114fe90800937082cd08d6528cec35beea12564264056ae8fc7f0f40711c2.png', 'http://test.yudao.iocoder.cn/a7e114fe90800937082cd08d6528cec35beea12564264056ae8fc7f0f40711c2.png', 'image/png', 76341, '1', '2023-02-07 12:26:22', '1', '2023-02-07 12:26:22', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (879, 11, 'go-view/7_index_preview.png', '09cc98620908bd795a91981a3130536e9016e4593aeae7251c090222f4f3b620.png', 'http://test.yudao.iocoder.cn/09cc98620908bd795a91981a3130536e9016e4593aeae7251c090222f4f3b620.png', 'image/png', 75697, '1', '2023-02-07 12:26:49', '1', '2023-02-07 12:26:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (880, 11, 'go-view/7_index_preview.png', '656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'http://test.yudao.iocoder.cn/656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'image/png', 75922, '1', '2023-02-07 12:26:56', '1', '2023-02-07 12:26:56', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (881, 11, 'go-view/7_index_preview.png', '68ee33af633533a736a91fa8c5832d744bd6840cd645bb19283902a6864a5160.png', 'http://test.yudao.iocoder.cn/68ee33af633533a736a91fa8c5832d744bd6840cd645bb19283902a6864a5160.png', 'image/png', 75865, '1', '2023-02-07 12:27:03', '1', '2023-02-07 12:27:03', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (882, 11, 'go-view/7_index_preview.png', '3422222c42038317eeff26798ff9210ddeffe5ee4512dc7b0c28246f361914f2.png', 'http://test.yudao.iocoder.cn/3422222c42038317eeff26798ff9210ddeffe5ee4512dc7b0c28246f361914f2.png', 'image/png', 76121, '1', '2023-02-07 12:27:20', '1', '2023-02-07 12:27:20', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (883, 11, 'go-view/7_index_preview.png', '114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'http://test.yudao.iocoder.cn/114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'image/png', 75663, '1', '2023-02-07 12:27:35', '1', '2023-02-07 12:27:35', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (884, 11, 'go-view/7_index_preview.png', '656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'http://test.yudao.iocoder.cn/656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'image/png', 75922, '1', '2023-02-07 12:27:40', '1', '2023-02-07 12:27:40', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (885, 11, 'go-view/7_index_preview.png', 'd0b2f9d690c7cec25d9407ed8b6405109704114389a33a9069d90049771006a5.png', 'http://test.yudao.iocoder.cn/d0b2f9d690c7cec25d9407ed8b6405109704114389a33a9069d90049771006a5.png', 'image/png', 75718, '1', '2023-02-07 12:27:49', '1', '2023-02-07 12:27:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (886, 11, 'go-view/7_index_preview.png', '34b6b4f6cd5ef8e0e784aa5ee1966d1802aa165eca5a191d8a407a7c1636b1ec.png', 'http://test.yudao.iocoder.cn/34b6b4f6cd5ef8e0e784aa5ee1966d1802aa165eca5a191d8a407a7c1636b1ec.png', 'image/png', 76020, '1', '2023-02-07 12:27:58', '1', '2023-02-07 12:27:58', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (887, 11, 'go-view/7_index_preview.png', '114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'http://test.yudao.iocoder.cn/114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'image/png', 75663, '1', '2023-02-07 12:28:11', '1', '2023-02-07 12:28:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (888, 11, 'go-view/7_index_preview.png', '59a2b07f38594608154afc8b210048855a391374dc10d817138403b3d6c31be9.png', 'http://test.yudao.iocoder.cn/59a2b07f38594608154afc8b210048855a391374dc10d817138403b3d6c31be9.png', 'image/png', 75690, '1', '2023-02-07 12:28:19', '1', '2023-02-07 12:28:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (889, 11, 'go-view/7_index_preview.png', '656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'http://test.yudao.iocoder.cn/656b85b6099951316fc2da986e44aeccaee0a8569cd40ce0579d87fb884c8487.png', 'image/png', 75922, '1', '2023-02-07 12:28:33', '1', '2023-02-07 12:28:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (890, 11, 'go-view/7_index_preview.png', '114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'http://test.yudao.iocoder.cn/114c5dc0ae01772a341c66cc46b9b55b69c5b2df2f1b60c331713fbecd6d1561.png', 'image/png', 75663, '1', '2023-02-07 12:28:45', '1', '2023-02-07 12:28:45', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (891, 11, 'go-view/7_index_preview.png', 'd0b2f9d690c7cec25d9407ed8b6405109704114389a33a9069d90049771006a5.png', 'http://test.yudao.iocoder.cn/d0b2f9d690c7cec25d9407ed8b6405109704114389a33a9069d90049771006a5.png', 'image/png', 75718, '1', '2023-02-07 12:28:49', '1', '2023-02-07 12:28:49', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (892, 11, 'go-view/7_index_preview.png', '4671fb7abe8fee9cace7bcfee48cdbf3881c06eb9dbc279b019d9ffa4c6d277c.png', 'http://test.yudao.iocoder.cn/4671fb7abe8fee9cace7bcfee48cdbf3881c06eb9dbc279b019d9ffa4c6d277c.png', 'image/png', 76002, '1', '2023-02-07 12:29:19', '1', '2023-02-07 12:29:19', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (893, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:29:39', '1', '2023-02-07 12:29:39', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (894, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:30:59', '1', '2023-02-07 12:30:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (895, 11, 'go-view/7_index_preview.png', 'c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'http://test.yudao.iocoder.cn/c1f570bad6ec7e7fa4a0a7c8f563da4ea158fde6e731da4dd1abe8ba9b6baeed.png', 'image/png', 76557, '1', '2023-02-07 12:33:59', '1', '2023-02-07 12:33:59', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (896, 11, 'go-view/6_index_preview.png', '7c0cb26b09cfa97cae0b3e5d19b210978eed0ab184dd0bff1b66b3daf70a01fc.png', 'http://test.yudao.iocoder.cn/7c0cb26b09cfa97cae0b3e5d19b210978eed0ab184dd0bff1b66b3daf70a01fc.png', 'image/png', 102626, '1', '2023-02-07 17:27:28', '1', '2023-02-07 17:27:28', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (897, 11, 'go-view/6_index_preview.png', '7c0cb26b09cfa97cae0b3e5d19b210978eed0ab184dd0bff1b66b3daf70a01fc.png', 'http://test.yudao.iocoder.cn/7c0cb26b09cfa97cae0b3e5d19b210978eed0ab184dd0bff1b66b3daf70a01fc.png', 'image/png', 102626, '1', '2023-02-07 17:27:32', '1', '2023-02-07 17:27:32', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (898, 11, 'go-view/9_index_preview.png', '6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'http://test.yudao.iocoder.cn/6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'image/png', 158729, '1', '2023-02-07 22:31:33', '1', '2023-02-07 22:31:33', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (899, 11, 'go-view/9_index_preview.png', '6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'http://test.yudao.iocoder.cn/6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'image/png', 158729, '1', '2023-02-07 22:31:36', '1', '2023-02-07 22:31:36', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (900, 11, 'go-view/9_index_preview.png', '6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'http://test.yudao.iocoder.cn/6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'image/png', 158729, '1', '2023-02-07 22:31:37', '1', '2023-02-07 22:31:37', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (901, 11, 'go-view/9_index_preview.png', '6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'http://test.yudao.iocoder.cn/6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'image/png', 158729, '1', '2023-02-07 22:31:41', '1', '2023-02-07 22:31:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (902, 11, 'go-view/9_index_preview.png', '6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'http://test.yudao.iocoder.cn/6f4ce052e11290dbdceb300c2e92f5492146b5ea6d43586be4b3044cccfb3aa7.png', 'image/png', 158729, '1', '2023-02-07 22:31:41', '1', '2023-02-07 22:31:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (903, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:36:02', '1', '2023-02-07 22:36:02', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (904, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:36:11', '1', '2023-02-07 22:36:11', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (905, 11, 'go-view/9_index_preview.png', '9b321d75811eb026766c9792e97b58dc188984dbe5f374dd3725767869c19442.png', 'http://test.yudao.iocoder.cn/9b321d75811eb026766c9792e97b58dc188984dbe5f374dd3725767869c19442.png', 'image/png', 158679, '1', '2023-02-07 22:36:17', '1', '2023-02-07 22:36:17', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (906, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:36:41', '1', '2023-02-07 22:36:41', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (907, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:36:50', '1', '2023-02-07 22:36:50', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (908, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:37:13', '1', '2023-02-07 22:37:13', b'0');
INSERT INTO `infra_file` (`id`, `config_id`, `name`, `path`, `url`, `type`, `size`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (909, 11, 'go-view/9_index_preview.png', 'decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'http://test.yudao.iocoder.cn/decbcbc5731e9907384c1dc4ba632ed0ee5877901f6161e3ac573a167abc8900.png', 'image/png', 154603, '1', '2023-02-07 22:38:32', '1', '2023-02-07 22:38:32', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_file_config
-- ----------------------------
DROP TABLE IF EXISTS `infra_file_config`;
CREATE TABLE `infra_file_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置名',
  `storage` tinyint NOT NULL COMMENT '存储器',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `master` bit(1) NOT NULL COMMENT '是否为主配置',
  `config` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '存储配置',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='文件配置表';

-- ----------------------------
-- Records of infra_file_config
-- ----------------------------
BEGIN;
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (4, '数据库', 1, '我是数据库', b'0', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.db.DBFileClientConfig\",\"domain\":\"http://127.0.0.1:48080\"}', '1', '2022-03-15 23:56:24', '1', '2022-03-26 21:39:26', b'0');
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5, '本地磁盘', 10, '测试下本地存储', b'0', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.local.LocalFileClientConfig\",\"basePath\":\"/Users/yunai/file_test\",\"domain\":\"http://127.0.0.1:48080\"}', '1', '2022-03-15 23:57:00', '1', '2022-03-26 21:39:26', b'0');
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (11, 'S3 - 七牛云', 20, NULL, b'1', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.s3.S3FileClientConfig\",\"endpoint\":\"s3-cn-south-1.qiniucs.com\",\"domain\":\"http://test.yudao.iocoder.cn\",\"bucket\":\"ruoyi-vue-pro\",\"accessKey\":\"b7yvuhBSAGjmtPhMFcn9iMOxUOY_I06cA_p0ZUx8\",\"accessSecret\":\"kXM1l5ia1RvSX3QaOEcwI3RLz3Y2rmNszWonKZtP\"}', '1', '2022-03-19 18:00:03', '1', '2022-03-26 21:39:26', b'0');
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (15, 'S3 - 七牛云', 20, '', b'0', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.s3.S3FileClientConfig\",\"endpoint\":\"s3-cn-south-1.qiniucs.com\",\"domain\":\"http://test.yudao.iocoder.cn\",\"bucket\":\"ruoyi-vue-pro\",\"accessKey\":\"b7yvuhBSAGjmtPhMFcn9iMOxUOY_I06cA_p0ZUx8\",\"accessSecret\":\"kXM1l5ia1RvSX3QaOEcwI3RLz3Y2rmNszWonKZtP\"}', '1', '2022-06-10 20:50:41', '1', '2022-06-10 20:50:41', b'0');
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (16, 'S3 - 七牛云', 20, '', b'0', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.s3.S3FileClientConfig\",\"endpoint\":\"s3-cn-south-1.qiniucs.com\",\"domain\":\"http://test.yudao.iocoder.cn\",\"bucket\":\"ruoyi-vue-pro\",\"accessKey\":\"b7yvuhBSAGjmtPhMFcn9iMOxUOY_I06cA_p0ZUx8\",\"accessSecret\":\"kXM1l5ia1RvSX3QaOEcwI3RLz3Y2rmNszWonKZtP\"}', '1', '2022-06-11 20:32:08', '1', '2022-06-11 20:32:08', b'0');
INSERT INTO `infra_file_config` (`id`, `name`, `storage`, `remark`, `master`, `config`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (17, 'S3 - 七牛云', 20, '', b'0', '{\"@class\":\"cn.iocoder.yudao.framework.file.core.client.s3.S3FileClientConfig\",\"endpoint\":\"s3-cn-south-1.qiniucs.com\",\"domain\":\"http://test.yudao.iocoder.cn\",\"bucket\":\"ruoyi-vue-pro\",\"accessKey\":\"b7yvuhBSAGjmtPhMFcn9iMOxUOY_I06cA_p0ZUx8\",\"accessSecret\":\"kXM1l5ia1RvSX3QaOEcwI3RLz3Y2rmNszWonKZtP\"}', '1', '2022-06-11 20:32:47', '1', '2022-06-21 08:14:54', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_file_content
-- ----------------------------
DROP TABLE IF EXISTS `infra_file_content`;
CREATE TABLE `infra_file_content` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `config_id` bigint NOT NULL COMMENT '配置编号',
  `path` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件路径',
  `content` mediumblob NOT NULL COMMENT '文件内容',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='文件表';

-- ----------------------------
-- Records of infra_file_content
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for infra_job
-- ----------------------------
DROP TABLE IF EXISTS `infra_job`;
CREATE TABLE `infra_job` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '任务编号',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '任务名称',
  `status` tinyint NOT NULL COMMENT '任务状态',
  `handler_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '处理器的名字',
  `handler_param` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '处理器的参数',
  `cron_expression` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'CRON 表达式',
  `retry_count` int NOT NULL DEFAULT '0' COMMENT '重试次数',
  `retry_interval` int NOT NULL DEFAULT '0' COMMENT '重试间隔',
  `monitor_timeout` int NOT NULL DEFAULT '0' COMMENT '监控超时时间',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='定时任务表';

-- ----------------------------
-- Records of infra_job
-- ----------------------------
BEGIN;
INSERT INTO `infra_job` (`id`, `name`, `status`, `handler_name`, `handler_param`, `cron_expression`, `retry_count`, `retry_interval`, `monitor_timeout`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5, '支付通知 Job', 1, 'payNotifyJob', NULL, '* * * * * ?', 0, 0, 0, '1', '2021-10-27 08:34:42', '1', '2022-11-24 23:01:35', b'0');
INSERT INTO `infra_job` (`id`, `name`, `status`, `handler_name`, `handler_param`, `cron_expression`, `retry_count`, `retry_interval`, `monitor_timeout`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (16, 'Job 示例', 1, 'demoJob', NULL, '* * * L * ?', 1, 1, 0, '1', '2022-09-24 22:31:41', '1', '2022-09-24 22:31:42', b'0');
COMMIT;

-- ----------------------------
-- Table structure for infra_job_log
-- ----------------------------
DROP TABLE IF EXISTS `infra_job_log`;
CREATE TABLE `infra_job_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '日志编号',
  `job_id` bigint NOT NULL COMMENT '任务编号',
  `handler_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '处理器的名字',
  `handler_param` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '处理器的参数',
  `execute_index` tinyint NOT NULL DEFAULT '1' COMMENT '第几次执行',
  `begin_time` datetime NOT NULL COMMENT '开始执行时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束执行时间',
  `duration` int DEFAULT NULL COMMENT '执行时长',
  `status` tinyint NOT NULL COMMENT '任务状态',
  `result` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '结果数据',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=168768 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='定时任务日志表';

-- ----------------------------
-- Records of infra_job_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for infra_test_demo
-- ----------------------------
DROP TABLE IF EXISTS `infra_test_demo`;
CREATE TABLE `infra_test_demo` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名字',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '状态',
  `type` tinyint NOT NULL COMMENT '类型',
  `category` tinyint NOT NULL COMMENT '分类',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='字典类型表';

-- ----------------------------
-- Records of infra_test_demo
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for system_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `system_dict_data`;
CREATE TABLE `system_dict_data` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `sort` int NOT NULL DEFAULT '0' COMMENT '字典排序',
  `label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字典标签',
  `value` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字典类型',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `color_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '颜色类型',
  `css_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'css 样式',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='字典数据表';

-- ----------------------------
-- Records of system_dict_data
-- ----------------------------
BEGIN;
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, 1, '男', '1', 'system_user_sex', 0, 'default', 'A', '性别男', 'admin', '2021-01-05 17:03:48', '1', '2022-03-29 00:14:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, 2, '女', '2', 'system_user_sex', 1, 'success', '', '性别女', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 01:30:51', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (8, 1, '正常', '1', 'infra_job_status', 0, 'success', '', '正常状态', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 19:33:38', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (9, 2, '暂停', '2', 'infra_job_status', 0, 'danger', '', '停用状态', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 19:33:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (12, 1, '系统内置', '1', 'infra_config_type', 0, 'danger', '', '参数类型 - 系统内置', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 19:06:02', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (13, 2, '自定义', '2', 'infra_config_type', 0, 'primary', '', '参数类型 - 自定义', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 19:06:07', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (14, 1, '通知', '1', 'system_notice_type', 0, 'success', '', '通知', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 13:05:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (15, 2, '公告', '2', 'system_notice_type', 0, 'info', '', '公告', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 13:06:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (16, 0, '其它', '0', 'system_operate_type', 0, 'default', '', '其它操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:32:46', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (17, 1, '查询', '1', 'system_operate_type', 0, 'info', '', '查询操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:16', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (18, 2, '新增', '2', 'system_operate_type', 0, 'primary', '', '新增操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:13', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (19, 3, '修改', '3', 'system_operate_type', 0, 'warning', '', '修改操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (20, 4, '删除', '4', 'system_operate_type', 0, 'danger', '', '删除操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:27', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (22, 5, '导出', '5', 'system_operate_type', 0, 'default', '', '导出操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:32', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (23, 6, '导入', '6', 'system_operate_type', 0, 'default', '', '导入操作', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:33:35', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (27, 1, '开启', '0', 'common_status', 0, 'primary', '', '开启状态', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 08:00:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (28, 2, '关闭', '1', 'common_status', 0, 'info', '', '关闭状态', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 08:00:44', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (29, 1, '目录', '1', 'system_menu_type', 0, '', '', '目录', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:43:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (30, 2, '菜单', '2', 'system_menu_type', 0, '', '', '菜单', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:43:41', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (31, 3, '按钮', '3', 'system_menu_type', 0, '', '', '按钮', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:43:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (32, 1, '内置', '1', 'system_role_type', 0, 'danger', '', '内置角色', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 13:02:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (33, 2, '自定义', '2', 'system_role_type', 0, 'primary', '', '自定义角色', 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 13:02:12', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (34, 1, '全部数据权限', '1', 'system_data_scope', 0, '', '', '全部数据权限', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:47:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (35, 2, '指定部门数据权限', '2', 'system_data_scope', 0, '', '', '指定部门数据权限', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:47:18', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (36, 3, '本部门数据权限', '3', 'system_data_scope', 0, '', '', '本部门数据权限', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:47:16', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (37, 4, '本部门及以下数据权限', '4', 'system_data_scope', 0, '', '', '本部门及以下数据权限', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:47:21', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (38, 5, '仅本人数据权限', '5', 'system_data_scope', 0, '', '', '仅本人数据权限', 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:47:23', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (39, 0, '成功', '0', 'system_login_result', 0, 'success', '', '登陆结果 - 成功', '', '2021-01-18 06:17:36', '1', '2022-02-16 13:23:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (40, 10, '账号或密码不正确', '10', 'system_login_result', 0, 'primary', '', '登陆结果 - 账号或密码不正确', '', '2021-01-18 06:17:54', '1', '2022-02-16 13:24:27', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (41, 20, '用户被禁用', '20', 'system_login_result', 0, 'warning', '', '登陆结果 - 用户被禁用', '', '2021-01-18 06:17:54', '1', '2022-02-16 13:23:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (42, 30, '验证码不存在', '30', 'system_login_result', 0, 'info', '', '登陆结果 - 验证码不存在', '', '2021-01-18 06:17:54', '1', '2022-02-16 13:24:07', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (43, 31, '验证码不正确', '31', 'system_login_result', 0, 'info', '', '登陆结果 - 验证码不正确', '', '2021-01-18 06:17:54', '1', '2022-02-16 13:24:11', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (44, 100, '未知异常', '100', 'system_login_result', 0, 'danger', '', '登陆结果 - 未知异常', '', '2021-01-18 06:17:54', '1', '2022-02-16 13:24:23', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (45, 1, '是', 'true', 'infra_boolean_string', 0, 'danger', '', 'Boolean 是否类型 - 是', '', '2021-01-19 03:20:55', '1', '2022-03-15 23:01:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (46, 1, '否', 'false', 'infra_boolean_string', 0, 'info', '', 'Boolean 是否类型 - 否', '', '2021-01-19 03:20:55', '1', '2022-03-15 23:09:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (47, 1, '永不超时', '1', 'infra_redis_timeout_type', 0, 'primary', '', 'Redis 未设置超时的情况', '', '2021-01-26 00:53:17', '1', '2022-02-16 19:03:35', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (48, 1, '动态超时', '2', 'infra_redis_timeout_type', 0, 'info', '', '程序里动态传入超时时间，无法固定', '', '2021-01-26 00:55:00', '1', '2022-02-16 19:03:41', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (49, 3, '固定超时', '3', 'infra_redis_timeout_type', 0, 'success', '', 'Redis 设置了过期时间', '', '2021-01-26 00:55:26', '1', '2022-02-16 19:03:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (50, 1, '单表（增删改查）', '1', 'infra_codegen_template_type', 0, '', '', NULL, '', '2021-02-05 07:09:06', '', '2022-03-10 16:33:15', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (51, 2, '树表（增删改查）', '2', 'infra_codegen_template_type', 0, '', '', NULL, '', '2021-02-05 07:14:46', '', '2022-03-10 16:33:19', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (53, 0, '初始化中', '0', 'infra_job_status', 0, 'primary', '', NULL, '', '2021-02-07 07:46:49', '1', '2022-02-16 19:33:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (57, 0, '运行中', '0', 'infra_job_log_status', 0, 'primary', '', 'RUNNING', '', '2021-02-08 10:04:24', '1', '2022-02-16 19:07:48', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (58, 1, '成功', '1', 'infra_job_log_status', 0, 'success', '', NULL, '', '2021-02-08 10:06:57', '1', '2022-02-16 19:07:52', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (59, 2, '失败', '2', 'infra_job_log_status', 0, 'warning', '', '失败', '', '2021-02-08 10:07:38', '1', '2022-02-16 19:07:56', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (60, 1, '会员', '1', 'user_type', 0, 'primary', '', NULL, '', '2021-02-26 00:16:27', '1', '2022-02-16 10:22:19', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (61, 2, '管理员', '2', 'user_type', 0, 'success', '', NULL, '', '2021-02-26 00:16:34', '1', '2022-02-16 10:22:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (62, 0, '未处理', '0', 'infra_api_error_log_process_status', 0, 'primary', '', NULL, '', '2021-02-26 07:07:19', '1', '2022-02-16 20:14:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (63, 1, '已处理', '1', 'infra_api_error_log_process_status', 0, 'success', '', NULL, '', '2021-02-26 07:07:26', '1', '2022-02-16 20:14:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (64, 2, '已忽略', '2', 'infra_api_error_log_process_status', 0, 'danger', '', NULL, '', '2021-02-26 07:07:34', '1', '2022-02-16 20:14:14', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (66, 2, '阿里云', 'ALIYUN', 'system_sms_channel_code', 0, 'primary', '', NULL, '1', '2021-04-05 01:05:26', '1', '2022-02-16 10:09:52', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (67, 1, '验证码', '1', 'system_sms_template_type', 0, 'warning', '', NULL, '1', '2021-04-05 21:50:57', '1', '2022-02-16 12:48:30', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (68, 2, '通知', '2', 'system_sms_template_type', 0, 'primary', '', NULL, '1', '2021-04-05 21:51:08', '1', '2022-02-16 12:48:27', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (69, 0, '营销', '3', 'system_sms_template_type', 0, 'danger', '', NULL, '1', '2021-04-05 21:51:15', '1', '2022-02-16 12:48:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (70, 0, '初始化', '0', 'system_sms_send_status', 0, 'primary', '', NULL, '1', '2021-04-11 20:18:33', '1', '2022-02-16 10:26:07', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (71, 1, '发送成功', '10', 'system_sms_send_status', 0, 'success', '', NULL, '1', '2021-04-11 20:18:43', '1', '2022-02-16 10:25:56', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (72, 2, '发送失败', '20', 'system_sms_send_status', 0, 'danger', '', NULL, '1', '2021-04-11 20:18:49', '1', '2022-02-16 10:26:03', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (73, 3, '不发送', '30', 'system_sms_send_status', 0, 'info', '', NULL, '1', '2021-04-11 20:19:44', '1', '2022-02-16 10:26:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (74, 0, '等待结果', '0', 'system_sms_receive_status', 0, 'primary', '', NULL, '1', '2021-04-11 20:27:43', '1', '2022-02-16 10:28:24', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (75, 1, '接收成功', '10', 'system_sms_receive_status', 0, 'success', '', NULL, '1', '2021-04-11 20:29:25', '1', '2022-02-16 10:28:28', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (76, 2, '接收失败', '20', 'system_sms_receive_status', 0, 'danger', '', NULL, '1', '2021-04-11 20:29:31', '1', '2022-02-16 10:28:32', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (77, 0, '调试(钉钉)', 'DEBUG_DING_TALK', 'system_sms_channel_code', 0, 'info', '', NULL, '1', '2021-04-13 00:20:37', '1', '2022-02-16 10:10:00', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (78, 1, '自动生成', '1', 'system_error_code_type', 0, 'warning', '', NULL, '1', '2021-04-21 00:06:48', '1', '2022-02-16 13:57:20', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (79, 2, '手动编辑', '2', 'system_error_code_type', 0, 'primary', '', NULL, '1', '2021-04-21 00:07:14', '1', '2022-02-16 13:57:24', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (80, 100, '账号登录', '100', 'system_login_type', 0, 'primary', '', '账号登录', '1', '2021-10-06 00:52:02', '1', '2022-02-16 13:11:34', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (81, 101, '社交登录', '101', 'system_login_type', 0, 'info', '', '社交登录', '1', '2021-10-06 00:52:17', '1', '2022-02-16 13:11:40', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (82, 102, 'Mock 登录', '102', 'system_login_type', 0, 'danger', '', 'Mock 登录', '1', '2021-10-06 00:52:32', '1', '2022-05-25 16:53:10', b'1');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (83, 200, '主动登出', '200', 'system_login_type', 0, 'primary', '', '主动登出', '1', '2021-10-06 00:52:58', '1', '2022-02-16 13:11:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (85, 202, '强制登出', '202', 'system_login_type', 0, 'danger', '', '强制退出', '1', '2021-10-06 00:53:41', '1', '2022-02-16 13:11:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (86, 0, '病假', '1', 'bpm_oa_leave_type', 0, 'primary', '', NULL, '1', '2021-09-21 22:35:28', '1', '2022-02-16 10:00:41', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (87, 1, '事假', '2', 'bpm_oa_leave_type', 0, 'info', '', NULL, '1', '2021-09-21 22:36:11', '1', '2022-02-16 10:00:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (88, 2, '婚假', '3', 'bpm_oa_leave_type', 0, 'warning', '', NULL, '1', '2021-09-21 22:36:38', '1', '2022-02-16 10:00:53', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (98, 1, 'v2', 'v2', 'pay_channel_wechat_version', 0, '', '', 'v2版本', '1', '2021-11-08 17:00:58', '1', '2021-11-08 17:00:58', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (99, 2, 'v3', 'v3', 'pay_channel_wechat_version', 0, '', '', 'v3版本', '1', '2021-11-08 17:01:07', '1', '2021-11-08 17:01:07', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (108, 1, 'RSA2', 'RSA2', 'pay_channel_alipay_sign_type', 0, '', '', 'RSA2', '1', '2021-11-18 15:39:29', '1', '2021-11-18 15:39:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (109, 1, '公钥模式', '1', 'pay_channel_alipay_mode', 0, '', '', '公钥模式：privateKey + alipayPublicKey', '1', '2021-11-18 15:45:23', '1', '2021-11-18 15:45:23', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (110, 2, '证书模式', '2', 'pay_channel_alipay_mode', 0, '', '', '证书模式：appCertContent + alipayPublicCertContent + rootCertContent', '1', '2021-11-18 15:45:40', '1', '2021-11-18 15:45:40', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (111, 1, '线上', 'https://openapi.alipay.com/gateway.do', 'pay_channel_alipay_server_type', 0, '', '', '网关地址 - 线上', '1', '2021-11-18 16:59:32', '1', '2021-11-21 17:37:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (112, 2, '沙箱', 'https://openapi.alipaydev.com/gateway.do', 'pay_channel_alipay_server_type', 0, '', '', '网关地址 - 沙箱', '1', '2021-11-18 16:59:48', '1', '2021-11-21 17:37:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (113, 1, '微信 JSAPI 支付', 'wx_pub', 'pay_channel_code_type', 0, '', '', '微信 JSAPI（公众号） 支付', '1', '2021-12-03 10:40:24', '1', '2021-12-04 16:41:00', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (114, 2, '微信小程序支付', 'wx_lite', 'pay_channel_code_type', 0, '', '', '微信小程序支付', '1', '2021-12-03 10:41:06', '1', '2021-12-03 10:41:06', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (115, 3, '微信 App 支付', 'wx_app', 'pay_channel_code_type', 0, '', '', '微信 App 支付', '1', '2021-12-03 10:41:20', '1', '2021-12-03 10:41:20', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (116, 4, '支付宝 PC 网站支付', 'alipay_pc', 'pay_channel_code_type', 0, '', '', '支付宝 PC 网站支付', '1', '2021-12-03 10:42:09', '1', '2021-12-03 10:42:09', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (117, 5, '支付宝 Wap 网站支付', 'alipay_wap', 'pay_channel_code_type', 0, '', '', '支付宝 Wap 网站支付', '1', '2021-12-03 10:42:26', '1', '2021-12-03 10:42:26', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (118, 6, '支付宝App 支付', 'alipay_app', 'pay_channel_code_type', 0, '', '', '支付宝App 支付', '1', '2021-12-03 10:42:55', '1', '2021-12-03 10:42:55', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (119, 7, '支付宝扫码支付', 'alipay_qr', 'pay_channel_code_type', 0, '', '', '支付宝扫码支付', '1', '2021-12-03 10:43:10', '1', '2021-12-03 10:43:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (120, 1, '通知成功', '10', 'pay_order_notify_status', 0, 'success', '', '通知成功', '1', '2021-12-03 11:02:41', '1', '2022-02-16 13:59:13', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (121, 2, '通知失败', '20', 'pay_order_notify_status', 0, 'danger', '', '通知失败', '1', '2021-12-03 11:02:59', '1', '2022-02-16 13:59:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (122, 3, '未通知', '0', 'pay_order_notify_status', 0, 'info', '', '未通知', '1', '2021-12-03 11:03:10', '1', '2022-02-16 13:59:23', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (123, 1, '支付成功', '10', 'pay_order_status', 0, 'success', '', '支付成功', '1', '2021-12-03 11:18:29', '1', '2022-02-16 15:24:25', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (124, 2, '支付关闭', '20', 'pay_order_status', 0, 'danger', '', '支付关闭', '1', '2021-12-03 11:18:42', '1', '2022-02-16 15:24:31', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (125, 3, '未支付', '0', 'pay_order_status', 0, 'info', '', '未支付', '1', '2021-12-03 11:18:18', '1', '2022-02-16 15:24:35', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (126, 1, '未退款', '0', 'pay_order_refund_status', 0, '', '', '未退款', '1', '2021-12-03 11:30:35', '1', '2021-12-03 11:34:05', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (127, 2, '部分退款', '10', 'pay_order_refund_status', 0, '', '', '部分退款', '1', '2021-12-03 11:30:44', '1', '2021-12-03 11:34:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (128, 3, '全部退款', '20', 'pay_order_refund_status', 0, '', '', '全部退款', '1', '2021-12-03 11:30:52', '1', '2021-12-03 11:34:14', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1117, 1, '退款订单生成', '0', 'pay_refund_order_status', 0, 'primary', '', '退款订单生成', '1', '2021-12-10 16:44:44', '1', '2022-02-16 14:05:24', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1118, 2, '退款成功', '1', 'pay_refund_order_status', 0, 'success', '', '退款成功', '1', '2021-12-10 16:44:59', '1', '2022-02-16 14:05:28', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1119, 3, '退款失败', '2', 'pay_refund_order_status', 0, 'danger', '', '退款失败', '1', '2021-12-10 16:45:10', '1', '2022-02-16 14:05:34', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1124, 8, '退款关闭', '99', 'pay_refund_order_status', 0, 'info', '', '退款关闭', '1', '2021-12-10 16:46:26', '1', '2022-02-16 14:05:40', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1125, 0, '默认', '1', 'bpm_model_category', 0, 'primary', '', '流程分类 - 默认', '1', '2022-01-02 08:41:11', '1', '2022-02-16 20:01:42', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1126, 0, 'OA', '2', 'bpm_model_category', 0, 'success', '', '流程分类 - OA', '1', '2022-01-02 08:41:22', '1', '2022-02-16 20:01:50', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1127, 0, '进行中', '1', 'bpm_process_instance_status', 0, 'primary', '', '流程实例的状态 - 进行中', '1', '2022-01-07 23:47:22', '1', '2022-02-16 20:07:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1128, 2, '已完成', '2', 'bpm_process_instance_status', 0, 'success', '', '流程实例的状态 - 已完成', '1', '2022-01-07 23:47:49', '1', '2022-02-16 20:07:54', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1129, 1, '处理中', '1', 'bpm_process_instance_result', 0, 'primary', '', '流程实例的结果 - 处理中', '1', '2022-01-07 23:48:32', '1', '2022-02-16 09:53:26', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1130, 2, '通过', '2', 'bpm_process_instance_result', 0, 'success', '', '流程实例的结果 - 通过', '1', '2022-01-07 23:48:45', '1', '2022-02-16 09:53:31', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1131, 3, '不通过', '3', 'bpm_process_instance_result', 0, 'danger', '', '流程实例的结果 - 不通过', '1', '2022-01-07 23:48:55', '1', '2022-02-16 09:53:38', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1132, 4, '已取消', '4', 'bpm_process_instance_result', 0, 'info', '', '流程实例的结果 - 撤销', '1', '2022-01-07 23:49:06', '1', '2022-02-16 09:53:42', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1133, 10, '流程表单', '10', 'bpm_model_form_type', 0, '', '', '流程的表单类型 - 流程表单', '103', '2022-01-11 23:51:30', '103', '2022-01-11 23:51:30', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1134, 20, '业务表单', '20', 'bpm_model_form_type', 0, '', '', '流程的表单类型 - 业务表单', '103', '2022-01-11 23:51:47', '103', '2022-01-11 23:51:47', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1135, 10, '角色', '10', 'bpm_task_assign_rule_type', 0, 'info', '', '任务分配规则的类型 - 角色', '103', '2022-01-12 23:21:22', '1', '2022-02-16 20:06:14', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1136, 20, '部门的成员', '20', 'bpm_task_assign_rule_type', 0, 'primary', '', '任务分配规则的类型 - 部门的成员', '103', '2022-01-12 23:21:47', '1', '2022-02-16 20:05:28', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1137, 21, '部门的负责人', '21', 'bpm_task_assign_rule_type', 0, 'primary', '', '任务分配规则的类型 - 部门的负责人', '103', '2022-01-12 23:33:36', '1', '2022-02-16 20:05:31', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1138, 30, '用户', '30', 'bpm_task_assign_rule_type', 0, 'info', '', '任务分配规则的类型 - 用户', '103', '2022-01-12 23:34:02', '1', '2022-02-16 20:05:50', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1139, 40, '用户组', '40', 'bpm_task_assign_rule_type', 0, 'warning', '', '任务分配规则的类型 - 用户组', '103', '2022-01-12 23:34:21', '1', '2022-02-16 20:05:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1140, 50, '自定义脚本', '50', 'bpm_task_assign_rule_type', 0, 'danger', '', '任务分配规则的类型 - 自定义脚本', '103', '2022-01-12 23:34:43', '1', '2022-02-16 20:06:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1141, 22, '岗位', '22', 'bpm_task_assign_rule_type', 0, 'success', '', '任务分配规则的类型 - 岗位', '103', '2022-01-14 18:41:55', '1', '2022-02-16 20:05:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1142, 10, '流程发起人', '10', 'bpm_task_assign_script', 0, '', '', '任务分配自定义脚本 - 流程发起人', '103', '2022-01-15 00:10:57', '103', '2022-01-15 21:24:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1143, 20, '流程发起人的一级领导', '20', 'bpm_task_assign_script', 0, '', '', '任务分配自定义脚本 - 流程发起人的一级领导', '103', '2022-01-15 21:24:31', '103', '2022-01-15 21:24:31', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1144, 21, '流程发起人的二级领导', '21', 'bpm_task_assign_script', 0, '', '', '任务分配自定义脚本 - 流程发起人的二级领导', '103', '2022-01-15 21:24:46', '103', '2022-01-15 21:24:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1145, 1, '管理后台', '1', 'infra_codegen_scene', 0, '', '', '代码生成的场景枚举 - 管理后台', '1', '2022-02-02 13:15:06', '1', '2022-03-10 16:32:59', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1146, 2, '用户 APP', '2', 'infra_codegen_scene', 0, '', '', '代码生成的场景枚举 - 用户 APP', '1', '2022-02-02 13:15:19', '1', '2022-03-10 16:33:03', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1147, 0, '未退款', '0', 'pay_refund_order_type', 0, 'info', '', '退款类型 - 未退款', '1', '2022-02-16 14:09:01', '1', '2022-02-16 14:09:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1148, 10, '部分退款', '10', 'pay_refund_order_type', 0, 'success', '', '退款类型 - 部分退款', '1', '2022-02-16 14:09:25', '1', '2022-02-16 14:11:38', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1149, 20, '全部退款', '20', 'pay_refund_order_type', 0, 'warning', '', '退款类型 - 全部退款', '1', '2022-02-16 14:11:33', '1', '2022-02-16 14:11:33', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1150, 1, '数据库', '1', 'infra_file_storage', 0, 'default', '', NULL, '1', '2022-03-15 00:25:28', '1', '2022-03-15 00:25:28', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1151, 10, '本地磁盘', '10', 'infra_file_storage', 0, 'default', '', NULL, '1', '2022-03-15 00:25:41', '1', '2022-03-15 00:25:56', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1152, 11, 'FTP 服务器', '11', 'infra_file_storage', 0, 'default', '', NULL, '1', '2022-03-15 00:26:06', '1', '2022-03-15 00:26:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1153, 12, 'SFTP 服务器', '12', 'infra_file_storage', 0, 'default', '', NULL, '1', '2022-03-15 00:26:22', '1', '2022-03-15 00:26:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1154, 20, 'S3 对象存储', '20', 'infra_file_storage', 0, 'default', '', NULL, '1', '2022-03-15 00:26:31', '1', '2022-03-15 00:26:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1155, 103, '短信登录', '103', 'system_login_type', 0, 'default', '', NULL, '1', '2022-05-09 23:57:58', '1', '2022-05-09 23:58:09', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1156, 1, 'password', 'password', 'system_oauth2_grant_type', 0, 'default', '', '密码模式', '1', '2022-05-12 00:22:05', '1', '2022-05-11 16:26:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1157, 2, 'authorization_code', 'authorization_code', 'system_oauth2_grant_type', 0, 'primary', '', '授权码模式', '1', '2022-05-12 00:22:59', '1', '2022-05-11 16:26:02', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1158, 3, 'implicit', 'implicit', 'system_oauth2_grant_type', 0, 'success', '', '简化模式', '1', '2022-05-12 00:23:40', '1', '2022-05-11 16:26:05', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1159, 4, 'client_credentials', 'client_credentials', 'system_oauth2_grant_type', 0, 'default', '', '客户端模式', '1', '2022-05-12 00:23:51', '1', '2022-05-11 16:26:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1160, 5, 'refresh_token', 'refresh_token', 'system_oauth2_grant_type', 0, 'info', '', '刷新模式', '1', '2022-05-12 00:24:02', '1', '2022-05-11 16:26:11', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1161, 3, '3', '3', 'infra_config_type', 0, 'success', '', '33', '1', '2022-05-16 20:30:28', '1', '2022-05-16 12:30:30', b'1');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1162, 1, '销售中', '1', 'product_spu_status', 0, 'success', '', '商品 SPU 状态 - 销售中', '1', '2022-10-24 21:19:47', '1', '2022-10-24 21:20:38', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1163, 0, '仓库中', '0', 'product_spu_status', 0, 'info', '', '商品 SPU 状态 - 仓库中', '1', '2022-10-24 21:20:54', '1', '2022-10-24 21:21:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1164, 0, '回收站', '-1', 'product_spu_status', 0, 'default', '', '商品 SPU 状态 - 回收站', '1', '2022-10-24 21:21:11', '1', '2022-10-24 21:21:11', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1165, 1, '满减', '1', 'promotion_discount_type', 0, 'success', '', '优惠类型 - 满减', '1', '2022-11-01 12:46:41', '1', '2022-11-01 12:50:11', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1166, 2, '折扣', '2', 'promotion_discount_type', 0, 'primary', '', '优惠类型 - 折扣', '1', '2022-11-01 12:46:51', '1', '2022-11-01 12:50:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1167, 1, '固定日期', '1', 'promotion_coupon_template_validity_type', 0, 'default', '', '优惠劵模板的有限期类型 - 固定日期', '1', '2022-11-02 00:07:34', '1', '2022-11-04 00:07:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1168, 2, '领取之后', '2', 'promotion_coupon_template_validity_type', 0, 'default', '', '优惠劵模板的有限期类型 - 领取之后', '1', '2022-11-02 00:07:54', '1', '2022-11-04 00:07:52', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1169, 1, '全部商品参与', '1', 'promotion_product_scope', 0, 'default', '', '营销的商品范围 - 全部商品参与', '1', '2022-11-02 00:28:22', '1', '2022-11-02 00:28:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1170, 2, '指定商品参与', '2', 'promotion_product_scope', 0, 'default', '', '营销的商品范围 - 指定商品参与', '1', '2022-11-02 00:28:34', '1', '2022-11-02 00:28:40', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1171, 1, '已领取', '1', 'promotion_coupon_status', 0, 'primary', '', '优惠劵的状态 - 已领取', '1', '2022-11-04 00:15:08', '1', '2022-11-04 19:16:04', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1172, 2, '已使用', '2', 'promotion_coupon_status', 0, 'success', '', '优惠劵的状态 - 已使用', '1', '2022-11-04 00:15:21', '1', '2022-11-04 19:16:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1173, 3, '已过期', '3', 'promotion_coupon_status', 0, 'info', '', '优惠劵的状态 - 已过期', '1', '2022-11-04 00:15:43', '1', '2022-11-04 19:16:12', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1174, 1, '直接领取', '1', 'promotion_coupon_take_type', 0, 'primary', '', '优惠劵的领取方式 - 直接领取', '1', '2022-11-04 19:13:00', '1', '2022-11-04 19:13:25', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1175, 2, '指定发放', '2', 'promotion_coupon_take_type', 0, 'success', '', '优惠劵的领取方式 - 指定发放', '1', '2022-11-04 19:13:13', '1', '2022-11-04 19:14:48', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1176, 10, '未开始', '10', 'promotion_activity_status', 0, 'primary', '', '促销活动的状态枚举 - 未开始', '1', '2022-11-04 22:54:49', '1', '2022-11-04 22:55:53', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1177, 20, '进行中', '20', 'promotion_activity_status', 0, 'success', '', '促销活动的状态枚举 - 进行中', '1', '2022-11-04 22:55:06', '1', '2022-11-04 22:55:20', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1178, 30, '已结束', '30', 'promotion_activity_status', 0, 'info', '', '促销活动的状态枚举 - 已结束', '1', '2022-11-04 22:55:41', '1', '2022-11-04 22:55:41', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1179, 40, '已关闭', '40', 'promotion_activity_status', 0, 'warning', '', '促销活动的状态枚举 - 已关闭', '1', '2022-11-04 22:56:10', '1', '2022-11-04 22:56:18', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1180, 10, '满 N 元', '10', 'promotion_condition_type', 0, 'primary', '', '营销的条件类型 - 满 N 元', '1', '2022-11-04 22:59:45', '1', '2022-11-04 22:59:45', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1181, 20, '满 N 件', '20', 'promotion_condition_type', 0, 'success', '', '营销的条件类型 - 满 N 件', '1', '2022-11-04 23:00:02', '1', '2022-11-04 23:00:02', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1182, 10, '申请售后', '10', 'trade_after_sale_status', 0, 'primary', '', '交易售后状态 - 申请售后', '1', '2022-11-19 20:53:33', '1', '2022-11-19 20:54:42', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1183, 20, '商品待退货', '20', 'trade_after_sale_status', 0, 'primary', '', '交易售后状态 - 商品待退货', '1', '2022-11-19 20:54:36', '1', '2022-11-19 20:58:58', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1184, 30, '商家待收货', '30', 'trade_after_sale_status', 0, 'primary', '', '交易售后状态 - 商家待收货', '1', '2022-11-19 20:56:56', '1', '2022-11-19 20:59:20', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1185, 40, '等待退款', '40', 'trade_after_sale_status', 0, 'primary', '', '交易售后状态 - 等待退款', '1', '2022-11-19 20:59:54', '1', '2022-11-19 21:00:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1186, 50, '退款成功', '50', 'trade_after_sale_status', 0, 'default', '', '交易售后状态 - 退款成功', '1', '2022-11-19 21:00:33', '1', '2022-11-19 21:00:33', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1187, 61, '买家取消', '61', 'trade_after_sale_status', 0, 'info', '', '交易售后状态 - 买家取消', '1', '2022-11-19 21:01:29', '1', '2022-11-19 21:01:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1188, 62, '商家拒绝', '62', 'trade_after_sale_status', 0, 'info', '', '交易售后状态 - 商家拒绝', '1', '2022-11-19 21:02:17', '1', '2022-11-19 21:02:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1189, 63, '商家拒收货', '63', 'trade_after_sale_status', 0, 'info', '', '交易售后状态 - 商家拒收货', '1', '2022-11-19 21:02:37', '1', '2022-11-19 21:03:07', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1190, 10, '售中退款', '10', 'trade_after_sale_type', 0, 'success', '', '交易售后的类型 - 售中退款', '1', '2022-11-19 21:05:05', '1', '2022-11-19 21:38:23', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1191, 20, '售后退款', '20', 'trade_after_sale_type', 0, 'primary', '', '交易售后的类型 - 售后退款', '1', '2022-11-19 21:05:32', '1', '2022-11-19 21:38:32', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1192, 10, '仅退款', '10', 'trade_after_sale_way', 0, 'primary', '', '交易售后的方式 - 仅退款', '1', '2022-11-19 21:39:19', '1', '2022-11-19 21:39:19', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1193, 20, '退货退款', '20', 'trade_after_sale_way', 0, 'success', '', '交易售后的方式 - 退货退款', '1', '2022-11-19 21:39:38', '1', '2022-11-19 21:39:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1194, 10, '微信小程序', '10', 'terminal', 0, 'default', '', '终端 - 微信小程序', '1', '2022-12-10 10:51:11', '1', '2022-12-10 10:51:57', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1195, 20, 'H5 网页', '20', 'terminal', 0, 'default', '', '终端 - H5 网页', '1', '2022-12-10 10:51:30', '1', '2022-12-10 10:51:59', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1196, 11, '微信公众号', '11', 'terminal', 0, 'default', '', '终端 - 微信公众号', '1', '2022-12-10 10:54:16', '1', '2022-12-10 10:52:01', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1197, 31, '苹果 App', '31', 'terminal', 0, 'default', '', '终端 - 苹果 App', '1', '2022-12-10 10:54:42', '1', '2022-12-10 10:52:18', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1198, 32, '安卓 App', '32', 'terminal', 0, 'default', '', '终端 - 安卓 App', '1', '2022-12-10 10:55:02', '1', '2022-12-10 10:59:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1199, 0, '普通订单', '0', 'trade_order_type', 0, 'default', '', '交易订单的类型 - 普通订单', '1', '2022-12-10 16:34:14', '1', '2022-12-10 16:34:14', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1200, 1, '秒杀订单', '1', 'trade_order_type', 0, 'default', '', '交易订单的类型 - 秒杀订单', '1', '2022-12-10 16:34:26', '1', '2022-12-10 16:34:26', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1201, 2, '拼团订单', '2', 'trade_order_type', 0, 'default', '', '交易订单的类型 - 拼团订单', '1', '2022-12-10 16:34:36', '1', '2022-12-10 16:34:36', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1202, 3, '砍价订单', '3', 'trade_order_type', 0, 'default', '', '交易订单的类型 - 砍价订单', '1', '2022-12-10 16:34:48', '1', '2022-12-10 16:34:48', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1203, 0, '待支付', '0', 'trade_order_status', 0, 'default', '', '交易订单状态 - 待支付', '1', '2022-12-10 16:49:29', '1', '2022-12-10 16:49:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1204, 10, '待发货', '10', 'trade_order_status', 0, 'primary', '', '交易订单状态 - 待发货', '1', '2022-12-10 16:49:53', '1', '2022-12-10 16:51:17', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1205, 20, '已发货', '20', 'trade_order_status', 0, 'primary', '', '交易订单状态 - 已发货', '1', '2022-12-10 16:50:13', '1', '2022-12-10 16:51:31', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1206, 30, '已完成', '30', 'trade_order_status', 0, 'success', '', '交易订单状态 - 已完成', '1', '2022-12-10 16:50:30', '1', '2022-12-10 16:51:06', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1207, 40, '已取消', '40', 'trade_order_status', 0, 'danger', '', '交易订单状态 - 已取消', '1', '2022-12-10 16:50:50', '1', '2022-12-10 16:51:00', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1208, 0, '未售后', '0', 'trade_order_item_after_sale_status', 0, 'info', '', '交易订单项的售后状态 - 未售后', '1', '2022-12-10 20:58:42', '1', '2022-12-10 20:59:29', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1209, 1, '售后中', '1', 'trade_order_item_after_sale_status', 0, 'primary', '', '交易订单项的售后状态 - 售后中', '1', '2022-12-10 20:59:21', '1', '2022-12-10 20:59:21', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1210, 2, '已退款', '2', 'trade_order_item_after_sale_status', 0, 'success', '', '交易订单项的售后状态 - 已退款', '1', '2022-12-10 20:59:46', '1', '2022-12-10 20:59:46', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1211, 1, '完全匹配', '1', 'mp_auto_reply_request_match', 0, 'primary', '', '公众号自动回复的请求关键字匹配模式 - 完全匹配', '1', '2023-01-16 23:30:39', '1', '2023-01-16 23:31:00', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1212, 2, '半匹配', '2', 'mp_auto_reply_request_match', 0, 'success', '', '公众号自动回复的请求关键字匹配模式 - 半匹配', '1', '2023-01-16 23:30:55', '1', '2023-01-16 23:31:10', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1213, 1, '文本', 'text', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 文本', '1', '2023-01-17 22:17:32', '1', '2023-01-17 22:17:39', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1214, 2, '图片', 'image', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 图片', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:19:47', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1215, 3, '语音', 'voice', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 语音', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:20:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1216, 4, '视频', 'video', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 视频', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:21:08', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1217, 5, '小视频', 'shortvideo', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 小视频', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:19:59', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1218, 6, '图文', 'news', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 图文', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:22:54', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1219, 7, '音乐', 'music', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 音乐', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:22:54', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1220, 8, '地理位置', 'location', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 地理位置', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:23:51', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1221, 9, '链接', 'link', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 链接', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:24:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1222, 10, '事件', 'event', 'mp_message_type', 0, 'default', '', '公众号的消息类型 - 事件', '1', '2023-01-17 22:17:32', '1', '2023-01-17 14:24:49', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1223, 0, '初始化', '0', 'system_mail_send_status', 0, 'primary', '', '邮件发送状态 - 初始化\n', '1', '2023-01-26 09:53:49', '1', '2023-01-26 16:36:14', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1224, 10, '发送成功', '10', 'system_mail_send_status', 0, 'success', '', '邮件发送状态 - 发送成功', '1', '2023-01-26 09:54:28', '1', '2023-01-26 16:36:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1225, 20, '发送失败', '20', 'system_mail_send_status', 0, 'danger', '', '邮件发送状态 - 发送失败', '1', '2023-01-26 09:54:50', '1', '2023-01-26 16:36:26', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1226, 30, '不发送', '30', 'system_mail_send_status', 0, 'info', '', '邮件发送状态 -  不发送', '1', '2023-01-26 09:55:06', '1', '2023-01-26 16:36:36', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1227, 1, '通知公告', '1', 'system_notify_template_type', 0, 'primary', '', '站内信模版的类型 - 通知公告', '1', '2023-01-28 10:35:59', '1', '2023-01-28 10:35:59', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1228, 2, '系统消息', '2', 'system_notify_template_type', 0, 'success', '', '站内信模版的类型 - 系统消息', '1', '2023-01-28 10:36:20', '1', '2023-01-28 10:36:25', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1229, 0, '模拟支付', 'mock', 'pay_channel_code_type', 0, 'default', '', NULL, '1', '2023-02-12 21:50:22', '1', '2023-02-12 21:50:22', b'0');
INSERT INTO `system_dict_data` (`id`, `sort`, `label`, `value`, `dict_type`, `status`, `color_type`, `css_class`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1230, 8, '支付宝条码支付', 'alipay_bar', 'pay_channel_code_type', 0, 'default', '', NULL, '1', '2023-02-18 23:32:24', '1', '2023-02-18 23:32:32', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `system_dict_type`;
CREATE TABLE `system_dict_type` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字典名称',
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '字典类型',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `deleted_time` datetime DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `dict_type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='字典类型表';

-- ----------------------------
-- Records of system_dict_type
-- ----------------------------
BEGIN;
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (1, '用户性别', 'system_user_sex', 0, NULL, 'admin', '2021-01-05 17:03:48', '1', '2022-05-16 20:29:32', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (6, '参数类型', 'infra_config_type', 0, NULL, 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:36:54', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (7, '通知类型', 'system_notice_type', 0, NULL, 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:35:26', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (9, '操作类型', 'system_operate_type', 0, NULL, 'admin', '2021-01-05 17:03:48', '1', '2022-02-16 09:32:21', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (10, '系统状态', 'common_status', 0, NULL, 'admin', '2021-01-05 17:03:48', '', '2022-02-01 16:21:28', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (11, 'Boolean 是否类型', 'infra_boolean_string', 0, 'boolean 转是否', '', '2021-01-19 03:20:08', '', '2022-02-01 16:37:10', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (104, '登陆结果', 'system_login_result', 0, '登陆结果', '', '2021-01-18 06:17:11', '', '2022-02-01 16:36:00', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (105, 'Redis 超时类型', 'infra_redis_timeout_type', 0, 'RedisKeyDefine.TimeoutTypeEnum', '', '2021-01-26 00:52:50', '', '2022-02-01 16:50:29', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (106, '代码生成模板类型', 'infra_codegen_template_type', 0, NULL, '', '2021-02-05 07:08:06', '1', '2022-05-16 20:26:50', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (107, '定时任务状态', 'infra_job_status', 0, NULL, '', '2021-02-07 07:44:16', '', '2022-02-01 16:51:11', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (108, '定时任务日志状态', 'infra_job_log_status', 0, NULL, '', '2021-02-08 10:03:51', '', '2022-02-01 16:50:43', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (109, '用户类型', 'user_type', 0, NULL, '', '2021-02-26 00:15:51', '', '2021-02-26 00:15:51', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (110, 'API 异常数据的处理状态', 'infra_api_error_log_process_status', 0, NULL, '', '2021-02-26 07:07:01', '', '2022-02-01 16:50:53', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (111, '短信渠道编码', 'system_sms_channel_code', 0, NULL, '1', '2021-04-05 01:04:50', '1', '2022-02-16 02:09:08', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (112, '短信模板的类型', 'system_sms_template_type', 0, NULL, '1', '2021-04-05 21:50:43', '1', '2022-02-01 16:35:06', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (113, '短信发送状态', 'system_sms_send_status', 0, NULL, '1', '2021-04-11 20:18:03', '1', '2022-02-01 16:35:09', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (114, '短信接收状态', 'system_sms_receive_status', 0, NULL, '1', '2021-04-11 20:27:14', '1', '2022-02-01 16:35:14', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (115, '错误码的类型', 'system_error_code_type', 0, NULL, '1', '2021-04-21 00:06:30', '1', '2022-02-01 16:36:49', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (116, '登陆日志的类型', 'system_login_type', 0, '登陆日志的类型', '1', '2021-10-06 00:50:46', '1', '2022-02-01 16:35:56', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (117, 'OA 请假类型', 'bpm_oa_leave_type', 0, NULL, '1', '2021-09-21 22:34:33', '1', '2022-01-22 10:41:37', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (122, '支付渠道微信版本', 'pay_channel_wechat_version', 0, '支付渠道微信版本', '1', '2021-11-08 17:00:26', '1', '2021-11-08 17:00:26', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (127, '支付渠道支付宝算法类型', 'pay_channel_alipay_sign_type', 0, '支付渠道支付宝算法类型', '1', '2021-11-18 15:39:09', '1', '2021-11-18 15:39:09', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (128, '支付渠道支付宝公钥类型', 'pay_channel_alipay_mode', 0, '支付渠道支付宝公钥类型', '1', '2021-11-18 15:44:28', '1', '2021-11-18 15:44:28', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (129, '支付宝网关地址', 'pay_channel_alipay_server_type', 0, '支付宝网关地址', '1', '2021-11-18 16:58:55', '1', '2021-11-18 17:01:34', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (130, '支付渠道编码类型', 'pay_channel_code_type', 0, '支付渠道的编码', '1', '2021-12-03 10:35:08', '1', '2021-12-03 10:35:08', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (131, '支付订单回调状态', 'pay_order_notify_status', 0, '支付订单回调状态', '1', '2021-12-03 10:53:29', '1', '2021-12-03 10:53:29', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (132, '支付订单状态', 'pay_order_status', 0, '支付订单状态', '1', '2021-12-03 11:17:50', '1', '2021-12-03 11:17:50', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (133, '支付订单退款状态', 'pay_order_refund_status', 0, '支付订单退款状态', '1', '2021-12-03 11:27:31', '1', '2021-12-03 11:27:31', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (134, '退款订单状态', 'pay_refund_order_status', 0, '退款订单状态', '1', '2021-12-10 16:42:50', '1', '2021-12-10 16:42:50', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (135, '退款订单类别', 'pay_refund_order_type', 0, '退款订单类别', '1', '2021-12-10 17:14:53', '1', '2021-12-10 17:14:53', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (138, '流程分类', 'bpm_model_category', 0, '流程分类', '1', '2022-01-02 08:40:45', '1', '2022-01-02 08:40:45', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (139, '流程实例的状态', 'bpm_process_instance_status', 0, '流程实例的状态', '1', '2022-01-07 23:46:42', '1', '2022-01-07 23:46:42', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (140, '流程实例的结果', 'bpm_process_instance_result', 0, '流程实例的结果', '1', '2022-01-07 23:48:10', '1', '2022-01-07 23:48:10', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (141, '流程的表单类型', 'bpm_model_form_type', 0, '流程的表单类型', '103', '2022-01-11 23:50:45', '103', '2022-01-11 23:50:45', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (142, '任务分配规则的类型', 'bpm_task_assign_rule_type', 0, '任务分配规则的类型', '103', '2022-01-12 23:21:04', '103', '2022-01-12 15:46:10', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (143, '任务分配自定义脚本', 'bpm_task_assign_script', 0, '任务分配自定义脚本', '103', '2022-01-15 00:10:35', '103', '2022-01-15 00:10:35', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (144, '代码生成的场景枚举', 'infra_codegen_scene', 0, '代码生成的场景枚举', '1', '2022-02-02 13:14:45', '1', '2022-03-10 16:33:46', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (145, '角色类型', 'system_role_type', 0, '角色类型', '1', '2022-02-16 13:01:46', '1', '2022-02-16 13:01:46', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (146, '文件存储器', 'infra_file_storage', 0, '文件存储器', '1', '2022-03-15 00:24:38', '1', '2022-03-15 00:24:38', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (147, 'OAuth 2.0 授权类型', 'system_oauth2_grant_type', 0, 'OAuth 2.0 授权类型（模式）', '1', '2022-05-12 00:20:52', '1', '2022-05-11 16:25:49', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (148, 'test', '111', 0, 'test', '1', '2022-05-16 20:30:00', '1', '2022-05-16 12:30:04', b'1', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (149, '商品 SPU 状态', 'product_spu_status', 0, '商品 SPU 状态', '1', '2022-10-24 21:19:04', '1', '2022-10-24 21:19:08', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (150, '优惠类型', 'promotion_discount_type', 0, '优惠类型', '1', '2022-11-01 12:46:06', '1', '2022-11-01 12:46:06', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (151, '优惠劵模板的有限期类型', 'promotion_coupon_template_validity_type', 0, '优惠劵模板的有限期类型', '1', '2022-11-02 00:06:20', '1', '2022-11-04 00:08:26', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (152, '营销的商品范围', 'promotion_product_scope', 0, '营销的商品范围', '1', '2022-11-02 00:28:01', '1', '2022-11-02 00:28:01', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (153, '优惠劵的状态', 'promotion_coupon_status', 0, '优惠劵的状态', '1', '2022-11-04 00:14:49', '1', '2022-11-04 00:14:49', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (154, '优惠劵的领取方式', 'promotion_coupon_take_type', 0, '优惠劵的领取方式', '1', '2022-11-04 19:12:27', '1', '2022-11-04 19:12:27', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (155, '促销活动的状态', 'promotion_activity_status', 0, '促销活动的状态', '1', '2022-11-04 22:54:23', '1', '2022-11-04 22:54:23', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (156, '营销的条件类型', 'promotion_condition_type', 0, '营销的条件类型', '1', '2022-11-04 22:59:23', '1', '2022-11-04 22:59:23', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (157, '交易售后状态', 'trade_after_sale_status', 0, '交易售后状态', '1', '2022-11-19 20:52:56', '1', '2022-11-19 20:52:56', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (158, '交易售后的类型', 'trade_after_sale_type', 0, '交易售后的类型', '1', '2022-11-19 21:04:09', '1', '2022-11-19 21:04:09', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (159, '交易售后的方式', 'trade_after_sale_way', 0, '交易售后的方式', '1', '2022-11-19 21:39:04', '1', '2022-11-19 21:39:04', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (160, '终端', 'terminal', 0, '终端', '1', '2022-12-10 10:50:50', '1', '2022-12-10 10:53:11', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (161, '交易订单的类型', 'trade_order_type', 0, '交易订单的类型', '1', '2022-12-10 16:33:54', '1', '2022-12-10 16:33:54', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (162, '交易订单的状态', 'trade_order_status', 0, '交易订单的状态', '1', '2022-12-10 16:48:44', '1', '2022-12-10 16:48:44', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (163, '交易订单项的售后状态', 'trade_order_item_after_sale_status', 0, '交易订单项的售后状态', '1', '2022-12-10 20:58:08', '1', '2022-12-10 20:58:08', b'0', NULL);
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (164, '公众号自动回复的请求关键字匹配模式', 'mp_auto_reply_request_match', 0, '公众号自动回复的请求关键字匹配模式', '1', '2023-01-16 23:29:56', '1', '2023-01-16 23:29:56', b'0', '1970-01-01 00:00:00');
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (165, '公众号的消息类型', 'mp_message_type', 0, '公众号的消息类型', '1', '2023-01-17 22:17:09', '1', '2023-01-17 22:17:09', b'0', '1970-01-01 00:00:00');
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (166, '邮件发送状态', 'system_mail_send_status', 0, '邮件发送状态', '1', '2023-01-26 09:53:13', '1', '2023-01-26 09:53:13', b'0', '1970-01-01 00:00:00');
INSERT INTO `system_dict_type` (`id`, `name`, `type`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `deleted_time`) VALUES (167, '站内信模版的类型', 'system_notify_template_type', 0, '站内信模版的类型', '1', '2023-01-28 10:35:10', '1', '2023-01-28 10:35:10', b'0', '1970-01-01 00:00:00');
COMMIT;

-- ----------------------------
-- Table structure for system_error_code
-- ----------------------------
DROP TABLE IF EXISTS `system_error_code`;
CREATE TABLE `system_error_code` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '错误码编号',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '错误码类型',
  `application_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用名',
  `code` int NOT NULL DEFAULT '0' COMMENT '错误码编码',
  `message` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '错误码错误提示',
  `memo` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5833 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='错误码表';

-- ----------------------------
-- Records of system_error_code
-- ----------------------------
BEGIN;
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5644, 1, 'yudao-server', 1009000002, '获取高亮流程图异常', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5645, 1, 'yudao-server', 1009001001, '请假申请不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5646, 1, 'yudao-server', 1009001002, '项目经理岗位未设置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5647, 1, 'yudao-server', 1009001009, '部门的项目经理不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5648, 1, 'yudao-server', 1009001004, '部门经理岗位未设置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5649, 1, 'yudao-server', 1009001005, '部门的部门经理不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5650, 1, 'yudao-server', 1009001006, 'HR岗位未设置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5651, 1, 'yudao-server', 1009001007, '请假天数必须>=1', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5652, 1, 'yudao-server', 1009002000, '已经存在流程标识为【{}】的流程', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5653, 1, 'yudao-server', 1009002001, '流程模型不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5654, 1, 'yudao-server', 1009002002, '流程标识格式不正确，需要以字母或下划线开头，后接任意字母、数字、中划线、下划线、句点！', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5655, 1, 'yudao-server', 1009002003, '部署流程失败，原因：流程表单未配置，请点击【修改流程】按钮进行配置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5656, 1, 'yudao-server', 1009002004, '部署流程失败，原因：用户任务({})未配置分配规则，请点击【修改流程】按钮进行配置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5657, 1, 'yudao-server', 1009003005, '流程定义部署失败，原因：信息未发生变化', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5658, 1, 'yudao-server', 1009003000, '流程定义的标识期望是({})，当前是({})，请修改 BPMN 流程图', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5659, 1, 'yudao-server', 1009003001, '流程定义的名字期望是({})，当前是({})，请修改 BPMN 流程图', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5660, 1, 'yudao-server', 1009003002, '流程定义不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5661, 1, 'yudao-server', 1009003003, '流程定义处于挂起状态', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5662, 1, 'yudao-server', 1009003004, '流程定义的模型不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5663, 1, 'yudao-server', 1009004000, '流程实例不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5664, 1, 'yudao-server', 1009004001, '流程取消失败，流程不处于运行中', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5665, 1, 'yudao-server', 1009004002, '流程取消失败，该流程不是你发起的', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5666, 1, 'yudao-server', 1009005000, '审批任务失败，原因：该任务不处于未审批', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5667, 1, 'yudao-server', 1009005001, '审批任务失败，原因：该任务的审批人不是你', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5668, 1, 'yudao-server', 1009006000, '流程({}) 的任务({}) 已经存在分配规则', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5669, 1, 'yudao-server', 1009006001, '流程任务分配规则不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5670, 1, 'yudao-server', 1009006002, '只有流程模型的任务分配规则，才允许被修改', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5671, 1, 'yudao-server', 1009006003, '操作失败，原因：找不到任务的审批人！', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5672, 1, 'yudao-server', 1009006004, '操作失败，原因：任务分配脚本({}) 不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5673, 2, 'yudao-server', 1009010000, '动态表单不存在啊', '', NULL, '2022-05-23 22:18:16', '1', '2022-07-02 21:43:01', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5674, 1, 'yudao-server', 1009010001, '表单项({}) 和 ({}) 使用了相同的字段名({})', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5675, 1, 'yudao-server', 1009011000, '用户组不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5676, 1, 'yudao-server', 1009011001, '名字为【{}】的用户组已被禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5677, 1, 'yudao-server', 1001000001, '参数配置不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5678, 1, 'yudao-server', 1001000002, '参数配置 key 重复', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5679, 1, 'yudao-server', 1001000003, '不能删除类型为系统内置的参数配置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5680, 1, 'yudao-server', 1001000004, '获取参数配置失败，原因：不允许获取不可见配置', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5681, 1, 'yudao-server', 1001001000, '定时任务不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5682, 1, 'yudao-server', 1001001001, '定时任务的处理器已经存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5683, 1, 'yudao-server', 1001001002, '只允许修改为开启或者关闭状态', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5684, 1, 'yudao-server', 1001001003, '定时任务已经处于该状态，无需修改', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5685, 1, 'yudao-server', 1001001004, '只有开启状态的任务，才可以修改', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5686, 1, 'yudao-server', 1001001005, 'CRON 表达式不正确', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5687, 1, 'yudao-server', 1001002000, 'API 错误日志不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5688, 1, 'yudao-server', 1001002001, 'API 错误日志已处理', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5689, 1, 'yudao-server', 1001003000, '文件路径已存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5690, 1, 'yudao-server', 1001003001, '文件不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5691, 1, 'yudao-server', 1001003002, '文件为空', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5692, 1, 'yudao-server', 1003001000, '表定义已经存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5693, 1, 'yudao-server', 1003001001, '导入的表不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5694, 1, 'yudao-server', 1003001002, '导入的字段不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5695, 1, 'yudao-server', 1003001004, '表定义不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5696, 1, 'yudao-server', 1003001005, '字段义不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5697, 1, 'yudao-server', 1003001006, '同步的字段不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5698, 1, 'yudao-server', 1003001007, '同步失败，不存在改变', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5699, 1, 'yudao-server', 1003001008, '数据库的表注释未填写', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5700, 1, 'yudao-server', 1003001009, '数据库的表字段({})注释未填写', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5701, 1, 'yudao-server', 1001005000, '测试示例不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5702, 1, 'yudao-server', 1001006000, '文件配置不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5703, 1, 'yudao-server', 1001006001, '该文件配置不允许删除，原因：它是主配置，删除会导致无法上传文件', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5704, 1, 'yudao-server', 1001007000, '数据源配置不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5705, 1, 'yudao-server', 1001007001, '数据源配置不正确，无法进行连接', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5706, 1, 'yudao-server', 1004001000, '用户不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5707, 1, 'yudao-server', 1004001001, '密码校验失败', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5708, 1, 'yudao-server', 1004003000, '登录失败，账号密码不正确', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5709, 1, 'yudao-server', 1004003001, '登录失败，账号被禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5710, 1, 'yudao-server', 1004003004, 'Token 已经过期', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5711, 1, 'yudao-server', 1004003005, '未绑定账号，需要进行绑定', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5712, 1, 'yudao-server', 1007000000, 'App 不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5713, 1, 'yudao-server', 1007000002, 'App 已经被禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5714, 1, 'yudao-server', 1007000003, '支付应用存在交易中的订单,无法删除', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5715, 1, 'yudao-server', 1007001000, '支付渠道的配置不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5716, 1, 'yudao-server', 1007001001, '支付渠道已经禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5717, 1, 'yudao-server', 1007001002, '支付渠道的客户端不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5718, 1, 'yudao-server', 1007001003, '支付渠道不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5719, 1, 'yudao-server', 1007001005, '已存在相同的渠道', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5720, 1, 'yudao-server', 1007001006, '微信渠道v2版本中商户密钥不可为空', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5721, 1, 'yudao-server', 1007001007, '微信渠道v3版本apiclient_key.pem不可为空', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5722, 1, 'yudao-server', 1007001008, '微信渠道v3版本中apiclient_cert.pem不可为空', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5723, 1, 'yudao-server', 1007001009, '渠道通知校验失败', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5724, 1, 'yudao-server', 1007002000, '支付订单不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5725, 1, 'yudao-server', 1007002001, '支付订单不处于待支付', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5726, 1, 'yudao-server', 1007002002, '支付订单不处于已支付', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5727, 1, 'yudao-server', 1007002003, '支付订单用户不正确', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5728, 1, 'yudao-server', 1007003000, '支付交易拓展单不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5729, 1, 'yudao-server', 1007003001, '支付交易拓展单不处于待支付', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5730, 1, 'yudao-server', 1007003002, '支付订单不处于已支付', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5731, 1, 'yudao-server', 1007006000, '退款金额超过订单可退款金额', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5732, 1, 'yudao-server', 1007006001, '订单已经全额退款', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5733, 1, 'yudao-server', 1007006002, '该订单的渠道订单为空', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5734, 1, 'yudao-server', 1007006003, '已经退款成功', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5735, 1, 'yudao-server', 1007006004, '支付退款单不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5736, 1, 'yudao-server', 1007004000, '支付商户信息不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5737, 1, 'yudao-server', 1007004001, '支付商户存在支付应用,无法删除', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5738, 1, 'yudao-server', 1002000000, '登录失败，账号密码不正确', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5739, 1, 'yudao-server', 1002000001, '登录失败，账号被禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5740, 1, 'yudao-server', 1002000003, '验证码不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5741, 1, 'yudao-server', 1002000004, '验证码不正确', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5742, 1, 'yudao-server', 1002000005, '未绑定账号，需要进行绑定', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5743, 1, 'yudao-server', 1002000006, 'Token 已经过期', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5744, 1, 'yudao-server', 1002000007, '手机号不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5745, 1, 'yudao-server', 1002001000, '已经存在该名字的菜单', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5746, 1, 'yudao-server', 1002001001, '父菜单不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5747, 1, 'yudao-server', 1002001002, '不能设置自己为父菜单', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5748, 1, 'yudao-server', 1002001003, '菜单不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5749, 1, 'yudao-server', 1002001004, '存在子菜单，无法删除', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5750, 1, 'yudao-server', 1002001005, '父菜单的类型必须是目录或者菜单', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5751, 1, 'yudao-server', 1002002000, '角色不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5752, 1, 'yudao-server', 1002002001, '已经存在名为【{}】的角色', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5753, 1, 'yudao-server', 1002002002, '已经存在编码为【{}】的角色', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5754, 1, 'yudao-server', 1002002003, '不能操作类型为系统内置的角色', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5755, 1, 'yudao-server', 1002002004, '名字为【{}】的角色已被禁用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5756, 1, 'yudao-server', 1002002005, '编码【{}】不能使用', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5757, 1, 'yudao-server', 1002003000, '用户账号已经存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5758, 1, 'yudao-server', 1002003001, '手机号已经存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5759, 1, 'yudao-server', 1002003002, '邮箱已经存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5760, 1, 'yudao-server', 1002003003, '用户不存在', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5761, 1, 'yudao-server', 1002003004, '导入用户数据不能为空！', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5762, 1, 'yudao-server', 1002003005, '用户密码校验失败', '', NULL, '2022-05-23 22:18:16', NULL, '2022-05-23 22:18:16', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5763, 1, 'yudao-server', 1002003006, '名字为【{}】的用户已被禁用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5764, 1, 'yudao-server', 1002003008, '创建用户失败，原因：超过租户最大租户配额({})！', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5765, 1, 'yudao-server', 1002004000, '已经存在该名字的部门', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5766, 1, 'yudao-server', 1002004001, '父级部门不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5767, 1, 'yudao-server', 1002004002, '当前部门不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5768, 1, 'yudao-server', 1002004003, '存在子部门，无法删除', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5769, 1, 'yudao-server', 1002004004, '不能设置自己为父部门', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5770, 1, 'yudao-server', 1002004005, '部门中存在员工，无法删除', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5771, 1, 'yudao-server', 1002004006, '部门不处于开启状态，不允许选择', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5772, 1, 'yudao-server', 1002004007, '不能设置自己的子部门为父部门', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5773, 1, 'yudao-server', 1002005000, '当前岗位不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5774, 1, 'yudao-server', 1002005001, '岗位({}) 不处于开启状态，不允许选择', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5775, 1, 'yudao-server', 1002005002, '已经存在该名字的岗位', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5776, 1, 'yudao-server', 1002005003, '已经存在该标识的岗位', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5777, 1, 'yudao-server', 1002006001, '当前字典类型不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5778, 1, 'yudao-server', 1002006002, '字典类型不处于开启状态，不允许选择', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5779, 1, 'yudao-server', 1002006003, '已经存在该名字的字典类型', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5780, 1, 'yudao-server', 1002006004, '已经存在该类型的字典类型', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5781, 1, 'yudao-server', 1002006005, '无法删除，该字典类型还有字典数据', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5782, 1, 'yudao-server', 1002007001, '当前字典数据不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5783, 1, 'yudao-server', 1002007002, '字典数据({})不处于开启状态，不允许选择', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5784, 1, 'yudao-server', 1002007003, '已经存在该值的字典数据', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5785, 1, 'yudao-server', 1002008001, '当前通知公告不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5786, 1, 'yudao-server', 1002011000, '短信渠道不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5787, 1, 'yudao-server', 1002011001, '短信渠道不处于开启状态，不允许选择', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5788, 1, 'yudao-server', 1002011002, '无法删除，该短信渠道还有短信模板', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5789, 1, 'yudao-server', 1002012000, '短信模板不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5790, 1, 'yudao-server', 1002012001, '已经存在编码为【{}】的短信模板', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5791, 1, 'yudao-server', 1002013000, '手机号不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5792, 1, 'yudao-server', 1002013001, '模板参数({})缺失', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5793, 1, 'yudao-server', 1002013002, '短信模板不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5794, 1, 'yudao-server', 1002014000, '验证码不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5795, 1, 'yudao-server', 1002014001, '验证码已过期', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5796, 1, 'yudao-server', 1002014002, '验证码已使用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5797, 1, 'yudao-server', 1002014003, '验证码不正确', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5798, 1, 'yudao-server', 1002014004, '超过每日短信发送数量', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5799, 1, 'yudao-server', 1002014005, '短信发送过于频率', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5800, 1, 'yudao-server', 1002014006, '手机号已被使用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5801, 1, 'yudao-server', 1002014007, '验证码未被使用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5802, 1, 'yudao-server', 1002015000, '租户不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5803, 1, 'yudao-server', 1002015001, '名字为【{}】的租户已被禁用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5804, 1, 'yudao-server', 1002015002, '名字为【{}】的租户已过期', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5805, 1, 'yudao-server', 1002015003, '系统租户不能进行修改、删除等操作！', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5806, 1, 'yudao-server', 1002016000, '租户套餐不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5807, 1, 'yudao-server', 1002016001, '租户正在使用该套餐，请给租户重新设置套餐后再尝试删除', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5808, 1, 'yudao-server', 1002016002, '名字为【{}】的租户套餐已被禁用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5809, 1, 'yudao-server', 1002017000, '错误码不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5810, 1, 'yudao-server', 1002017001, '已经存在编码为【{}】的错误码', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5811, 1, 'yudao-server', 1002018000, '社交授权失败，原因是：{}', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5812, 1, 'yudao-server', 1002018001, '社交解绑失败，非当前用户绑定', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5813, 1, 'yudao-server', 1002018002, '社交授权失败，找不到对应的用户', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5814, 1, 'yudao-server', 1002019000, '系统敏感词在所有标签中都不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5815, 1, 'yudao-server', 1002019001, '系统敏感词已在标签中存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5816, 1, 'yudao-server', 1002020000, 'OAuth2 客户端不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5817, 1, 'yudao-server', 1002020001, 'OAuth2 客户端编号已存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5818, 1, 'yudao-server', 1002020002, 'OAuth2 客户端已禁用', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5819, 1, 'yudao-server', 1002020003, '不支持该授权类型', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5820, 1, 'yudao-server', 1002020004, '授权范围过大', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5821, 1, 'yudao-server', 1002020005, '无效 redirect_uri: {}', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5822, 1, 'yudao-server', 1002020006, '无效 client_secret: {}', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5823, 1, 'yudao-server', 1002021000, 'client_id 不匹配', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5824, 1, 'yudao-server', 1002021001, 'redirect_uri 不匹配', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5825, 1, 'yudao-server', 1002021002, 'state 不匹配', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5826, 1, 'yudao-server', 1002021003, 'code 不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5827, 1, 'yudao-server', 1002022000, 'code 不存在', '', NULL, '2022-05-23 22:18:17', NULL, '2022-07-08 08:31:52', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5828, 1, 'yudao-server', 1002022000, 'code 已过期', '', NULL, '2022-05-23 22:18:17', NULL, '2022-05-23 22:18:17', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5829, 1, 'yudao-server', 1004004000, '用户收件地址不存在', '', NULL, '2022-05-29 11:07:14', NULL, '2022-05-29 11:07:14', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5830, 1, 'yudao-server', 1004004001, '没有该操作权限', '', NULL, '2022-05-29 11:07:14', NULL, '2022-05-29 11:07:14', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5831, 1, 'yudao-server', 1004003006, '获得手机号失败', '', NULL, '2022-05-29 23:30:37', NULL, '2022-05-29 23:30:37', b'0');
INSERT INTO `system_error_code` (`id`, `type`, `application_name`, `code`, `message`, `memo`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5832, 1, 'system-server', 1002022001, 'code 已过期', '', NULL, '2022-12-30 13:53:36', NULL, '2022-12-30 13:53:36', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_group
-- ----------------------------
DROP TABLE IF EXISTS `system_group`;
CREATE TABLE `system_group` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '描述',
  `status` tinyint NOT NULL COMMENT '状态',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户组';

-- ----------------------------
-- Records of system_group
-- ----------------------------
BEGIN;
INSERT INTO `system_group` (`id`, `name`, `description`, `status`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (1, '芋道', '好', 0, '', '2022-09-14 16:27:01', '', '2022-09-14 16:27:01', b'1', 0);
INSERT INTO `system_group` (`id`, `name`, `description`, `status`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (2, '小明', '<p>啊啊啊</p>', 0, '1', '2022-09-14 16:35:49', '1', '2022-09-14 16:35:49', b'0', 1);
COMMIT;

-- ----------------------------
-- Table structure for system_mail_account
-- ----------------------------
DROP TABLE IF EXISTS `system_mail_account`;
CREATE TABLE `system_mail_account` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `mail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮箱',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户名',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'SMTP 服务器域名',
  `port` int NOT NULL COMMENT 'SMTP 服务器端口',
  `ssl_enable` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否开启 SSL',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邮箱账号表';

-- ----------------------------
-- Records of system_mail_account
-- ----------------------------
BEGIN;
INSERT INTO `system_mail_account` (`id`, `mail`, `username`, `password`, `host`, `port`, `ssl_enable`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, '7684413@qq.com', '7684413@qq.com', '123457', '127.0.0.1', 8080, b'0', '1', '2023-01-25 17:39:52', '1', '2023-01-26 22:59:04', b'0');
INSERT INTO `system_mail_account` (`id`, `mail`, `username`, `password`, `host`, `port`, `ssl_enable`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, 'ydym_test@163.com', 'ydym_test@163.com', 'WBZTEINMIFVRYSOE', 'smtp.163.com', 465, b'1', '1', '2023-01-26 01:26:03', '1', '2023-01-26 01:26:03', b'0');
INSERT INTO `system_mail_account` (`id`, `mail`, `username`, `password`, `host`, `port`, `ssl_enable`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (3, '76854114@qq.com', '3335', '11234', 'yunai1.cn', 466, b'0', '1', '2023-01-27 15:06:38', '1', '2023-01-27 07:08:36', b'1');
COMMIT;

-- ----------------------------
-- Table structure for system_mail_log
-- ----------------------------
DROP TABLE IF EXISTS `system_mail_log`;
CREATE TABLE `system_mail_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `user_id` bigint DEFAULT NULL COMMENT '用户编号',
  `user_type` tinyint DEFAULT NULL COMMENT '用户类型',
  `to_mail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '接收邮箱地址',
  `account_id` bigint NOT NULL COMMENT '邮箱账号编号',
  `from_mail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送邮箱地址',
  `template_id` bigint NOT NULL COMMENT '模板编号',
  `template_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板编码',
  `template_nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '模版发送人名称',
  `template_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮件标题',
  `template_content` varchar(10240) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮件内容',
  `template_params` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮件参数',
  `send_status` tinyint NOT NULL DEFAULT '0' COMMENT '发送状态',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `send_message_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '发送返回的消息 ID',
  `send_exception` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '发送异常',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=354 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邮件日志表';

-- ----------------------------
-- Records of system_mail_log
-- ----------------------------
BEGIN;
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (347, NULL, 2, '7685413@qq.com', 1, '7684413@qq.com', 14, 'test_01', NULL, '一个标题', '<p>你是 value01 吗？</p><p><br></p><p>是的话，赶紧 value02 一下！</p>', '{\"key01\":\"value01\",\"key02\":\"value02\"}', 20, '2023-01-26 09:05:37', NULL, 'ConnectException: Connection refused (Connection refused)', '1', '2023-01-26 09:05:37', NULL, '2023-01-26 09:05:37', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (348, NULL, 2, '7685413@qq.com', 1, '7684413@qq.com', 14, 'test_01', NULL, '一个标题', '<p>你是 value01 吗？</p><p><br></p><p>是的话，赶紧 value02 一下！</p>', '{\"key01\":\"value01\",\"key02\":\"value02\"}', 20, '2023-01-26 09:07:50', NULL, 'ConnectException: Connection refused (Connection refused)', '1', '2023-01-26 09:07:27', NULL, '2023-01-26 09:07:50', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (349, NULL, 2, '7685413@qq.com', 2, 'ydym_test@163.com', 14, 'test_01', NULL, '一个标题', '<p>你是 value01 吗？</p><p><br></p><p>是的话，赶紧 value02 一下！</p>', '{\"key01\":\"value01\",\"key02\":\"value02\"}', 10, '2023-01-26 09:08:50', '<590091956.7.1674695329137@[192.168.31.185]>', NULL, '1', '2023-01-26 09:08:49', NULL, '2023-01-26 09:08:50', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (350, NULL, 2, '7685413@qq.com', 2, 'ydym_test@163.com', 14, 'test_01', NULL, '一个标题', '<p>你是 aoteman 吗？</p><p><br></p><p>是的话，赶紧 土豆 一下！</p>', '{\"key01\":\"aoteman\",\"key02\":\"土豆\"}', 10, '2023-01-26 23:30:51', '<468833078.1.1674747048822@[192.168.31.238]>', NULL, '1', '2023-01-26 23:30:49', NULL, '2023-01-26 23:30:51', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (351, NULL, 2, '7685413@qq.com', 2, 'ydym_test@163.com', 14, 'test_01', '芋艿', '一个标题', '<p>你是 奥特曼 吗？</p><p><br></p><p>是的话，赶紧 写代码 一下！</p>', '{\"key01\":\"奥特曼\",\"key02\":\"写代码\"}', 10, '2023-01-27 12:36:11', '<664060010.1.1674794168918@[192.168.24.165]>', NULL, '1', '2023-01-27 12:36:09', NULL, '2023-01-27 12:36:11', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (352, NULL, 2, '7685413@qq.com', 2, 'ydym_test@163.com', 14, 'test_01', '芋艿', '一个标题', '<p>你是 奥特曼 吗？</p><p><br></p><p>是的话，赶紧 变身 一下！</p>', '{\"key01\":\"奥特曼\",\"key02\":\"变身\"}', 10, '2023-01-27 12:42:13', '<1293807391.3.1674794529066@[192.168.24.165]>', NULL, '1', '2023-01-27 12:42:09', NULL, '2023-01-27 12:42:13', b'0');
INSERT INTO `system_mail_log` (`id`, `user_id`, `user_type`, `to_mail`, `account_id`, `from_mail`, `template_id`, `template_code`, `template_nickname`, `template_title`, `template_content`, `template_params`, `send_status`, `send_time`, `send_message_id`, `send_exception`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (353, NULL, 2, '7685413@qq.com', 2, 'ydym_test@163.com', 14, 'test_01', '芋艿', '一个标题', '<p>你是 aoteman 吗？</p><p><br></p><p>是的话，赶紧 binshen 一下！</p>', '{\"key01\":\"aoteman\",\"key02\":\"binshen\"}', 10, '2023-01-27 16:57:19', '<1627322404.5.1674809837932@[192.168.24.165]>', NULL, '1', '2023-01-27 16:57:18', NULL, '2023-01-27 16:57:19', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_mail_template
-- ----------------------------
DROP TABLE IF EXISTS `system_mail_template`;
CREATE TABLE `system_mail_template` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板名称',
  `code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板编码',
  `account_id` bigint NOT NULL COMMENT '发送的邮箱账号编号',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '发送人名称',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板标题',
  `content` varchar(10240) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板内容',
  `params` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数数组',
  `status` tinyint NOT NULL COMMENT '开启状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邮件模版表';

-- ----------------------------
-- Records of system_mail_template
-- ----------------------------
BEGIN;
INSERT INTO `system_mail_template` (`id`, `name`, `code`, `account_id`, `nickname`, `title`, `content`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (13, '后台用户短信登录', 'admin-sms-login', 1, '奥特曼', '你猜我猜', '<p>您的验证码是{code}，名字是{name}</p>', '[\"code\",\"name\"]', 0, '3', '1', '2021-10-11 08:10:00', '1', '2023-01-26 23:22:05', b'0');
INSERT INTO `system_mail_template` (`id`, `name`, `code`, `account_id`, `nickname`, `title`, `content`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (14, '测试模版', 'test_01', 2, '芋艿', '一个标题', '<p>你是 {key01} 吗？</p><p><br></p><p>是的话，赶紧 {key02} 一下！</p>', '[\"key01\",\"key02\"]', 0, NULL, '1', '2023-01-26 01:27:40', '1', '2023-01-27 10:32:16', b'0');
INSERT INTO `system_mail_template` (`id`, `name`, `code`, `account_id`, `nickname`, `title`, `content`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (15, '3', '2', 2, '7', '4', '<p>45</p>', '[]', 1, '80', '1', '2023-01-27 15:50:35', '1', '2023-01-27 16:34:49', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_menu
-- ----------------------------
DROP TABLE IF EXISTS `system_menu`;
CREATE TABLE `system_menu` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '菜单名称',
  `permission` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '权限标识',
  `type` tinyint NOT NULL COMMENT '菜单类型',
  `sort` int NOT NULL DEFAULT '0' COMMENT '显示顺序',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父菜单ID',
  `path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '路由地址',
  `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '#' COMMENT '菜单图标',
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '组件路径',
  `component_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '组件名',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '菜单状态',
  `visible` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否可见',
  `keep_alive` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否缓存',
  `always_show` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否总是显示',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='菜单权限表';

-- ----------------------------
-- Records of system_menu
-- ----------------------------
BEGIN;
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, '系统管理', '', 1, 10, 0, '/system', 'system', NULL, NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, '基础设施', '', 1, 20, 0, '/infra', 'monitor', NULL, NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5, 'OA 示例', '', 1, 40, 1185, 'oa', 'people', NULL, NULL, 0, b'1', b'1', b'1', 'admin', '2021-09-20 16:26:19', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (100, '用户管理', 'system:user:list', 2, 1, 1, 'user', 'user', 'system/user/index', 'User', 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2023-02-10 13:50:21', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (101, '角色管理', '', 2, 2, 1, 'role', 'peoples', 'system/role/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (102, '菜单管理', '', 2, 3, 1, 'menu', 'tree-table', 'system/menu/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (103, '部门管理', '', 2, 4, 1, 'dept', 'tree', 'system/dept/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (104, '岗位管理', '', 2, 5, 1, 'post', 'post', 'system/post/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (105, '字典管理', '', 2, 6, 1, 'dict', 'dict', 'system/dict/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (106, '配置管理', '', 2, 6, 2, 'config', 'edit', 'infra/config/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (107, '通知公告', '', 2, 8, 1, 'notice', 'message', 'system/notice/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (108, '审计日志', '', 1, 9, 1, 'log', 'log', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (109, '令牌管理', '', 2, 2, 1261, 'token', 'online', 'system/oauth2/token/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-05-11 23:31:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (110, '定时任务', '', 2, 12, 2, 'job', 'job', 'infra/job/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (111, 'MySQL 监控', '', 2, 9, 2, 'druid', 'druid', 'infra/druid/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (112, 'Java 监控', '', 2, 11, 2, 'admin-server', 'server', 'infra/server/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (113, 'Redis 监控', '', 2, 10, 2, 'redis', 'redis', 'infra/redis/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (114, '表单构建', 'infra:build:list', 2, 2, 2, 'build', 'build', 'infra/build/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (115, '代码生成', 'infra:codegen:query', 2, 1, 2, 'codegen', 'code', 'infra/codegen/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (116, '系统接口', 'infra:swagger:list', 2, 3, 2, 'swagger', 'swagger', 'infra/swagger/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (500, '操作日志', '', 2, 1, 108, 'operate-log', 'form', 'system/operatelog/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (501, '登录日志', '', 2, 2, 108, 'login-log', 'logininfor', 'system/loginlog/index', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1001, '用户查询', 'system:user:query', 3, 1, 100, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1002, '用户新增', 'system:user:create', 3, 2, 100, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1003, '用户修改', 'system:user:update', 3, 3, 100, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1004, '用户删除', 'system:user:delete', 3, 4, 100, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1005, '用户导出', 'system:user:export', 3, 5, 100, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1006, '用户导入', 'system:user:import', 3, 6, 100, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1007, '重置密码', 'system:user:update-password', 3, 7, 100, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1008, '角色查询', 'system:role:query', 3, 1, 101, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1009, '角色新增', 'system:role:create', 3, 2, 101, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1010, '角色修改', 'system:role:update', 3, 3, 101, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1011, '角色删除', 'system:role:delete', 3, 4, 101, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1012, '角色导出', 'system:role:export', 3, 5, 101, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1013, '菜单查询', 'system:menu:query', 3, 1, 102, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1014, '菜单新增', 'system:menu:create', 3, 2, 102, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1015, '菜单修改', 'system:menu:update', 3, 3, 102, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1016, '菜单删除', 'system:menu:delete', 3, 4, 102, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1017, '部门查询', 'system:dept:query', 3, 1, 103, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1018, '部门新增', 'system:dept:create', 3, 2, 103, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1019, '部门修改', 'system:dept:update', 3, 3, 103, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1020, '部门删除', 'system:dept:delete', 3, 4, 103, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1021, '岗位查询', 'system:post:query', 3, 1, 104, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1022, '岗位新增', 'system:post:create', 3, 2, 104, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1023, '岗位修改', 'system:post:update', 3, 3, 104, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1024, '岗位删除', 'system:post:delete', 3, 4, 104, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1025, '岗位导出', 'system:post:export', 3, 5, 104, '', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1026, '字典查询', 'system:dict:query', 3, 1, 105, '#', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1027, '字典新增', 'system:dict:create', 3, 2, 105, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1028, '字典修改', 'system:dict:update', 3, 3, 105, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1029, '字典删除', 'system:dict:delete', 3, 4, 105, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1030, '字典导出', 'system:dict:export', 3, 5, 105, '#', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1031, '配置查询', 'infra:config:query', 3, 1, 106, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1032, '配置新增', 'infra:config:create', 3, 2, 106, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1033, '配置修改', 'infra:config:update', 3, 3, 106, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1034, '配置删除', 'infra:config:delete', 3, 4, 106, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1035, '配置导出', 'infra:config:export', 3, 5, 106, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1036, '公告查询', 'system:notice:query', 3, 1, 107, '#', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1037, '公告新增', 'system:notice:create', 3, 2, 107, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1038, '公告修改', 'system:notice:update', 3, 3, 107, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1039, '公告删除', 'system:notice:delete', 3, 4, 107, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1040, '操作查询', 'system:operate-log:query', 3, 1, 500, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1042, '日志导出', 'system:operate-log:export', 3, 2, 500, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1043, '登录查询', 'system:login-log:query', 3, 1, 501, '#', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1045, '日志导出', 'system:login-log:export', 3, 3, 501, '#', '#', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1046, '令牌列表', 'system:oauth2-token:page', 3, 1, 109, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-05-09 23:54:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1048, '令牌删除', 'system:oauth2-token:delete', 3, 2, 109, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-05-09 23:54:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1050, '任务新增', 'infra:job:create', 3, 2, 110, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1051, '任务修改', 'infra:job:update', 3, 3, 110, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1052, '任务删除', 'infra:job:delete', 3, 4, 110, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1053, '状态修改', 'infra:job:update', 3, 5, 110, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1054, '任务导出', 'infra:job:export', 3, 7, 110, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1056, '生成修改', 'infra:codegen:update', 3, 2, 115, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1057, '生成删除', 'infra:codegen:delete', 3, 3, 115, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1058, '导入代码', 'infra:codegen:create', 3, 2, 115, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1059, '预览代码', 'infra:codegen:preview', 3, 4, 115, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1060, '生成代码', 'infra:codegen:download', 3, 5, 115, '', '', '', NULL, 0, b'1', b'1', b'1', 'admin', '2021-01-05 17:03:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1063, '设置角色菜单权限', 'system:permission:assign-role-menu', 3, 6, 101, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-01-06 17:53:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1064, '设置角色数据权限', 'system:permission:assign-role-data-scope', 3, 7, 101, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-01-06 17:56:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1065, '设置用户角色', 'system:permission:assign-user-role', 3, 8, 101, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-01-07 10:23:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1066, '获得 Redis 监控信息', 'infra:redis:get-monitor-info', 3, 1, 113, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-01-26 01:02:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1067, '获得 Redis Key 列表', 'infra:redis:get-key-list', 3, 2, 113, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-01-26 01:02:52', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1070, '代码生成示例', 'infra:test-demo:query', 2, 1, 2, 'test-demo', 'validCode', 'infra/testDemo/index', NULL, 0, b'1', b'1', b'1', '', '2021-02-06 12:42:49', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1071, '测试示例表创建', 'infra:test-demo:create', 3, 1, 1070, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-06 12:42:49', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1072, '测试示例表更新', 'infra:test-demo:update', 3, 2, 1070, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-06 12:42:49', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1073, '测试示例表删除', 'infra:test-demo:delete', 3, 3, 1070, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-06 12:42:49', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1074, '测试示例表导出', 'infra:test-demo:export', 3, 4, 1070, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-06 12:42:49', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1075, '任务触发', 'infra:job:trigger', 3, 8, 110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-07 13:03:10', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1076, '数据库文档', '', 2, 4, 2, 'db-doc', 'table', 'infra/dbDoc/index', NULL, 0, b'1', b'1', b'1', '', '2021-02-08 01:41:47', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1077, '监控平台', '', 2, 13, 2, 'skywalking', 'eye-open', 'infra/skywalking/index', NULL, 0, b'1', b'1', b'1', '', '2021-02-08 20:41:31', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1078, '访问日志', '', 2, 1, 1083, 'api-access-log', 'log', 'infra/apiAccessLog/index', NULL, 0, b'1', b'1', b'1', '', '2021-02-26 01:32:59', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1082, '日志导出', 'infra:api-access-log:export', 3, 2, 1078, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-26 01:32:59', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1083, 'API 日志', '', 2, 8, 2, 'log', 'log', NULL, NULL, 0, b'1', b'1', b'1', '', '2021-02-26 02:18:24', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1084, '错误日志', 'infra:api-error-log:query', 2, 2, 1083, 'api-error-log', 'log', 'infra/apiErrorLog/index', NULL, 0, b'1', b'1', b'1', '', '2021-02-26 07:53:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1085, '日志处理', 'infra:api-error-log:update-status', 3, 2, 1084, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-26 07:53:20', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1086, '日志导出', 'infra:api-error-log:export', 3, 3, 1084, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-02-26 07:53:20', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1087, '任务查询', 'infra:job:query', 3, 1, 110, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-03-10 01:26:19', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1088, '日志查询', 'infra:api-access-log:query', 3, 1, 1078, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-03-10 01:28:04', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1089, '日志查询', 'infra:api-error-log:query', 3, 1, 1084, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-03-10 01:29:09', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1090, '文件列表', '', 2, 5, 1243, 'file', 'upload', 'infra/file/index', NULL, 0, b'1', b'1', b'1', '', '2021-03-12 20:16:20', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1091, '文件查询', 'infra:file:query', 3, 1, 1090, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-03-12 20:16:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1092, '文件删除', 'infra:file:delete', 3, 4, 1090, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-03-12 20:16:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1093, '短信管理', '', 1, 11, 1, 'sms', 'validCode', NULL, NULL, 0, b'1', b'1', b'1', '1', '2021-04-05 01:10:16', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1094, '短信渠道', '', 2, 0, 1093, 'sms-channel', 'phone', 'system/sms/smsChannel', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 11:07:15', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1095, '短信渠道查询', 'system:sms-channel:query', 3, 1, 1094, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 11:07:15', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1096, '短信渠道创建', 'system:sms-channel:create', 3, 2, 1094, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 11:07:15', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1097, '短信渠道更新', 'system:sms-channel:update', 3, 3, 1094, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 11:07:15', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1098, '短信渠道删除', 'system:sms-channel:delete', 3, 4, 1094, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 11:07:15', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1100, '短信模板', '', 2, 1, 1093, 'sms-template', 'phone', 'system/sms/smsTemplate', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1101, '短信模板查询', 'system:sms-template:query', 3, 1, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1102, '短信模板创建', 'system:sms-template:create', 3, 2, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1103, '短信模板更新', 'system:sms-template:update', 3, 3, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1104, '短信模板删除', 'system:sms-template:delete', 3, 4, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1105, '短信模板导出', 'system:sms-template:export', 3, 5, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-01 17:35:17', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1106, '发送测试短信', 'system:sms-template:send-sms', 3, 6, 1100, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-04-11 00:26:40', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1107, '短信日志', '', 2, 2, 1093, 'sms-log', 'phone', 'system/sms/smsLog', NULL, 0, b'1', b'1', b'1', '', '2021-04-11 08:37:05', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1108, '短信日志查询', 'system:sms-log:query', 3, 1, 1107, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-11 08:37:05', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1109, '短信日志导出', 'system:sms-log:export', 3, 5, 1107, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-11 08:37:05', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1110, '错误码管理', '', 2, 12, 1, 'error-code', 'code', 'system/errorCode/index', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1111, '错误码查询', 'system:error-code:query', 3, 1, 1110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1112, '错误码创建', 'system:error-code:create', 3, 2, 1110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1113, '错误码更新', 'system:error-code:update', 3, 3, 1110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1114, '错误码删除', 'system:error-code:delete', 3, 4, 1110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1115, '错误码导出', 'system:error-code:export', 3, 5, 1110, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-04-13 21:46:42', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1117, '支付管理', '', 1, 30, 0, '/pay', 'money', NULL, NULL, 0, b'1', b'1', b'1', '1', '2021-12-25 16:43:41', '1', '2022-12-10 16:33:19', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1118, '请假查询', '', 2, 0, 5, 'leave', 'user', 'bpm/oa/leave/index', NULL, 0, b'1', b'1', b'1', '', '2021-09-20 08:51:03', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1119, '请假申请查询', 'bpm:oa-leave:query', 3, 1, 1118, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-09-20 08:51:03', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1120, '请假申请创建', 'bpm:oa-leave:create', 3, 2, 1118, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-09-20 08:51:03', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1126, '应用信息', '', 2, 1, 1117, 'app', 'table', 'pay/app/index', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:30', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1127, '支付应用信息查询', 'pay:app:query', 3, 1, 1126, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1128, '支付应用信息创建', 'pay:app:create', 3, 2, 1126, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1129, '支付应用信息更新', 'pay:app:update', 3, 3, 1126, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1130, '支付应用信息删除', 'pay:app:delete', 3, 4, 1126, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1131, '支付应用信息导出', 'pay:app:export', 3, 5, 1126, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:31', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1132, '秘钥解析', 'pay:channel:parsing', 3, 6, 1129, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-11-08 15:15:47', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1133, '支付商户信息查询', 'pay:merchant:query', 3, 1, 1132, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:41', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1134, '支付商户信息创建', 'pay:merchant:create', 3, 2, 1132, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:41', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1135, '支付商户信息更新', 'pay:merchant:update', 3, 3, 1132, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:41', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1136, '支付商户信息删除', 'pay:merchant:delete', 3, 4, 1132, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:41', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1137, '支付商户信息导出', 'pay:merchant:export', 3, 5, 1132, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-11-10 01:13:41', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1138, '租户列表', '', 2, 0, 1224, 'list', 'peoples', 'system/tenant/index', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:43', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1139, '租户查询', 'system:tenant:query', 3, 1, 1138, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1140, '租户创建', 'system:tenant:create', 3, 2, 1138, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1141, '租户更新', 'system:tenant:update', 3, 3, 1138, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1142, '租户删除', 'system:tenant:delete', 3, 4, 1138, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1143, '租户导出', 'system:tenant:export', 3, 5, 1138, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-14 12:31:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1150, '秘钥解析', '', 3, 6, 1129, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2021-11-08 15:15:47', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1161, '退款订单', '', 2, 3, 1117, 'refund', 'order', 'pay/refund/index', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1162, '退款订单查询', 'pay:refund:query', 3, 1, 1161, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1163, '退款订单创建', 'pay:refund:create', 3, 2, 1161, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1164, '退款订单更新', 'pay:refund:update', 3, 3, 1161, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1165, '退款订单删除', 'pay:refund:delete', 3, 4, 1161, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1166, '退款订单导出', 'pay:refund:export', 3, 5, 1161, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:29:07', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1173, '支付订单', '', 2, 2, 1117, 'order', 'pay', 'pay/order/index', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1174, '支付订单查询', 'pay:order:query', 3, 1, 1173, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1175, '支付订单创建', 'pay:order:create', 3, 2, 1173, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1176, '支付订单更新', 'pay:order:update', 3, 3, 1173, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1177, '支付订单删除', 'pay:order:delete', 3, 4, 1173, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1178, '支付订单导出', 'pay:order:export', 3, 5, 1173, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 08:49:43', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1179, '商户信息', '', 2, 0, 1117, 'merchant', 'merchant', 'pay/merchant/index', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1180, '支付商户信息查询', 'pay:merchant:query', 3, 1, 1179, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1181, '支付商户信息创建', 'pay:merchant:create', 3, 2, 1179, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1182, '支付商户信息更新', 'pay:merchant:update', 3, 3, 1179, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1183, '支付商户信息删除', '', 3, 4, 1179, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1184, '支付商户信息导出', 'pay:merchant:export', 3, 5, 1179, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-25 09:01:44', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1185, '工作流程', '', 1, 50, 0, '/bpm', 'tool', NULL, NULL, 0, b'1', b'1', b'1', '1', '2021-12-30 20:26:36', '103', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1186, '流程管理', '', 1, 10, 1185, 'manager', 'nested', NULL, NULL, 0, b'1', b'1', b'1', '1', '2021-12-30 20:28:30', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1187, '流程表单', '', 2, 0, 1186, 'form', 'form', 'bpm/form/index', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1188, '表单查询', 'bpm:form:query', 3, 1, 1187, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1189, '表单创建', 'bpm:form:create', 3, 2, 1187, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1190, '表单更新', 'bpm:form:update', 3, 3, 1187, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1191, '表单删除', 'bpm:form:delete', 3, 4, 1187, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1192, '表单导出', 'bpm:form:export', 3, 5, 1187, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2021-12-30 12:38:22', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1193, '流程模型', '', 2, 5, 1186, 'model', 'guide', 'bpm/model/index', NULL, 0, b'1', b'1', b'1', '1', '2021-12-31 23:24:58', '103', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1194, '模型查询', 'bpm:model:query', 3, 1, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:01:10', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1195, '模型创建', 'bpm:model:create', 3, 2, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:01:24', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1196, '模型导入', 'bpm:model:import', 3, 3, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:01:35', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1197, '模型更新', 'bpm:model:update', 3, 4, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:02:28', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1198, '模型删除', 'bpm:model:delete', 3, 5, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:02:43', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1199, '模型发布', 'bpm:model:deploy', 3, 6, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-03 19:03:24', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1200, '任务管理', '', 1, 20, 1185, 'task', 'cascader', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-01-07 23:51:48', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1201, '我的流程', '', 2, 0, 1200, 'my', 'people', 'bpm/processInstance/index', NULL, 0, b'1', b'1', b'1', '', '2022-01-07 15:53:44', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1202, '流程实例的查询', 'bpm:process-instance:query', 3, 1, 1201, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-01-07 15:53:44', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1207, '待办任务', '', 2, 10, 1200, 'todo', 'eye-open', 'bpm/task/todo', NULL, 0, b'1', b'1', b'1', '1', '2022-01-08 10:33:37', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1208, '已办任务', '', 2, 20, 1200, 'done', 'eye', 'bpm/task/done', NULL, 0, b'1', b'1', b'1', '1', '2022-01-08 10:34:13', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1209, '用户分组', '', 2, 2, 1186, 'user-group', 'people', 'bpm/group/index', NULL, 0, b'1', b'1', b'1', '', '2022-01-14 02:14:20', '103', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1210, '用户组查询', 'bpm:user-group:query', 3, 1, 1209, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-01-14 02:14:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1211, '用户组创建', 'bpm:user-group:create', 3, 2, 1209, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-01-14 02:14:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1212, '用户组更新', 'bpm:user-group:update', 3, 3, 1209, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-01-14 02:14:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1213, '用户组删除', 'bpm:user-group:delete', 3, 4, 1209, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-01-14 02:14:20', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1215, '流程定义查询', 'bpm:process-definition:query', 3, 10, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:21:43', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1216, '流程任务分配规则查询', 'bpm:task-assign-rule:query', 3, 20, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:26:53', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1217, '流程任务分配规则创建', 'bpm:task-assign-rule:create', 3, 21, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:28:15', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1218, '流程任务分配规则更新', 'bpm:task-assign-rule:update', 3, 22, 1193, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:28:41', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1219, '流程实例的创建', 'bpm:process-instance:create', 3, 2, 1201, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:36:15', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1220, '流程实例的取消', 'bpm:process-instance:cancel', 3, 3, 1201, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:36:33', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1221, '流程任务的查询', 'bpm:task:query', 3, 1, 1207, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:38:52', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1222, '流程任务的更新', 'bpm:task:update', 3, 2, 1207, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-01-23 00:39:24', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1224, '租户管理', '', 2, 0, 1, 'tenant', 'peoples', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-02-20 01:41:13', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1225, '租户套餐', '', 2, 0, 1224, 'package', 'eye', 'system/tenantPackage/index', NULL, 0, b'1', b'1', b'1', '', '2022-02-19 17:44:06', '1', '2022-04-21 01:21:25', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1226, '租户套餐查询', 'system:tenant-package:query', 3, 1, 1225, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-02-19 17:44:06', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1227, '租户套餐创建', 'system:tenant-package:create', 3, 2, 1225, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-02-19 17:44:06', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1228, '租户套餐更新', 'system:tenant-package:update', 3, 3, 1225, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-02-19 17:44:06', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1229, '租户套餐删除', 'system:tenant-package:delete', 3, 4, 1225, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-02-19 17:44:06', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1237, '文件配置', '', 2, 0, 1243, 'file-config', 'config', 'infra/fileConfig/index', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1238, '文件配置查询', 'infra:file-config:query', 3, 1, 1237, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1239, '文件配置创建', 'infra:file-config:create', 3, 2, 1237, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1240, '文件配置更新', 'infra:file-config:update', 3, 3, 1237, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1241, '文件配置删除', 'infra:file-config:delete', 3, 4, 1237, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1242, '文件配置导出', 'infra:file-config:export', 3, 5, 1237, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-03-15 14:35:28', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1243, '文件管理', '', 2, 5, 2, 'file', 'download', NULL, '', 0, b'1', b'1', b'1', '1', '2022-03-16 23:47:40', '1', '2023-02-10 13:47:46', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1247, '敏感词管理', '', 2, 13, 1, 'sensitive-word', 'education', 'system/sensitiveWord/index', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '1', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1248, '敏感词查询', 'system:sensitive-word:query', 3, 1, 1247, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1249, '敏感词创建', 'system:sensitive-word:create', 3, 2, 1247, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1250, '敏感词更新', 'system:sensitive-word:update', 3, 3, 1247, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1251, '敏感词删除', 'system:sensitive-word:delete', 3, 4, 1247, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1252, '敏感词导出', 'system:sensitive-word:export', 3, 5, 1247, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-07 16:55:03', '', '2022-04-20 17:03:10', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1254, '作者动态', '', 1, 0, 0, 'https://www.iocoder.cn', 'people', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-04-23 01:03:15', '1', '2023-02-28 00:38:16', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1255, '数据源配置', '', 2, 1, 2, 'data-source-config', 'rate', 'infra/dataSourceConfig/index', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '1', '2022-04-27 22:42:06', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1256, '数据源配置查询', 'infra:data-source-config:query', 3, 1, 1255, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '', '2022-04-27 14:37:32', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1257, '数据源配置创建', 'infra:data-source-config:create', 3, 2, 1255, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '', '2022-04-27 14:37:32', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1258, '数据源配置更新', 'infra:data-source-config:update', 3, 3, 1255, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '', '2022-04-27 14:37:32', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1259, '数据源配置删除', 'infra:data-source-config:delete', 3, 4, 1255, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '', '2022-04-27 14:37:32', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1260, '数据源配置导出', 'infra:data-source-config:export', 3, 5, 1255, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-04-27 14:37:32', '', '2022-04-27 14:37:32', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1261, 'OAuth 2.0', '', 1, 10, 1, 'oauth2', 'people', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-05-09 23:38:17', '1', '2022-05-11 23:51:46', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1263, '应用管理', '', 2, 0, 1261, 'oauth2/application', 'tool', 'system/oauth2/client/index', NULL, 0, b'1', b'1', b'1', '', '2022-05-10 16:26:33', '1', '2022-05-11 23:31:36', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1264, '客户端查询', 'system:oauth2-client:query', 3, 1, 1263, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-05-10 16:26:33', '1', '2022-05-11 00:31:06', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1265, '客户端创建', 'system:oauth2-client:create', 3, 2, 1263, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-05-10 16:26:33', '1', '2022-05-11 00:31:23', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1266, '客户端更新', 'system:oauth2-client:update', 3, 3, 1263, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-05-10 16:26:33', '1', '2022-05-11 00:31:28', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1267, '客户端删除', 'system:oauth2-client:delete', 3, 4, 1263, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-05-10 16:26:33', '1', '2022-05-11 00:31:33', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1281, '报表管理', '', 1, 40, 0, '/report', 'chart', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-07-10 20:22:15', '1', '2023-02-07 17:16:40', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1282, '报表设计器', '', 2, 1, 1281, 'jimu-report', 'example', 'report/jmreport/index', NULL, 0, b'1', b'1', b'1', '1', '2022-07-10 20:26:36', '1', '2023-02-07 17:15:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2000, '商品中心', '', 1, 60, 0, '/product', 'merchant', NULL, NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '1', '2022-07-30 22:26:19', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2002, '商品分类', '', 2, 2, 2000, 'category', 'dict', 'mall/product/category/index', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '1', '2022-07-30 22:23:37', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2003, '分类查询', 'product:category:query', 3, 1, 2002, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '', '2022-07-29 15:53:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2004, '分类创建', 'product:category:create', 3, 2, 2002, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '', '2022-07-29 15:53:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2005, '分类更新', 'product:category:update', 3, 3, 2002, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '', '2022-07-29 15:53:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2006, '分类删除', 'product:category:delete', 3, 4, 2002, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '', '2022-07-29 15:53:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2007, '分类导出', 'product:category:export', 3, 5, 2002, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-29 15:53:53', '', '2022-07-30 13:52:13', b'1');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2008, '商品品牌', '', 2, 3, 2000, 'brand', 'dashboard', 'mall/product/brand/index', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '1', '2022-10-24 22:29:30', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2009, '品牌查询', 'product:brand:query', 3, 1, 2008, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '', '2022-07-30 13:52:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2010, '品牌创建', 'product:brand:create', 3, 2, 2008, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '', '2022-07-30 13:52:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2011, '品牌更新', 'product:brand:update', 3, 3, 2008, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '', '2022-07-30 13:52:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2012, '品牌删除', 'product:brand:delete', 3, 4, 2008, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '', '2022-07-30 13:52:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2013, '品牌导出', 'product:brand:export', 3, 5, 2008, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 13:52:44', '', '2022-07-30 14:15:00', b'1');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2014, '商品列表', '', 2, 1, 2000, 'spu', 'list', 'mall/product/spu/index', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 14:22:58', '1', '2022-10-24 22:29:25', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2015, '商品查询', 'product:spu:query', 3, 1, 2014, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 14:22:58', '', '2022-07-30 14:22:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2016, '商品创建', 'product:spu:create', 3, 2, 2014, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 14:22:58', '', '2022-07-30 14:22:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2017, '商品更新', 'product:spu:update', 3, 3, 2014, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 14:22:58', '', '2022-07-30 14:22:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2018, '商品删除', 'product:spu:delete', 3, 4, 2014, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-07-30 14:22:58', '', '2022-07-30 14:22:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2019, '商品属性', '', 2, 3, 2000, 'property', 'eye', 'mall/product/property/index', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:55:35', '1', '2022-12-12 20:58:06', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2020, '规格查询', 'product:property:query', 3, 1, 2019, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:55:35', '', '2022-12-12 20:26:24', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2021, '规格创建', 'product:property:create', 3, 2, 2019, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:55:35', '', '2022-12-12 20:26:30', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2022, '规格更新', 'product:property:update', 3, 3, 2019, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:55:35', '', '2022-12-12 20:26:33', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2023, '规格删除', 'product:property:delete', 3, 4, 2019, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:55:35', '', '2022-12-12 20:26:37', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2025, 'Banner管理', '', 2, 100, 2000, 'banner', '', 'mall/market/banner/index', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:56:14', '1', '2022-10-24 22:29:39', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2026, 'Banner查询', 'market:banner:query', 3, 1, 2025, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:56:14', '', '2022-08-01 14:56:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2027, 'Banner创建', 'market:banner:create', 3, 2, 2025, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:56:14', '', '2022-08-01 14:56:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2028, 'Banner更新', 'market:banner:update', 3, 3, 2025, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:56:14', '', '2022-08-01 14:56:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2029, 'Banner删除', 'market:banner:delete', 3, 4, 2025, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-08-01 14:56:14', '', '2022-08-01 14:56:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2030, '营销中心', '', 1, 70, 0, '/promotion', 'rate', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-10-31 21:25:09', '1', '2022-10-31 21:25:09', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2031, '优惠劵', '', 1, 1, 2030, 'coupon-template', 'number', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-10-31 21:27:55', '1', '2022-10-31 21:23:11', b'1');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2032, '优惠劵', '', 2, 2, 2030, 'coupon-template', 'textarea', 'mall/promotion/couponTemplate/index', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '1', '2022-11-05 12:27:34', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2033, '优惠劵模板查询', 'promotion:coupon-template:query', 3, 1, 2032, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '', '2022-10-31 22:27:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2034, '优惠劵模板创建', 'promotion:coupon-template:create', 3, 2, 2032, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '', '2022-10-31 22:27:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2035, '优惠劵模板更新', 'promotion:coupon-template:update', 3, 3, 2032, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '', '2022-10-31 22:27:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2036, '优惠劵模板删除', 'promotion:coupon-template:delete', 3, 4, 2032, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '', '2022-10-31 22:27:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2037, '优惠劵模板导出', 'promotion:coupon-template:export', 3, 5, 2032, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-10-31 22:27:14', '', '2022-11-03 23:23:08', b'1');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2038, '会员优惠劵', '', 2, 2, 2030, 'coupon', '', 'mall/promotion/coupon/index', NULL, 0, b'0', b'1', b'1', '', '2022-11-03 23:21:31', '1', '2022-11-05 12:27:45', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2039, '优惠劵查询', 'promotion:coupon:query', 3, 1, 2038, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-03 23:21:31', '', '2022-11-03 23:21:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2040, '优惠劵删除', 'promotion:coupon:delete', 3, 4, 2038, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-03 23:21:31', '', '2022-11-03 23:21:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2041, '满减送活动', '', 2, 10, 2030, 'reward-activity', 'radio', 'mall/promotion/rewardActivity/index', NULL, 0, b'1', b'1', b'1', '', '2022-11-04 23:47:49', '1', '2022-11-05 12:27:56', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2042, '满减送活动查询', 'promotion:reward-activity:query', 3, 1, 2041, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-04 23:47:49', '', '2022-11-04 23:47:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2043, '满减送活动创建', 'promotion:reward-activity:create', 3, 2, 2041, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-04 23:47:49', '', '2022-11-04 23:47:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2044, '满减送活动更新', 'promotion:reward-activity:update', 3, 3, 2041, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-04 23:47:50', '', '2022-11-04 23:47:50', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2045, '满减送活动删除', 'promotion:reward-activity:delete', 3, 4, 2041, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-04 23:47:50', '', '2022-11-04 23:47:50', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2046, '满减送活动关闭', 'promotion:reward-activity:close', 3, 5, 2041, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-11-05 10:42:53', '1', '2022-11-05 10:42:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2047, '限时折扣活动', '', 2, 7, 2030, 'discount-activity', 'time', 'mall/promotion/discountActivity/index', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:15', '1', '2022-11-29 22:14:56', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2048, '限时折扣活动查询', 'promotion:discount-activity:query', 3, 1, 2047, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:15', '', '2022-11-05 17:12:15', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2049, '限时折扣活动创建', 'promotion:discount-activity:create', 3, 2, 2047, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:15', '', '2022-11-05 17:12:15', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2050, '限时折扣活动更新', 'promotion:discount-activity:update', 3, 3, 2047, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:16', '', '2022-11-05 17:12:16', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2051, '限时折扣活动删除', 'promotion:discount-activity:delete', 3, 4, 2047, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:16', '', '2022-11-05 17:12:16', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2052, '限时折扣活动关闭', 'promotion:discount-activity:close', 3, 5, 2047, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-05 17:12:16', '', '2022-11-05 17:12:16', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2059, '秒杀活动管理', '', 2, 0, 2030, 'seckill-activity', 'time-range', 'mall/promotion/seckill/seckillActivity/index', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '1', '2022-11-29 22:24:39', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2060, '秒杀活动查询', 'promotion:seckill-activity:query', 3, 1, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '', '2022-11-06 22:24:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2061, '秒杀活动创建', 'promotion:seckill-activity:create', 3, 2, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '', '2022-11-06 22:24:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2062, '秒杀活动更新', 'promotion:seckill-activity:update', 3, 3, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '', '2022-11-06 22:24:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2063, '秒杀活动删除', 'promotion:seckill-activity:delete', 3, 4, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '', '2022-11-06 22:24:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2064, '秒杀活动导出', 'promotion:seckill-activity:export', 3, 5, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-06 22:24:49', '', '2022-11-06 22:24:49', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2065, '秒杀活动新增/修改', '', 2, 3, 2030, 'seckill-activity/edit', 'edit', 'promotion/seckillActivity/editTable', NULL, 0, b'0', b'1', b'1', '1', '2022-11-09 19:25:12', '1', '2022-11-29 21:46:16', b'1');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2066, '秒杀时段管理', '', 2, 0, 2030, 'seckill-time', '', 'mall/promotion/seckill/seckillTime/index', NULL, 0, b'0', b'1', b'1', '', '2022-11-15 19:46:50', '1', '2022-11-29 22:09:03', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2067, '秒杀时段查询', 'promotion:seckill-time:query', 3, 1, 2066, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-15 19:46:51', '', '2022-11-15 19:46:51', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2068, '秒杀时段创建', 'promotion:seckill-time:create', 3, 2, 2066, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-15 19:46:51', '', '2022-11-15 19:46:51', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2069, '秒杀时段更新', 'promotion:seckill-time:update', 3, 3, 2066, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-15 19:46:51', '', '2022-11-15 19:46:51', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2070, '秒杀时段删除', 'promotion:seckill-time:delete', 3, 4, 2066, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-15 19:46:51', '', '2022-11-15 19:46:51', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2071, '秒杀时段导出', 'promotion:seckill-time:export', 3, 5, 2066, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-15 19:46:51', '', '2022-11-15 19:46:51', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2072, '订单中心', '', 1, 65, 0, '/trade', 'order', NULL, NULL, 0, b'1', b'1', b'1', '1', '2022-11-19 18:57:19', '1', '2022-12-10 16:32:57', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2073, '售后退款', '', 2, 1, 2072, 'trade/after-sale', 'education', 'mall/trade/afterSale/index', NULL, 0, b'1', b'1', b'1', '', '2022-11-19 20:15:32', '1', '2022-12-10 21:11:02', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2074, '售后查询', 'trade:after-sale:query', 3, 1, 2073, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-11-19 20:15:33', '1', '2022-12-10 21:04:29', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2075, '秒杀活动关闭', 'promotion:sekill-activity:close', 3, 6, 2059, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2022-11-28 20:20:15', '1', '2022-11-28 20:20:15', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2076, '订单列表', '', 2, 0, 2072, 'trade/order', 'list', 'mall/trade/order/index', NULL, 0, b'1', b'1', b'1', '1', '2022-12-10 21:05:44', '1', '2022-12-10 21:08:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2077, '物流公司管理管理', '', 2, 0, 2072, 'express-company', '', 'mall/trade/expressCompany/index', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '1', '2022-12-20 23:36:20', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2078, '物流公司管理查询', 'trade:express-company:query', 3, 1, 2077, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '', '2022-12-20 23:27:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2079, '物流公司管理创建', 'trade:express-company:create', 3, 2, 2077, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '', '2022-12-20 23:27:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2080, '物流公司管理更新', 'trade:express-company:update', 3, 3, 2077, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '', '2022-12-20 23:27:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2081, '物流公司管理删除', 'trade:express-company:delete', 3, 4, 2077, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '', '2022-12-20 23:27:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2082, '物流公司管理导出', 'trade:express-company:export', 3, 5, 2077, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2022-12-20 23:27:55', '', '2022-12-20 23:27:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2083, '地区管理', '', 2, 14, 1, 'area', 'row', 'system/area/index', NULL, 0, b'1', b'1', b'1', '1', '2022-12-23 17:35:05', '1', '2022-12-23 17:35:48', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2084, '公众号管理', '', 1, 100, 0, '/mp', 'wechat', NULL, NULL, 0, b'1', b'1', b'1', '1', '2023-01-01 20:11:04', '1', '2023-01-15 11:28:57', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2085, '账号管理', '', 2, 1, 2084, 'account', 'phone', 'mp/account/index', 'MpAccount', 0, b'1', b'1', b'1', '1', '2023-01-01 20:13:31', '1', '2023-02-09 23:56:39', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2086, '新增账号', 'mp:account:create', 3, 1, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-01 20:21:40', '1', '2023-01-07 17:32:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2087, '修改账号', 'mp:account:update', 3, 2, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-07 17:32:46', '1', '2023-01-07 17:32:46', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2088, '查询账号', 'mp:account:query', 3, 0, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-07 17:33:07', '1', '2023-01-07 17:33:07', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2089, '删除账号', 'mp:account:delete', 3, 3, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-07 17:33:21', '1', '2023-01-07 17:33:21', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2090, '生成二维码', 'mp:account:qr-code', 3, 4, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-07 17:33:58', '1', '2023-01-07 17:33:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2091, '清空 API 配额', 'mp:account:clear-quota', 3, 5, 2085, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-07 18:20:32', '1', '2023-01-07 18:20:59', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2092, '数据统计', 'mp:statistics:query', 2, 2, 2084, 'statistics', 'chart', 'mp/statistics/index', 'MpStatistics', 0, b'1', b'1', b'1', '1', '2023-01-07 20:17:36', '1', '2023-02-09 23:58:34', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2093, '标签管理', '', 2, 3, 2084, 'tag', 'rate', 'mp/tag/index', 'MpTag', 0, b'1', b'1', b'1', '1', '2023-01-08 11:37:32', '1', '2023-02-09 23:58:47', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2094, '查询标签', 'mp:tag:query', 3, 0, 2093, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 11:59:03', '1', '2023-01-08 11:59:03', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2095, '新增标签', 'mp:tag:create', 3, 1, 2093, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 11:59:23', '1', '2023-01-08 11:59:23', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2096, '修改标签', 'mp:tag:update', 3, 2, 2093, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 11:59:41', '1', '2023-01-08 11:59:41', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2097, '删除标签', 'mp:tag:delete', 3, 3, 2093, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 12:00:04', '1', '2023-01-08 12:00:13', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2098, '同步标签', 'mp:tag:sync', 3, 4, 2093, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 12:00:29', '1', '2023-01-08 12:00:29', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2099, '粉丝管理', '', 2, 4, 2084, 'user', 'people', 'mp/user/index', 'MpUser', 0, b'1', b'1', b'1', '1', '2023-01-08 16:51:20', '1', '2023-02-09 23:58:21', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2100, '查询粉丝', 'mp:user:query', 3, 0, 2099, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 17:16:59', '1', '2023-01-08 17:17:23', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2101, '修改粉丝', 'mp:user:update', 3, 1, 2099, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 17:17:11', '1', '2023-01-08 17:17:11', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2102, '同步粉丝', 'mp:user:sync', 3, 2, 2099, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-08 17:17:40', '1', '2023-01-08 17:17:40', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2103, '消息管理', '', 2, 5, 2084, 'message', 'email', 'mp/message/index', 'MpMessage', 0, b'1', b'1', b'1', '1', '2023-01-08 18:44:19', '1', '2023-02-09 23:58:02', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2104, '图文发表记录', '', 2, 10, 2084, 'free-publish', 'education', 'mp/freePublish/index', 'MpFreePublish', 0, b'1', b'1', b'1', '1', '2023-01-13 00:30:50', '1', '2023-02-09 23:57:22', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2105, '查询发布列表', 'mp:free-publish:query', 3, 1, 2104, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-13 07:19:17', '1', '2023-01-13 07:19:17', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2106, '发布草稿', 'mp:free-publish:submit', 3, 2, 2104, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-13 07:19:46', '1', '2023-01-13 07:19:46', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2107, '删除发布记录', 'mp:free-publish:delete', 3, 3, 2104, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-13 07:20:01', '1', '2023-01-13 07:20:01', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2108, '图文草稿箱', '', 2, 9, 2084, 'draft', 'edit', 'mp/draft/index', 'MpDraft', 0, b'1', b'1', b'1', '1', '2023-01-13 07:40:21', '1', '2023-02-09 23:56:58', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2109, '新建草稿', 'mp:draft:create', 3, 1, 2108, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-13 23:15:30', '1', '2023-01-13 23:15:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2110, '修改草稿', 'mp:draft:update', 3, 2, 2108, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 10:08:47', '1', '2023-01-14 10:08:47', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2111, '查询草稿', 'mp:draft:query', 3, 0, 2108, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 10:09:01', '1', '2023-01-14 10:09:01', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2112, '删除草稿', 'mp:draft:delete', 3, 3, 2108, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 10:09:19', '1', '2023-01-14 10:09:19', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2113, '素材管理', '', 2, 8, 2084, 'material', 'skill', 'mp/material/index', 'MpMaterial', 0, b'1', b'1', b'1', '1', '2023-01-14 14:12:07', '1', '2023-02-09 23:57:36', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2114, '上传临时素材', 'mp:material:upload-temporary', 3, 1, 2113, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 15:33:55', '1', '2023-01-14 15:33:55', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2115, '上传永久素材', 'mp:material:upload-permanent', 3, 2, 2113, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 15:34:14', '1', '2023-01-14 15:34:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2116, '删除素材', 'mp:material:delete', 3, 3, 2113, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 15:35:37', '1', '2023-01-14 15:35:37', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2117, '上传图文图片', 'mp:material:upload-news-image', 3, 4, 2113, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 15:36:31', '1', '2023-01-14 15:36:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2118, '查询素材', 'mp:material:query', 3, 5, 2113, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-14 15:39:22', '1', '2023-01-14 15:39:22', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2119, '菜单管理', '', 2, 6, 2084, 'menu', 'button', 'mp/menu/index', 'MpMenu', 0, b'1', b'1', b'1', '1', '2023-01-14 17:43:54', '1', '2023-02-09 23:57:50', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2120, '自动回复', '', 2, 7, 2084, 'auto-reply', 'eye', 'mp/autoReply/index', 'MpAutoReply', 0, b'1', b'1', b'1', '1', '2023-01-15 22:13:09', '1', '2023-02-09 23:56:28', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2121, '查询回复', 'mp:auto-reply:query', 3, 0, 2120, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-16 22:28:41', '1', '2023-01-16 22:28:41', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2122, '新增回复', 'mp:auto-reply:create', 3, 1, 2120, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-16 22:28:54', '1', '2023-01-16 22:28:54', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2123, '修改回复', 'mp:auto-reply:update', 3, 2, 2120, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-16 22:29:05', '1', '2023-01-16 22:29:05', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2124, '删除回复', 'mp:auto-reply:delete', 3, 3, 2120, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-16 22:29:34', '1', '2023-01-16 22:29:34', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2125, '查询菜单', 'mp:menu:query', 3, 0, 2119, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-17 23:05:41', '1', '2023-01-17 23:05:41', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2126, '保存菜单', 'mp:menu:save', 3, 1, 2119, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-17 23:06:01', '1', '2023-01-17 23:06:01', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2127, '删除菜单', 'mp:menu:delete', 3, 2, 2119, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-17 23:06:16', '1', '2023-01-17 23:06:16', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2128, '查询消息', 'mp:message:query', 3, 0, 2103, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-17 23:07:14', '1', '2023-01-17 23:07:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2129, '发送消息', 'mp:message:send', 3, 1, 2103, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-17 23:07:26', '1', '2023-01-17 23:07:26', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2130, '邮箱管理', '', 2, 11, 1, 'mail', 'email', NULL, NULL, 0, b'1', b'1', b'1', '1', '2023-01-25 17:27:44', '1', '2023-01-25 17:27:44', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2131, '邮箱账号', '', 2, 0, 2130, 'mail-account', 'user', 'system/mail/account/index', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 09:33:48', '1', '2023-01-26 16:37:37', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2132, '账号查询', 'system:mail-account:query', 3, 1, 2131, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 09:33:48', '', '2023-01-25 09:33:48', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2133, '账号创建', 'system:mail-account:create', 3, 2, 2131, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 09:33:48', '', '2023-01-25 09:33:48', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2134, '账号更新', 'system:mail-account:update', 3, 3, 2131, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 09:33:48', '', '2023-01-25 09:33:48', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2135, '账号删除', 'system:mail-account:delete', 3, 4, 2131, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 09:33:48', '', '2023-01-25 09:33:48', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2136, '邮件模版', '', 2, 0, 2130, 'mail-template', 'education', 'system/mail/template/index', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 12:05:31', '1', '2023-01-26 16:38:35', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2137, '模版查询', 'system:mail-template:query', 3, 1, 2136, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 12:05:31', '', '2023-01-25 12:05:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2138, '模版创建', 'system:mail-template:create', 3, 2, 2136, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 12:05:31', '', '2023-01-25 12:05:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2139, '模版更新', 'system:mail-template:update', 3, 3, 2136, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 12:05:31', '', '2023-01-25 12:05:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2140, '模版删除', 'system:mail-template:delete', 3, 4, 2136, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-25 12:05:31', '', '2023-01-25 12:05:31', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2141, '邮件记录', '', 2, 0, 2130, 'mail-log', 'log', 'system/mail/log/index', NULL, 0, b'1', b'1', b'1', '', '2023-01-26 02:16:50', '1', '2023-01-26 16:38:27', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2142, '日志查询', 'system:mail-log:query', 3, 1, 2141, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-26 02:16:50', '', '2023-01-26 02:16:50', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2143, '发送测试邮件', 'system:mail-template:send-mail', 3, 5, 2136, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-26 23:29:15', '1', '2023-01-26 23:29:15', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2144, '站内信管理', '', 1, 11, 1, 'notify', 'message', NULL, NULL, 0, b'1', b'1', b'1', '1', '2023-01-28 10:25:18', '1', '2023-01-28 10:25:46', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2145, '模板管理', '', 2, 0, 2144, 'notify-template', 'education', 'system/notify/template/index', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 02:26:42', '1', '2023-01-28 10:27:47', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2146, '站内信模板查询', 'system:notify-template:query', 3, 1, 2145, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 02:26:42', '', '2023-01-28 02:26:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2147, '站内信模板创建', 'system:notify-template:create', 3, 2, 2145, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 02:26:42', '', '2023-01-28 02:26:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2148, '站内信模板更新', 'system:notify-template:update', 3, 3, 2145, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 02:26:42', '', '2023-01-28 02:26:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2149, '站内信模板删除', 'system:notify-template:delete', 3, 4, 2145, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 02:26:42', '', '2023-01-28 02:26:42', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2150, '发送测试站内信', 'system:notify-template:send-notify', 3, 5, 2145, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-01-28 10:54:43', '1', '2023-01-28 10:54:43', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2151, '消息记录', '', 2, 0, 2144, 'notify-message', 'edit', 'system/notify/message/index', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 04:28:22', '1', '2023-01-28 20:59:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2152, '站内信消息查询', 'system:notify-message:query', 3, 1, 2151, '', '', '', NULL, 0, b'1', b'1', b'1', '', '2023-01-28 04:28:22', '', '2023-01-28 04:28:22', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2153, '大屏设计器', '', 2, 2, 1281, 'go-view', 'dashboard', 'report/goview/index', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 00:03:19', '1', '2023-02-07 00:03:30', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2154, '创建项目', 'report:go-view-project:create', 3, 1, 2153, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 19:25:14', '1', '2023-02-07 19:25:14', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2155, '更新项目', 'report:go-view-project:delete', 3, 2, 2153, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 19:25:34', '1', '2023-02-07 19:25:34', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2156, '查询项目', 'report:go-view-project:query', 3, 0, 2153, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 19:25:53', '1', '2023-02-07 19:25:53', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2157, '使用 SQL 查询数据', 'report:go-view-data:get-by-sql', 3, 3, 2153, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 19:26:15', '1', '2023-02-07 19:26:15', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2158, '使用 HTTP 查询数据', 'report:go-view-data:get-by-http', 3, 4, 2153, '', '', '', NULL, 0, b'1', b'1', b'1', '1', '2023-02-07 19:26:35', '1', '2023-02-07 19:26:35', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2159, 'Boot 开发文档', '', 1, 1, 0, 'https://doc.iocoder.cn/', 'education', NULL, NULL, 0, b'1', b'1', b'1', '1', '2023-02-10 22:46:28', '1', '2023-02-10 22:46:28', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2160, 'Cloud 开发文档', '', 1, 2, 0, 'https://cloud.iocoder.cn', 'documentation', NULL, NULL, 0, b'1', b'1', b'1', '1', '2023-02-10 22:47:07', '1', '2023-02-10 22:47:07', b'0');
INSERT INTO `system_menu` (`id`, `name`, `permission`, `type`, `sort`, `parent_id`, `path`, `icon`, `component`, `component_name`, `status`, `visible`, `keep_alive`, `always_show`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2161, '接入示例', '', 2, 99, 1117, 'demo-order', 'drag', 'pay/demo/index', NULL, 0, b'1', b'1', b'1', '', '2023-02-11 14:21:42', '1', '2023-02-11 22:26:35', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_notify_template
-- ----------------------------
DROP TABLE IF EXISTS `system_notify_template`;
CREATE TABLE `system_notify_template` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板名称',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模版编码',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送人名称',
  `content` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模版内容',
  `type` tinyint NOT NULL COMMENT '类型',
  `params` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '参数数组',
  `status` tinyint NOT NULL COMMENT '状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='站内信模板表';

-- ----------------------------
-- Records of system_notify_template
-- ----------------------------
BEGIN;
INSERT INTO `system_notify_template` (`id`, `name`, `code`, `nickname`, `content`, `type`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, '测试1', 'test', '123', '我是 {name}，我开始 {what} 了', 1, '[\"name\",\"what\"]', 0, '12345', '1', '2023-01-28 10:50:23', '1', '2023-01-28 22:21:18', b'0');
INSERT INTO `system_notify_template` (`id`, `name`, `code`, `nickname`, `content`, `type`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, '注册通知', 'register', '系统消息', '你好，欢迎 {name} 加入大家庭！', 2, '[\"name\"]', 0, NULL, '1', '2023-01-28 21:00:44', '1', '2023-01-28 21:00:44', b'0');
INSERT INTO `system_notify_template` (`id`, `name`, `code`, `nickname`, `content`, `type`, `params`, `status`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (3, '3', '3', '4', '5', 2, '[]', 1, '6', '1', '2023-01-28 23:27:05', '1', '2023-01-28 15:27:47', b'1');
COMMIT;

-- ----------------------------
-- Table structure for system_oauth2_access_token
-- ----------------------------
DROP TABLE IF EXISTS `system_oauth2_access_token`;
CREATE TABLE `system_oauth2_access_token` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `user_id` bigint NOT NULL COMMENT '用户编号',
  `user_type` tinyint NOT NULL COMMENT '用户类型',
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '访问令牌',
  `refresh_token` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '刷新令牌',
  `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端编号',
  `scopes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '授权范围',
  `expires_time` datetime NOT NULL COMMENT '过期时间',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1690 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OAuth2 访问令牌';

-- ----------------------------
-- Records of system_oauth2_access_token
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for system_oauth2_approve
-- ----------------------------
DROP TABLE IF EXISTS `system_oauth2_approve`;
CREATE TABLE `system_oauth2_approve` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `user_id` bigint NOT NULL COMMENT '用户编号',
  `user_type` tinyint NOT NULL COMMENT '用户类型',
  `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端编号',
  `scope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '授权范围',
  `approved` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否接受',
  `expires_time` datetime NOT NULL COMMENT '过期时间',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OAuth2 批准表';

-- ----------------------------
-- Records of system_oauth2_approve
-- ----------------------------
BEGIN;
INSERT INTO `system_oauth2_approve` (`id`, `user_id`, `user_type`, `client_id`, `scope`, `approved`, `expires_time`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (78, 1, 2, 'default', 'user.read', b'1', '2022-07-18 20:01:43', '1', '2022-05-24 00:48:02', '1', '2022-06-18 20:01:43', b'0', 1);
INSERT INTO `system_oauth2_approve` (`id`, `user_id`, `user_type`, `client_id`, `scope`, `approved`, `expires_time`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (79, 1, 2, 'default', 'user.write', b'0', '2022-07-18 20:01:43', '1', '2022-05-24 00:48:02', '1', '2022-06-18 20:01:43', b'0', 1);
INSERT INTO `system_oauth2_approve` (`id`, `user_id`, `user_type`, `client_id`, `scope`, `approved`, `expires_time`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (80, 1, 2, 'yudao-sso-demo-by-code', 'user.read', b'1', '2022-11-04 21:33:47', '1', '2022-09-29 20:30:14', '1', '2022-10-05 21:33:47', b'0', 1);
INSERT INTO `system_oauth2_approve` (`id`, `user_id`, `user_type`, `client_id`, `scope`, `approved`, `expires_time`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (81, 1, 2, 'yudao-sso-demo-by-code', 'user.write', b'0', '2022-11-04 21:33:47', '1', '2022-09-29 20:30:15', '1', '2022-10-05 21:33:47', b'0', 1);
COMMIT;

-- ----------------------------
-- Table structure for system_oauth2_client
-- ----------------------------
DROP TABLE IF EXISTS `system_oauth2_client`;
CREATE TABLE `system_oauth2_client` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端编号',
  `secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端密钥',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用名',
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用图标',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '应用描述',
  `status` tinyint NOT NULL COMMENT '状态',
  `access_token_validity_seconds` int NOT NULL COMMENT '访问令牌的有效期',
  `refresh_token_validity_seconds` int NOT NULL COMMENT '刷新令牌的有效期',
  `redirect_uris` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '可重定向的 URI 地址',
  `authorized_grant_types` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '授权类型',
  `scopes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '授权范围',
  `auto_approve_scopes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '自动通过的授权范围',
  `authorities` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '权限',
  `resource_ids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '资源',
  `additional_information` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '附加信息',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OAuth2 客户端表';

-- ----------------------------
-- Records of system_oauth2_client
-- ----------------------------
BEGIN;
INSERT INTO `system_oauth2_client` (`id`, `client_id`, `secret`, `name`, `logo`, `description`, `status`, `access_token_validity_seconds`, `refresh_token_validity_seconds`, `redirect_uris`, `authorized_grant_types`, `scopes`, `auto_approve_scopes`, `authorities`, `resource_ids`, `additional_information`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, 'default', 'admin123', '芋道源码', 'http://test.yudao.iocoder.cn/a5e2e244368878a366b516805a4aabf1.png', '我是描述', 0, 1800, 43200, '[\"https://www.iocoder.cn\",\"https://doc.iocoder.cn\"]', '[\"password\",\"authorization_code\",\"implicit\",\"refresh_token\"]', '[\"user.read\",\"user.write\"]', '[]', '[\"user.read\",\"user.write\"]', '[]', '{}', '1', '2022-05-11 21:47:12', '1', '2022-07-05 16:23:52', b'0');
INSERT INTO `system_oauth2_client` (`id`, `client_id`, `secret`, `name`, `logo`, `description`, `status`, `access_token_validity_seconds`, `refresh_token_validity_seconds`, `redirect_uris`, `authorized_grant_types`, `scopes`, `auto_approve_scopes`, `authorities`, `resource_ids`, `additional_information`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (40, 'test', 'test2', 'biubiu', 'http://test.yudao.iocoder.cn/277a899d573723f1fcdfb57340f00379.png', NULL, 0, 1800, 43200, '[\"https://www.iocoder.cn\"]', '[\"password\",\"authorization_code\",\"implicit\"]', '[\"user_info\",\"projects\"]', '[\"user_info\"]', '[]', '[]', '{}', '1', '2022-05-12 00:28:20', '1', '2022-06-19 00:26:13', b'0');
INSERT INTO `system_oauth2_client` (`id`, `client_id`, `secret`, `name`, `logo`, `description`, `status`, `access_token_validity_seconds`, `refresh_token_validity_seconds`, `redirect_uris`, `authorized_grant_types`, `scopes`, `auto_approve_scopes`, `authorities`, `resource_ids`, `additional_information`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (41, 'yudao-sso-demo-by-code', 'test', '基于授权码模式，如何实现 SSO 单点登录？', 'http://test.yudao.iocoder.cn/fe4ed36596adad5120036ef61a6d0153654544d44af8dd4ad3ffe8f759933d6f.png', NULL, 0, 1800, 43200, '[\"http://127.0.0.1:18080\"]', '[\"authorization_code\",\"refresh_token\"]', '[\"user.read\",\"user.write\"]', '[]', '[]', '[]', NULL, '1', '2022-09-29 13:28:31', '1', '2022-09-29 13:28:31', b'0');
INSERT INTO `system_oauth2_client` (`id`, `client_id`, `secret`, `name`, `logo`, `description`, `status`, `access_token_validity_seconds`, `refresh_token_validity_seconds`, `redirect_uris`, `authorized_grant_types`, `scopes`, `auto_approve_scopes`, `authorities`, `resource_ids`, `additional_information`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (42, 'yudao-sso-demo-by-password', 'test', '基于密码模式，如何实现 SSO 单点登录？', 'http://test.yudao.iocoder.cn/604bdc695e13b3b22745be704d1f2aa8ee05c5f26f9fead6d1ca49005afbc857.jpeg', NULL, 0, 1800, 43200, '[\"http://127.0.0.1:18080\"]', '[\"password\",\"refresh_token\"]', '[\"user.read\",\"user.write\"]', '[]', '[]', '[]', NULL, '1', '2022-10-04 17:40:16', '1', '2022-10-04 20:31:21', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_oauth2_code
-- ----------------------------
DROP TABLE IF EXISTS `system_oauth2_code`;
CREATE TABLE `system_oauth2_code` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `user_id` bigint NOT NULL COMMENT '用户编号',
  `user_type` tinyint NOT NULL COMMENT '用户类型',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '授权码',
  `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端编号',
  `scopes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '授权范围',
  `expires_time` datetime NOT NULL COMMENT '过期时间',
  `redirect_uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '可重定向的 URI 地址',
  `state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '状态',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OAuth2 授权码表';

-- ----------------------------
-- Records of system_oauth2_code
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for system_oauth2_refresh_token
-- ----------------------------
DROP TABLE IF EXISTS `system_oauth2_refresh_token`;
CREATE TABLE `system_oauth2_refresh_token` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `user_id` bigint NOT NULL COMMENT '用户编号',
  `refresh_token` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '刷新令牌',
  `user_type` tinyint NOT NULL COMMENT '用户类型',
  `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端编号',
  `scopes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '授权范围',
  `expires_time` datetime NOT NULL COMMENT '过期时间',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=735 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='OAuth2 刷新令牌';

-- ----------------------------
-- Records of system_oauth2_refresh_token
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for system_sensitive_word
-- ----------------------------
DROP TABLE IF EXISTS `system_sensitive_word`;
CREATE TABLE `system_sensitive_word` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '敏感词',
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '描述',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '标签数组',
  `status` tinyint NOT NULL COMMENT '状态',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='敏感词';

-- ----------------------------
-- Records of system_sensitive_word
-- ----------------------------
BEGIN;
INSERT INTO `system_sensitive_word` (`id`, `name`, `description`, `tags`, `status`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (3, '土豆', '好呀', '蔬菜,短信', 0, '1', '2022-04-08 21:07:12', '1', '2022-04-09 10:28:14', b'0');
INSERT INTO `system_sensitive_word` (`id`, `name`, `description`, `tags`, `status`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (4, 'XXX', NULL, '短信', 0, '1', '2022-04-08 21:27:49', '1', '2022-06-19 00:36:50', b'0');
INSERT INTO `system_sensitive_word` (`id`, `name`, `description`, `tags`, `status`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (5, '白痴', NULL, '测试', 0, '1', '2022-12-31 19:08:25', '1', '2022-12-31 19:08:25', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_sms_channel
-- ----------------------------
DROP TABLE IF EXISTS `system_sms_channel`;
CREATE TABLE `system_sms_channel` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `signature` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信签名',
  `code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '渠道编码',
  `status` tinyint NOT NULL COMMENT '开启状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `api_key` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信 API 的账号',
  `api_secret` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信 API 的秘钥',
  `callback_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信发送回调 URL',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='短信渠道';

-- ----------------------------
-- Records of system_sms_channel
-- ----------------------------
BEGIN;
INSERT INTO `system_sms_channel` (`id`, `signature`, `code`, `status`, `remark`, `api_key`, `api_secret`, `callback_url`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, 'Ballcat', 'ALIYUN', 0, '啦啦啦', 'LTAI5tCnKso2uG3kJ5gRav88', 'fGJ5SNXL7P1NHNRmJ7DJaMJGPyE55C', NULL, '', '2021-03-31 11:53:10', '1', '2021-04-14 00:08:37', b'0');
INSERT INTO `system_sms_channel` (`id`, `signature`, `code`, `status`, `remark`, `api_key`, `api_secret`, `callback_url`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (4, '测试渠道', 'DEBUG_DING_TALK', 0, '123', '696b5d8ead48071237e4aa5861ff08dbadb2b4ded1c688a7b7c9afc615579859', 'SEC5c4e5ff888bc8a9923ae47f59e7ccd30af1f14d93c55b4e2c9cb094e35aeed67', NULL, '1', '2021-04-13 00:23:14', '1', '2022-03-27 20:29:49', b'0');
INSERT INTO `system_sms_channel` (`id`, `signature`, `code`, `status`, `remark`, `api_key`, `api_secret`, `callback_url`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (6, '测试演示', 'DEBUG_DING_TALK', 0, NULL, '696b5d8ead48071237e4aa5861ff08dbadb2b4ded1c688a7b7c9afc615579859', 'SEC5c4e5ff888bc8a9923ae47f59e7ccd30af1f14d93c55b4e2c9cb094e35aeed67', NULL, '1', '2022-04-10 23:07:59', '1', '2022-06-19 00:33:54', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_sms_code
-- ----------------------------
DROP TABLE IF EXISTS `system_sms_code`;
CREATE TABLE `system_sms_code` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号',
  `code` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '验证码',
  `create_ip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '创建 IP',
  `scene` tinyint NOT NULL COMMENT '发送场景',
  `today_index` tinyint NOT NULL COMMENT '今日发送的第几条',
  `used` tinyint NOT NULL COMMENT '是否使用',
  `used_time` datetime DEFAULT NULL COMMENT '使用时间',
  `used_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '使用 IP',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT '0' COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_mobile` (`mobile`) USING BTREE COMMENT '手机号'
) ENGINE=InnoDB AUTO_INCREMENT=484 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='手机验证码';

-- ----------------------------
-- Records of system_sms_code
-- ----------------------------
BEGIN;
INSERT INTO `system_sms_code` (`id`, `mobile`, `code`, `create_ip`, `scene`, `today_index`, `used`, `used_time`, `used_ip`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (479, '15601691300', '9999', '127.0.0.1', 21, 1, 1, '2022-07-09 23:03:21', '127.0.0.1', NULL, '2022-07-09 23:02:07', NULL, '2022-07-09 23:03:21', b'0', 1);
INSERT INTO `system_sms_code` (`id`, `mobile`, `code`, `create_ip`, `scene`, `today_index`, `used`, `used_time`, `used_ip`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (480, '15601691399', '9999', '127.0.0.1', 1, 1, 0, NULL, NULL, NULL, '2022-08-01 22:47:41', NULL, '2022-08-01 22:47:41', b'0', 1);
INSERT INTO `system_sms_code` (`id`, `mobile`, `code`, `create_ip`, `scene`, `today_index`, `used`, `used_time`, `used_ip`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (481, '15601691399', '9999', '127.0.0.1', 1, 1, 0, NULL, NULL, NULL, '2022-12-10 21:23:02', NULL, '2022-12-10 21:23:02', b'0', 1);
INSERT INTO `system_sms_code` (`id`, `mobile`, `code`, `create_ip`, `scene`, `today_index`, `used`, `used_time`, `used_ip`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (482, '15601691340', '9999', '127.0.0.1', 1, 1, 0, NULL, NULL, NULL, '2022-12-10 21:23:58', NULL, '2022-12-10 21:23:58', b'0', 1);
INSERT INTO `system_sms_code` (`id`, `mobile`, `code`, `create_ip`, `scene`, `today_index`, `used`, `used_time`, `used_ip`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (483, '15601691399', '9999', '127.0.0.1', 1, 2, 0, NULL, NULL, NULL, '2022-12-10 21:27:42', NULL, '2022-12-10 21:27:42', b'0', 1);
COMMIT;

-- ----------------------------
-- Table structure for system_sms_log
-- ----------------------------
DROP TABLE IF EXISTS `system_sms_log`;
CREATE TABLE `system_sms_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `channel_id` bigint NOT NULL COMMENT '短信渠道编号',
  `channel_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信渠道编码',
  `template_id` bigint NOT NULL COMMENT '模板编号',
  `template_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板编码',
  `template_type` tinyint NOT NULL COMMENT '短信类型',
  `template_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信内容',
  `template_params` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信参数',
  `api_template_id` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信 API 的模板编号',
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号',
  `user_id` bigint DEFAULT NULL COMMENT '用户编号',
  `user_type` tinyint DEFAULT NULL COMMENT '用户类型',
  `send_status` tinyint NOT NULL DEFAULT '0' COMMENT '发送状态',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `send_code` int DEFAULT NULL COMMENT '发送结果的编码',
  `send_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '发送结果的提示',
  `api_send_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信 API 发送结果的编码',
  `api_send_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信 API 发送失败的提示',
  `api_request_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信 API 发送返回的唯一请求 ID',
  `api_serial_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '短信 API 发送返回的序号',
  `receive_status` tinyint NOT NULL DEFAULT '0' COMMENT '接收状态',
  `receive_time` datetime DEFAULT NULL COMMENT '接收时间',
  `api_receive_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'API 接收结果的编码',
  `api_receive_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'API 接收结果的说明',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=348 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='短信日志';

-- ----------------------------
-- Records of system_sms_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for system_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `system_sms_template`;
CREATE TABLE `system_sms_template` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `type` tinyint NOT NULL COMMENT '短信签名',
  `status` tinyint NOT NULL COMMENT '开启状态',
  `code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板编码',
  `name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板名称',
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模板内容',
  `params` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数数组',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `api_template_id` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信 API 的模板编号',
  `channel_id` bigint NOT NULL COMMENT '短信渠道编号',
  `channel_code` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '短信渠道编码',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='短信模板';

-- ----------------------------
-- Records of system_sms_template
-- ----------------------------
BEGIN;
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, 1, 0, 'test_01', '测试验证码短信', '正在进行登录操作{operation}，您的验证码是{code}', '[\"operation\",\"code\"]', NULL, '4383920', 6, 'DEBUG_DING_TALK', '', '2021-03-31 10:49:38', '1', '2022-12-10 21:26:20', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (3, 1, 0, 'test_02', '公告通知', '您的验证码{code}，该验证码5分钟内有效，请勿泄漏于他人！', '[\"code\"]', NULL, 'SMS_207945135', 2, 'ALIYUN', '', '2021-03-31 11:56:30', '1', '2021-04-10 01:22:02', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (6, 3, 0, 'test-01', '测试模板', '哈哈哈 {name}', '[\"name\"]', 'f哈哈哈', '4383920', 6, 'DEBUG_DING_TALK', '1', '2021-04-10 01:07:21', '1', '2022-12-10 21:26:09', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (7, 3, 0, 'test-04', '测试下', '老鸡{name}，牛逼{code}', '[\"name\",\"code\"]', NULL, 'suibian', 4, 'DEBUG_DING_TALK', '1', '2021-04-13 00:29:53', '1', '2021-04-14 00:30:38', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (8, 1, 0, 'user-sms-login', '前台用户短信登录', '您的验证码是{code}', '[\"code\"]', NULL, '4372216', 6, 'DEBUG_DING_TALK', '1', '2021-10-11 08:10:00', '1', '2022-12-10 21:25:59', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (9, 2, 0, 'bpm_task_assigned', '【工作流】任务被分配', '您收到了一条新的待办任务：{processInstanceName}-{taskName}，申请人：{startUserNickname}，处理链接：{detailUrl}', '[\"processInstanceName\",\"taskName\",\"startUserNickname\",\"detailUrl\"]', NULL, 'suibian', 4, 'DEBUG_DING_TALK', '1', '2022-01-21 22:31:19', '1', '2022-01-22 00:03:36', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (10, 2, 0, 'bpm_process_instance_reject', '【工作流】流程被不通过', '您的流程被审批不通过：{processInstanceName}，原因：{reason}，查看链接：{detailUrl}', '[\"processInstanceName\",\"reason\",\"detailUrl\"]', NULL, 'suibian', 4, 'DEBUG_DING_TALK', '1', '2022-01-22 00:03:31', '1', '2022-05-01 12:33:14', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (11, 2, 0, 'bpm_process_instance_approve', '【工作流】流程被通过', '您的流程被审批通过：{processInstanceName}，查看链接：{detailUrl}', '[\"processInstanceName\",\"detailUrl\"]', NULL, 'suibian', 4, 'DEBUG_DING_TALK', '1', '2022-01-22 00:04:31', '1', '2022-03-27 20:32:21', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (12, 2, 0, 'demo', '演示模板', '我就是测试一下下', '[]', NULL, 'biubiubiu', 6, 'DEBUG_DING_TALK', '1', '2022-04-10 23:22:49', '1', '2022-04-10 23:22:49', b'0');
INSERT INTO `system_sms_template` (`id`, `type`, `status`, `code`, `name`, `content`, `params`, `remark`, `api_template_id`, `channel_id`, `channel_code`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (13, 1, 0, 'admin-sms-login', '后台用户短信登录', '您的验证码是{code}', '[\"code\"]', '', '4372216', 6, 'DEBUG_DING_TALK', '1', '2021-10-11 08:10:00', '1', '2022-12-10 21:25:51', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_tenant
-- ----------------------------
DROP TABLE IF EXISTS `system_tenant`;
CREATE TABLE `system_tenant` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '租户编号',
  `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '租户名',
  `contact_user_id` bigint DEFAULT NULL COMMENT '联系人的用户编号',
  `contact_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '联系人',
  `contact_mobile` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '联系手机',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '租户状态（0正常 1停用）',
  `domain` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '绑定域名',
  `package_id` bigint NOT NULL COMMENT '租户套餐编号',
  `expire_time` datetime NOT NULL COMMENT '过期时间',
  `account_count` int NOT NULL COMMENT '账号数量',
  `data_source_config_id` bigint NOT NULL DEFAULT '0' COMMENT '数据源配置编号',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='租户表';

-- ----------------------------
-- Records of system_tenant
-- ----------------------------
BEGIN;
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (1, '芋道源码', NULL, '芋艿', '17321315478', 0, 'https://www.iocoder.cn', 0, '2099-02-19 17:14:16', 9999, 1, '1', '2021-01-05 17:03:47', '1', '2023-02-26 00:58:40', b'0');
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2, '测试租户', 126, '阿2', NULL, 0, 'http://www.baidu.com', 111, '2023-02-25 00:00:00', 100, 1, '1', '2023-02-26 00:02:05', '1', '2023-02-27 22:05:43', b'0');
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (121, '小租户', 110, '小王2', '15601691300', 0, 'http://www.iocoder.cn', 111, '2024-03-11 00:00:00', 20, 0, '1', '2022-02-22 00:56:14', '1', '2022-05-17 10:03:59', b'0');
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2171, '租户a', 124, '土豆', NULL, 0, 'http://www.iocoder.cn', 112, '2023-03-01 00:00:00', 100, 1, '1', '2023-02-27 22:15:29', '1', '2023-02-27 22:28:10', b'0');
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2172, '租户b', 123, '阿毛', NULL, 0, 'http://www.iocoder.cn', 112, '2023-02-22 00:00:00', 100, 12, '1', '2023-02-27 22:23:36', '1', '2023-02-27 22:23:36', b'0');
INSERT INTO `system_tenant` (`id`, `name`, `contact_user_id`, `contact_name`, `contact_mobile`, `status`, `domain`, `package_id`, `expire_time`, `account_count`, `data_source_config_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (2173, '土豆租户', 125, '土豆', NULL, 0, 'https://www.iocoder.cn', 112, '2023-03-31 00:00:00', 50, 1, '1', '2023-03-01 21:56:37', '1', '2023-03-01 21:56:37', b'0');
COMMIT;

-- ----------------------------
-- Table structure for system_tenant_package
-- ----------------------------
DROP TABLE IF EXISTS `system_tenant_package`;
CREATE TABLE `system_tenant_package` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '套餐编号',
  `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '套餐名',
  `status` tinyint NOT NULL DEFAULT '0' COMMENT '租户状态（0正常 1停用）',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注',
  `menu_ids` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关联的菜单编号',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='租户套餐表';

-- ----------------------------
-- Records of system_tenant_package
-- ----------------------------
BEGIN;
INSERT INTO `system_tenant_package` (`id`, `name`, `status`, `remark`, `menu_ids`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (111, '普通套餐', 0, '小功能', '[1,1036,1037,1038,1039,100,101,102,1063,103,1064,1001,1065,1002,1003,107,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020]', '1', '2022-02-22 00:54:00', '1', '2023-02-26 00:56:53', b'0');
INSERT INTO `system_tenant_package` (`id`, `name`, `status`, `remark`, `menu_ids`, `creator`, `create_time`, `updater`, `update_time`, `deleted`) VALUES (112, '萌新套餐', 0, '', '[1,2,1031,1032,1033,1034,1035,1050,1051,1052,1053,1054,1056,1057,1058,1059,1060,1066,1067,1070,1071,1072,1073,1074,1075,1076,1077,1078,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1117,100,1126,1127,1128,1129,106,1130,1131,1132,1133,110,1134,111,1135,112,1136,113,1137,2161,114,115,116,1150,1161,1162,1163,1164,1165,1166,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1237,1238,1239,1240,1241,1242,1243,1255,1256,1001,1257,1002,1258,1003,1259,1004,1260,1005,1006,1007]', '1', '2023-02-26 00:53:09', '1', '2023-02-27 22:28:30', b'0');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
